// Vertex shader
uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform float ShiftT;
uniform float ScaleX;
uniform float ScaleY;
uniform vec3 g_ViewerPos;
uniform mat4 ShadowTM;
uniform mat4 g_NrmMatrix;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;

//VS_OUTPUT
	out vec4 oPos; 
	out vec4 oColor;
	out vec3 oVDir; 
	out vec3 oNormal;    
	out vec3 oWorldPos;
	out vec3 oRawPos;
	out vec3 oRawNormal;


void main()
{
	vec4 P 	= vec4(Pos,1.0);
	vec4 iWorldPos = P;
	oWorldPos = iWorldPos.xyz;
	oVDir 	= normalize((iWorldPos.xyz-g_ViewerPos));
	oPos 	= P * g_WorldViewProjectionMatrix;
	vec4 N=vec4(Normal,0.0);
//	oNormal = vec3(N * g_NrmMatrix);
	oNormal = vec3(N * g_WorldMatrix);
	oColor	= Color;

	oRawNormal = Normal;
	oRawPos = Pos;

	gl_Position = oPos;
}    
	
// Pixel shader
	in vec4 oPos; 
	in vec4 oColor;
	in vec3 oVDir; 
	in vec3 oNormal;    

out vec4 FragColor;

uniform mat4 g_WorldViewProjectionMatrix;
	
uniform sampler2D Panorama;
uniform float PanoramaShift;
uniform	float RefShade;
uniform float GlossInv;
	
	
uniform mat4 g_NormalViewMatrix;
uniform vec3  LDir;
uniform vec3  LDir2;
uniform float LDiffuseC;
uniform float LDiffuse22C;
uniform float LAmbient;
uniform float FreezeInv;
uniform vec4 LightColor;
uniform mat3 WPanMatrix;
uniform vec4 Freshnel;
uniform vec4 mip_ref;
uniform float Denorm;
uniform float fBumpness;	
uniform float fGlossMod;
uniform float fMetallMod;
uniform float fClip;
uniform mat3 g_ViewWorldMatrix3;

uniform vec4 Color;	
	
#define NO_FREEZE
#define TC_DEFINED
#define MODULATE_GM
#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"
	
void main() 
{
	//if(fClip*min(oUV.x*(1.0-oUV.x), oUV.y*(1.0-oUV.y)) < -0.0001)discard;
	vec4  sfColor  =  Color;
	vec4  sfSpecular = vec4(0,0,0,0.33);
	
	vec3 GlobalNormal = oNormal;
	vec3 Normal = GlobalNormal;	
 	vec3 ViewDir = oVDir;
	float UseACES = 0;
	
	vec3 ReflectionDir = normalize(ViewDir-2*Normal*dot(ViewDir,Normal));
	ReflectionDir = normalize(ReflectionDir * WPanMatrix);
	Normal = normalize(Normal * WPanMatrix);
	ViewDir = normalize(oVDir * WPanMatrix);
	
	float Emissive = 0.0;
	float Opacity = Color.w;
	vec4 Color = sfColor;
	float GlossModulator=1.0;
	float MetallModulator=0.0;
#include "/Templates/ggx_layers.glsl"
#include "/Templates/ggx_light_core.glsl"
	color.w = Opacity;
	//if(color.w<0.1)discard;
	FragColor = color;
}