// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_UV;
out vec3 v_sp;
out float v_Op;

// Used in included "ggx_variables" and "ggx_light_core"
out vec3 oRawNormal;
out vec3 oRawPos;

void main() {
	v_UV.x = TexCoord0.x;
	v_UV.y = 1.0-TexCoord0.y;
	
	vec4 sp;
#ifdef SCREEN_SPACE
	sp = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	sp = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif
        gl_Position = sp;
	sp.z=0;
	v_sp=sp.xyz/sp.w;
	v_Color = Color;
	v_Op = v_Color.w;
    oRawNormal = vec3(0.0);
    oRawPos = vec3(0.0);
}

// Fragment shader

in vec4 v_Color;
in vec2 v_UV;
in vec3 v_sp;
in float v_Op;

out vec4 FragColor;

uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;
uniform sampler2D s_Sampler2;
uniform sampler2D Panorama;


uniform mat3 PanMatrix;
uniform mat3 WPanMatrix;
uniform float PanoramaShift;

uniform mat4 g_NormalViewMatrix;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform vec3   VDir;
uniform float  LDiffuseC;
uniform float  LDiffuse22C;
uniform float  LAmbient;
uniform vec4   Freshnel;
uniform vec4   mip_ref;
uniform vec3   RDir;
uniform vec3   UDir;
uniform vec3   FDir;


#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"

void main() {
	vec4  sfColor  = texture(s_Sampler0,v_UV);
	sfColor.w*=v_Op;
	vec4  nrm = texture(s_Sampler1,v_UV);   
	vec3  Ns = normalize(nrm.xyz*2.0-1.0);	
	vec4  sfSpecular = texture(s_Sampler2,v_UV);
	vec4  color;

	vec3  vd = normalize(FDir+v_sp.x*RDir*2.0+v_sp.y*UDir);

	
	vec3  Normal = normalize(Ns.x*RDir+Ns.y*UDir+Ns.z*FDir);	
	vec3  GlobalNormal = Normal;	
	vec3  ReflectionDir = normalize(vd-2*Normal*dot(vd,Normal));

	ReflectionDir = normalize(ReflectionDir*WPanMatrix);
	Normal = normalize(Normal*WPanMatrix);
	vec3 ViewDir = normalize(vd*WPanMatrix);
	float Gloss = sfSpecular.w;
	float Freeze = 0;
	vec4 Checker = vec4(1.0,1.0,1.0,1.0);
	vec4 LightColor = Checker;
	float Emissive = 0.5;
	vec3 objcolor = vec3(LDiffuse22C);

#include "/Templates/ggx_light_core.glsl"

	FragColor = color;
}
