// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_ViewerPos;
uniform vec4 Sphere;
uniform mat4 ShadowTM;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;
in vec4 Color2;

out vec4 v_Color;

void main() {
	vec4 P = vec4(Pos, 1.0);
	vec4 PC = P * g_WorldViewProjectionMatrix;
	gl_Position = PC;
	v_Color = vec4(Color2.z,Color2.y,Color2.x,Color.w);
}

// Fragment shader

in vec4 v_Color;

uniform float GridConst;

out vec4 FragColor;
void main() {
        if(mod(gl_FragCoord.x+gl_FragCoord.y,2.0)==GridConst)discard;
	FragColor = v_Color;
}
