// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_ViewerPos;
uniform mat4 ShadowTM;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;
in vec4 Color2;

out vec3 v_Pos;
out vec4 v_Color;

void main() {
	vec4 P = vec4(Pos, 1.0);
	vec4 PC = P * g_WorldViewProjectionMatrix;
	gl_Position = PC;
	float ww=Color2.w;
	v_Color=vec4(ww,ww,ww,1.0);
}

// Fragment shader

in vec4 v_Color;

uniform float GridConst;

out vec4 FragColor;
void main() {
        if(mod(gl_FragCoord.x+gl_FragCoord.y,2.0)==GridConst)discard;
	FragColor = v_Color;
}