// Vertex shader
#include "/Templates/scalc_vs.glsl"
// Fragment shader
#include "/Templates/scalc_variables.glsl"
#include "/Templates/scalc_voxel_lib.glsl"

uniform float radius;
uniform float operation_sign;
uniform float alpha_overlap;
uniform float operation_degree;

//@scalc_voxel_lib

void main() {
	int gx = int(gl_FragCoord.x);
	int gy = int(gl_FragCoord.y);	
	int base = gx+gy*LinearTexturePinch;
	ivec2 tsz = textureSize(out_BackIndex,0);
	float h=float(tsz.y);
	for(int i=0;i<2;i++){
		int ofs = base*2+i;
		ivec3 pos = getPos(ofs);
		float v0=getCellValue(pos.x, pos.y, pos.z);
		int val = int(v0*65535.0);
		int nn=2+int(clamp(operation_degree * 3, 0, radius / 10));
		float w1 = AlphaDegreeSumm(pos);
		w1 = saturate(w1 / alpha_overlap / 2.0);

		float summ = pow(saturate(v0), clamp(1.0 - operation_sign * operation_degree / 2.0, 0.25, 2.5));
		val = int(saturate((summ * w1 + v0 * (1.0 - w1) - 0.5) * (1.0 + w1 / 33.3) + 0.5)*65535.0);
		
		// val = _debug(ofs)

		if(i == 0) FragColor.xy = intTov2(val);
		else FragColor.zw = intTov2(val);		
	}
}
