layout(vertices=3) out;

 in vec4 voPos[];
 in vec3 voN[];
 in vec4 voC[];
 in vec4 voC2[];
 in vec3 voWorldPos[];
 in vec4 voExtra[];
 in vec3 voVDir[];
 in vec3 voMPos[];
 in vec3 voRawPos[];
 in vec3 voRawNormal[];

 out vec4 toPos[];
 out vec3 toN[];
 out vec4 toC[];
 out vec4 toC2[];
 out vec3 toWorldPos[];
 out vec4 toExtra[];
 out vec3 toVDir[];
 out vec3 toMPos[];
 out vec3 toRawPos[];
 out vec3 toRawNormal[];

 out vec3 B210[];
 out vec3 B120[];
 out vec3 B021[];
 out vec3 B012[];
 out vec3 B102[];	
 out vec3 B201[];	

 out vec3 B111[];

 out vec3 N110[];
 out vec3 N011[];
 out vec3 N101[];

 vec3 sB210;
 vec3 sB120;
 vec3 sB021;
 vec3 sB012;
 vec3 sB102;	
 vec3 sB201;	

 vec3 sB111;

 vec3 sN110;
 vec3 sN011;
 vec3 sN101;

uniform mat4 g_WorldViewProjectionMatrix;

#define ID gl_InvocationID

vec2 WorldToScreen(vec4 aPos) {

	vec4 ssrPxPos4 = aPos * g_WorldViewProjectionMatrix;
	return ssrPxPos4.xy / ssrPxPos4.w * 0.5 + vec2(0.5, 0.5);

}

void calculateControlPoints()
{
	//Set the positions
	vec3 B300 = voPos[0].xyz; // P3
	vec3 B030 = voPos[1].xyz; // P2
	vec3 B003 = voPos[2].xyz; // P1
	//Set the normals
	vec3 N200 = voN[0]; // N3
	vec3 N020 = voN[1]; // N2
	vec3 N002 = voN[2]; // N1
	//Spread the points over the "surface"
	sB210 = (2 * B300 + B030 - dot((B030 - B300), N200) * N200) / 3;
	sB120 = (2 * B030 + B300 - dot((B300 - B030), N020) * N020) / 3;
	sB021 = (2 * B030 + B003 - dot((B003 - B030), N020) * N020) / 3;
	sB012 = (2 * B003 + B030 - dot((B030 - B003), N002) * N002) / 3;
	sB102 = (2 * B003 + B300 - dot((B300 - B003), N002) * N002) / 3;
	sB201 = (2 * B300 + B003 - dot((B003 - B300), N200) * N200) / 3;
	//Calculate the center point
	vec3 E = (sB210 + sB120 + sB021 + sB012 + sB102 + sB201) / 6;
	vec3 V = (B003 + B030 + B300) / 3;
	sB111 = E + (E - V)/2;
	//Reflect end-normal perpendicular to the plane
	float v12 = 2.0f * dot((B030 - B300), (N200 + N020)) / dot((B030 - B300), (B030 - B300));
	float v23 = 2.0f * dot((B003 - B030), (N020 + N002)) / dot((B003 - B030), (B003 - B030));
	float v31 = 2.0f * dot((B300 - B003), (N002 + N200)) / dot((B300 - B003), (B300 - B003));
	sN110 = normalize(N200 + N020 - v12 * (B030 - B300));
	sN011 = normalize(N020 + N002 - v23 * (B003 - B030));
	sN101 = normalize(N002 + N200 - v31 * (B300 - B003));
}


void main()
{
		
	toPos[ID] =  voPos[ID];
	toN[ID] =  voN[ID];
	toC[ID] =  voC[ID];
	toC2[ID] =  voC2[ID];
	toWorldPos[ID] =  voWorldPos[ID];
	toExtra[ID] =  voExtra[ID];
	toVDir[ID] =  voVDir[ID];
	toMPos[ID] =  voMPos[ID];
	toRawPos[ID] =  voRawPos[ID];
	toRawNormal[ID] =  voRawNormal[ID];
	
	
	
	if (ID == 0)
	{
		calculateControlPoints();		
		vec2 sp0 = WorldToScreen(voPos[0]);
		vec2 sp1 = WorldToScreen(voPos[1]);
		vec2 sp2 = WorldToScreen(voPos[2]);	
		
		float sp01 = distance(sp0, sp1);
		float sp12 = distance(sp1, sp2);
		float sp20 = distance(sp2, sp0);
		float size = (sp01+sp12+sp20)*60;

		vec2 sMin = min(min(sp0, sp1), sp2);
		vec2 sMax = max(max(sp0, sp1), sp2);
		float detailLevel = 4;
		if(sMax.x > 0 && sMax.y > 0 && sMin.x < 1 &&  sMin.y < 1){
	
			gl_TessLevelInner[0] = size*detailLevel+0.75;
			
			gl_TessLevelOuter[2] = sp01*300.0*detailLevel+0.5;
			gl_TessLevelOuter[0] = sp12*300.0*detailLevel+0.5;
			gl_TessLevelOuter[1] = sp20*300.0*detailLevel+0.5;
		} else {
			gl_TessLevelInner[0] = 0;
			
			gl_TessLevelOuter[2] = 0;
			gl_TessLevelOuter[0] = 0;
			gl_TessLevelOuter[1] = 0;
		}
	}
	
	B210[ID] = sB210;
	B120[ID] = sB120;
	B021[ID] = sB021;
	B012[ID] = sB012;
	B102[ID] = sB102;	
	B201[ID] = sB201;	

	B111[ID] = sB111;

	N110[ID] = sN110;
	N011[ID] = sN011;
	N101[ID] = sN101;
	
}
