layout (triangles) in;
//layout(triangle_strip, max_vertices = 80) out;
layout(triangle_strip, max_vertices = 24) out;

 in vec4 voPos[3];
 in vec3 voN[3];
 in vec4 voC[3];
 in vec4 voC2[3];
 in vec3 voWorldPos[3];
 in vec4 voExtra[3];
 in vec3 voVDir[3];
 in vec3 voMPos[3];
 in vec3 voRawPos[3];
 in vec3 voRawNormal[3];


//out vec4 oPos;
out vec3 oN;
out vec4 oC;
out vec4 oC2;
//out vec3 oWorldPos;
//out vec4 oExtra;
//out vec3 oVDir;
//out vec3 oMPos;
out vec3 oRawPos;
//out vec3 oRawNormal;

uniform float WFogDensity;
uniform float WFogShadows;
uniform float WFogPower;
uniform vec4 WFogColor;
uniform float WVolumeFogSamples;
uniform float WLightSilhouette;
uniform float WSilhouette;
uniform float WShadowMapSize;
uniform float WFogRand;

uniform float RRenderPass;
uniform float du;
uniform float dv;

uniform sampler2D tBRDF;
uniform sampler2D PanoramaDiffuse;
uniform float Metalness;
uniform float ExtraGloss;
uniform float BasePlasticReflection;
uniform float MaxPlasticReflection;
uniform float PaintOpacity;
uniform float LightContrast;
uniform float IsExternalLight;
uniform vec3 ExtraGamma;
uniform vec4 LightColor2g;
uniform vec4 SSScolor;
uniform float Translucence;
uniform float FreezeMod;
uniform float Inverse;
#define GlobalViewDir (-oVDir)
#ifdef BAS_RELIEF
uniform vec3 BasReliefDir;
uniform vec3 BasReliefBase;
uniform float TaperingAngle;
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_LocalViewPos;
uniform vec4 Sphere;
uniform mat4 ShadowTM;
uniform float OverallScale;
uniform float ShadowStep;
uniform float ShadowMapSide;
uniform float Extrusion;

#ifdef USE_DEPTH
uniform float du;
uniform float dv;
#endif

uniform vec3 MousePos;
uniform float TimeSeconds;
uniform float CurrentIteration;
uniform vec3 LightDir;

struct TVert
{
  vec4 pos;
  vec4 oPos;
  vec3 oN;
  vec4 oC;
  vec4 oC2;
  vec3 oWorldPos;
  vec4 oExtra;
  vec3 oVDir;
  vec3 oMPos;
  vec3 oRawPos;
  vec3 oRawNormal;
  vec3 barycentric;
};

////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
struct ControlPoints {
	vec3 B210;
	vec3 B120;
	vec3 B021;
	vec3 B012;
	vec3 B102;	
	vec3 B201;	
	
	vec3 B111;
	
	vec3 N110;
	vec3 N011;
	vec3 N101;
} gControlPoints;
////

vec4 calculatePositionfromUVW(vec4 triangleVP[3], vec3 barycentricCoords, ControlPoints controlP)
{
	// The barycentric coordinates
	float u = barycentricCoords.x;
	float v = barycentricCoords.y;
	float w = barycentricCoords.z;
	// Precompute squares and squares * 3 
	float uu = u * u;
	float vv = v * v;
	float ww = w * w;
	float uu3 = uu * 3.0f;
	float vv3 = vv * 3.0f;
	float ww3 = ww * 3.0f;
	// Compute position from cubic control points and barycentric coords
	vec3 position = triangleVP[0].xyz * ww * w +
	triangleVP[1].xyz * uu * u +
	triangleVP[2].xyz * vv * v +
	controlP.B210 * ww3 * u +
	controlP.B120 * w * uu3 +
	controlP.B201 * ww3 * v +
	controlP.B021 * uu3 * v +
	controlP.B102 * w * vv3 +
	controlP.B012 * u * vv3 +
	controlP.B111 * 6.0f * w * u * v;
	
	
	return vec4(position,1.0f);
}

vec4 calculateNormalfromUVW(vec3 triangleN[3], vec3 barycentricCoords, ControlPoints controlP)
{
	// The barycentric coordinates
	float u = barycentricCoords.x;
	float v = barycentricCoords.y;
	float w = barycentricCoords.z;
	// Precompute squares and squares * 3 
	float uu = u * u;
	float vv = v * v;
	float ww = w * w;
	vec3 normal = triangleN[0] * ww +
	triangleN[1] * uu +
	triangleN[2] * vv +
	controlP.N110 * w * u +
	controlP.N011 * u * v +
	controlP.N101 * w * v;
	normal = normalize(normal);
	return vec4(normal, 0.0f);
}


vec2 interpolateTexC(vec2 tex1, vec2 tex2, vec2 tex3, vec3 barycentricCoord)
{
	return tex2 * barycentricCoord.x + tex3 * barycentricCoord.y + tex1 * barycentricCoord.z;
}

/** Calculate control points
*/
ControlPoints calculateControlPoints(vec4 pos[3], vec3 normal[3])
{
	ControlPoints retval;
	//Set the positions
	vec3 B300 = pos[0].xyz; // P3
	vec3 B030 = pos[1].xyz; // P2
	vec3 B003 = pos[2].xyz; // P1
	//Set the normals
	vec3 N200 = normal[0]; // N3
	vec3 N020 = normal[1]; // N2
	vec3 N002 = normal[2]; // N1
	//Spread the points over the "surface"
	retval.B210 = (2 * B300 + B030 - dot((B030 - B300), N200) * N200) / 3;
	retval.B120 = (2 * B030 + B300 - dot((B300 - B030), N020) * N020) / 3;
	retval.B021 = (2 * B030 + B003 - dot((B003 - B030), N020) * N020) / 3;
	retval.B012 = (2 * B003 + B030 - dot((B030 - B003), N002) * N002) / 3;
	retval.B102 = (2 * B003 + B300 - dot((B300 - B003), N002) * N002) / 3;
	retval.B201 = (2 * B300 + B003 - dot((B003 - B300), N200) * N200) / 3;
	//Calculate the center point
	vec3 E = (retval.B210 + retval.B120 + retval.B021 + retval.B012 + retval.B102 + retval.B201) / 6;
	vec3 V = (B003 + B030 + B300) / 3;
	retval.B111 = E + (E - V)/2;
	//Reflect end-normal perpendicular to the plane
	float v12 = 2.0f * dot((B030 - B300), (N200 + N020)) / dot((B030 - B300), (B030 - B300));
	float v23 = 2.0f * dot((B003 - B030), (N020 + N002)) / dot((B003 - B030), (B003 - B030));
	float v31 = 2.0f * dot((B300 - B003), (N002 + N200)) / dot((B300 - B003), (B300 - B003));
	retval.N110 = normalize(N200 + N020 - v12 * (B030 - B300));
	retval.N011 = normalize(N020 + N002 - v23 * (B003 - B030));
	retval.N101 = normalize(N002 + N200 - v31 * (B300 - B003));
	return retval;
}

vec3 GetNormal()
{
   vec3 a = vec3(gl_in[0].gl_Position) - vec3(gl_in[1].gl_Position);
   vec3 b = vec3(gl_in[2].gl_Position) - vec3(gl_in[1].gl_Position);
   return normalize(cross(a, b));
}  

vec4 smPos(vec3 aBarycentric, out vec3 Normal){
	
	vec3 p1 = gl_in[0].gl_Position.xyz;
	vec3 p2 = gl_in[1].gl_Position.xyz;
	vec3 p3 = gl_in[2].gl_Position.xyz;
	vec3 n1 = -voN[0];
	vec3 n2 = -voN[1];
	vec3 n3 = -voN[2];
	float u = aBarycentric.x;
	float v = aBarycentric.y;
	float w = aBarycentric.z;
	vec3 b300 = p1;
	vec3 b030 = p2;
	vec3 b003 = p3;
	float w12 = dot( p2 - p1, n1 );
	float w21 = dot( p1 - p2, n2 );
	float w13 = dot( p3 - p1, n1 );
	float w31 = dot( p1 - p3, n3 );
	float w23 = dot( p3 - p2, n2 );
	float w32 = dot( p2 - p3, n3 );
	
	vec3 b210 = ( 2.*p1 + p2 - w12*n1 ) / 3.;
	vec3 b120 = ( 2.*p2 + p1 - w21*n2 ) / 3.;
	vec3 b021 = ( 2.*p2 + p3 - w23*n2 ) / 3.;
	vec3 b012 = ( 2.*p3 + p2 - w32*n3 ) / 3.;
	vec3 b102 = ( 2.*p3 + p1 - w31*n3 ) / 3.;
	vec3 b201 = ( 2.*p1 + p3 - w13*n1 ) / 3.;
	vec3 ee = ( b210 + b120 + b021 + b012 + b102 + b201 ) / 6.;
	vec3 vv = ( p1 + p2 + p3 ) / 3.;
	vec3 b111 = ee + ( ee - vv ) / 2.;
	vec3 xyz = 1.*b300*w*w*w + 1.*b030*u*u*u + 1.*b003*v*v*v +
				3.*b210*u*w*w + 3.*b120*u*u*w + 3.*b201*v*w*w +
				3.*b021*u*u*v + 3.*b102*v*v*w + 3.*b012*u*v*v +
				6.*b111*u*v*w;
				
	float v12 = 2. * dot( p2-p1, n1+n2 ) / dot( p2-p1, p2-p1 );
	float v23 = 2. * dot( p3-p2, n2+n3 ) / dot( p3-p2, p3-p2 );
	float v31 = 2. * dot( p1-p3, n3+n1 ) / dot( p1-p3, p1-p3 );
	vec3 n200 = n1;
	vec3 n020 = n2;
	vec3 n002 = n3;
	vec3 n110 = normalize( n1 + n2 - v12*(p2-p1) );
	vec3 n011 = normalize( n2 + n3 - v23*(p3-p2) );
	vec3 n101 = normalize( n3 + n1 - v31*(p1-p3) );
	Normal = n200*w*w + n020*u*u + n002*v*v + n110*w*u + n011*u*v + n101*w*v;
	return vec4( xyz, 1. );	
}

/** wraps value to a specific range
In
min---------------------------max inval
Out
min----inval------------------max
*/
int wrap(int inval, int max, int min)
{
	if(inval < min)
		return max - (min - inval);
	else if(inval >= max)
		return min + (inval - max);
	else
		return inval;
}



///////////////////////////////////////////////////////////////////////////////////////////////




TVert AvgV(TVert a, TVert b)
{
  return TVert(
	(a.pos+b.pos)*0.5, 
	(a.oPos+b.oPos)*0.5,
	(a.oN+b.oN)*0.5,
	(a.oC+b.oC)*0.5,
	(a.oC2+b.oC2)*0.5,
	(a.oWorldPos+b.oWorldPos)*0.5,
	(a.oExtra+b.oExtra)*0.5,
	(a.oVDir+b.oVDir)*0.5,
	(a.oMPos+b.oMPos)*0.5,
	(a.oRawPos+b.oRawPos)*0.5,
	(a.oRawNormal+b.oRawNormal)*0.5,
	(a.barycentric+b.barycentric)*0.5
	);
}

TVert BcPoint(TVert[3] aP, vec3 aBc)
{
	return TVert(
		(aBc.x*aP[0].pos			+ aBc.y*aP[1].pos			+ aBc.z*aP[2].pos			),
		(aBc.x*aP[0].oPos			+ aBc.y*aP[1].oPos			+ aBc.z*aP[2].oPos			),
		(aBc.x*aP[0].oN				+ aBc.y*aP[1].oN			+ aBc.z*aP[2].oN			),
		(aBc.x*aP[0].oC				+ aBc.y*aP[1].oC			+ aBc.z*aP[2].oC			),
		(aBc.x*aP[0].oC2			+ aBc.y*aP[1].oC2			+ aBc.z*aP[2].oC2			),
		(aBc.x*aP[0].oWorldPos		+ aBc.y*aP[1].oWorldPos		+ aBc.z*aP[2].oWorldPos		),
		(aBc.x*aP[0].oExtra			+ aBc.y*aP[1].oExtra		+ aBc.z*aP[2].oExtra		),
		(aBc.x*aP[0].oVDir			+ aBc.y*aP[1].oVDir			+ aBc.z*aP[2].oVDir			),
		(aBc.x*aP[0].oMPos			+ aBc.y*aP[1].oMPos			+ aBc.z*aP[2].oMPos			),
		(aBc.x*aP[0].oRawPos		+ aBc.y*aP[1].oRawPos		+ aBc.z*aP[2].oRawPos		),
		(aBc.x*aP[0].oRawNormal		+ aBc.y*aP[1].oRawNormal	+ aBc.z*aP[2].oRawNormal	),
		(aBc.x*aP[0].barycentric	+ aBc.y*aP[1].barycentric	+ aBc.z*aP[2].barycentric	)
	);
}


void emitP(TVert p){
	
		gl_Position = p.pos*g_WorldViewProjectionMatrix;
	//	oPos = p.oPos;
		oN = p.oN;
		oC = p.oC;
		oC2 = p.oC2;
	//	oWorldPos = p.oWorldPos;
//		oExtra = p.oExtra;
//		oVDir = p.oVDir;
//		oMPos = p.oMPos;
		oRawPos = p.oRawPos;
//		oRawNormal = p.oRawNormal;
		EmitVertex();
	
}

void RenderTri(TVert[12] p, int from){

	for(int i = 0; i < 3; i++){
		emitP(p[i+from]);
	}

	EndPrimitive();
	
}

TVert[12] _SubDiv(TVert[3] p){
	TVert[12] r;
	for(int i = 0; i < 3; i++){
		
		r[i*3+0] = p[i];
		r[i*3+1] = AvgV(p[i], p[(i+1)%3]);
		r[i*3+2] = AvgV(p[i], p[(i+2)%3]);
	}	

    r[9] = AvgV(p[0], p[1]);
    r[10] = AvgV(p[1], p[2]);
    r[11] = AvgV(p[2], p[0]);
	
	for(int i = 0; i < 12; i++){
//		r[i].pos = gl_in[0].gl_Position*r[i].barycentric.x+gl_in[1].gl_Position*r[i].barycentric.y+gl_in[2].gl_Position*r[i].barycentric.z+vec4(r[i].oN,0.0);
		r[i].pos = calculatePositionfromUVW(vec4[3](gl_in[0].gl_Position, gl_in[1].gl_Position, gl_in[2].gl_Position), r[i].barycentric.yzx, gControlPoints);
		r[i].oN = -calculateNormalfromUVW(vec3[3](-voN[0], -voN[1], -voN[2]),  r[i].barycentric.yzx, gControlPoints).xyz;
//		r[i].pos = smPos(r[i].barycentric.yzx, r[i].oN);
//		r[i].oN = -r[i].oN;
		r[i].pos.w = gl_in[0].gl_Position.w;
	}
	
	return r;

}

TVert[12] SubDiv4(TVert[3] p, int L){

	TVert[12] r = _SubDiv(p);
	
	RenderTri(r, 0);
	RenderTri(r, 3);
	RenderTri(r, 6);
	RenderTri(r, 9);
	return r;
}

TVert[12] SubDiv2(TVert[3] p, int L){

	TVert[12] r = _SubDiv(p);
	
	SubDiv4(TVert[3](r[0], r[1], r[2]), L+1);
	SubDiv4(TVert[3](r[3], r[4], r[5]), L+1);
	SubDiv4(TVert[3](r[6], r[7], r[8]), L+1);
	SubDiv4(TVert[3](r[9], r[10], r[11]), L+1);
	return r;
		
}

void emitBarycentric(TVert[3] p, vec3 aBc) {

	TVert iBuf = BcPoint(p, aBc);

	iBuf.pos = calculatePositionfromUVW(vec4[3](gl_in[0].gl_Position, gl_in[1].gl_Position, gl_in[2].gl_Position), aBc.yzx, gControlPoints);
	iBuf.oN = -calculateNormalfromUVW(vec3[3](-voN[0], -voN[1], -voN[2]), aBc.yzx, gControlPoints).xyz;
	iBuf.oRawPos = iBuf.pos.xyz;

	emitP(iBuf);

}

void SubDiv(TVert[3] p, int aLevel){

	int iEdges = 1;
	for (int i = 0; i < aLevel; i++) iEdges *= 2;
	float fEdges = float(iEdges);
	int iEdges2 = iEdges;
	float fEdges2 = float(iEdges2);


	float iStep = 1.0 / (fEdges);

	float iPosV0 = 0;
	float iPosV1 = iStep;

	for (int i2 = 0; i2 < iEdges; i2++) {
		float iStepU0 = 1.0 / (fEdges2);
		float iStepU1 = 1.0 / (fEdges2-1);

		float iPosU0 = 0;
		float iPosU1 = 0;
		vec3 iBary0 = vec3(0, 0, 0);
		for (int i = 0; i < iEdges2; i++) {

			iBary0 = mix(vec3(iPosU0, 1.0 - iPosU0, 0.0), vec3(0, 0, 1), vec3(iPosV0));
			vec3 iBary1 = mix(vec3(iPosU1, 1.0 - iPosU1, 0.0), vec3(0, 0, 1), vec3(iPosV1));

			emitBarycentric(p, iBary0);
			emitBarycentric(p, iBary1);

			iPosU0 += iStepU0;
			iPosU1 += iStepU1;


		}
		iBary0 = mix(vec3(iPosU0, 1.0 - iPosU0, 0.0), vec3(0, 0, 1), vec3(iPosV0));
		emitBarycentric(p, iBary0);

		EndPrimitive();

		iPosV0 += iStep;
		iPosV1 += iStep;
		iEdges2-=1;
		fEdges2-=1;

	}

/*
	TVert[12] r = _SubDiv(p);
	
	SubDiv2(TVert[3](r[0], r[1], r[2]), L+1);
	SubDiv2(TVert[3](r[3], r[4], r[5]), L+1);
	SubDiv2(TVert[3](r[6], r[7], r[8]), L+1);
	SubDiv2(TVert[3](r[9], r[10], r[11]), L+1);
	return r;
	*/	
}

vec2 WorldToScreen(vec4 aPos) {

	vec4 ssrPxPos4 = aPos * g_WorldViewProjectionMatrix;
	return ssrPxPos4.xy / ssrPxPos4.w * 0.5 + vec2(0.5, 0.5);

}

void main() {    

	gControlPoints = calculateControlPoints(vec4[3](gl_in[0].gl_Position, gl_in[1].gl_Position, gl_in[2].gl_Position), vec3[3](normalize(-voN[0]), normalize(-voN[1]), normalize(-voN[2])));
//	gControlPoints = calculateControlPoints(vec4[3](gl_in[0].gl_Position, gl_in[1].gl_Position, gl_in[2].gl_Position), vec3[3](GetNormal(), GetNormal(), GetNormal()));

	vec2 sp0 = WorldToScreen(gl_in[0].gl_Position);
	vec2 sp1 = WorldToScreen(gl_in[1].gl_Position);
	vec2 sp2 = WorldToScreen(gl_in[2].gl_Position);

	float sp01 = distance(sp0, sp1);
	float sp12 = distance(sp1, sp2);
	float sp20 = distance(sp2, sp0);
	float size = max(max(sp01, sp12), sp20);

    vec3 normal = GetNormal();
	TVert[3] tri;
	for(int i = 0; i < 3; i++){
		vec3 brc = vec3(0,0,0);
		brc[i] = 1;
		tri[i] = TVert(gl_in[i].gl_Position, 
			voPos[i],
			voN[i],
			voC[i],
			voC2[i],
			voWorldPos[i],
			voExtra[i],
			voVDir[i],
			voMPos[i],
			voRawPos[i],
			voRawNormal[i],
			brc
		);
	}

//	TVert[12] r =
	int sdLev = 0;
	if (size > 0.005) sdLev = 1;
	if (size > 0.010) sdLev = 2;
	SubDiv(tri, sdLev);
	

} 

