/////////////////////////////////////////////////////////////
// Gloss          - glossness of the pixe
// PANORAMA SPACE VECTORS:
// Normal         - normal in panorama space
// ViewDir        - view direction  in panorama space
// ReflectionDir  - reflection direction in panorama space
//
// WORLD SPACE VECTORS
//
// GlobalNormal   - normal in world space
// LightDir       - light direction in world space
// GlobalViewDir  - view direction in world space
//
// OTHER STUFF:
//
// Freeze	  - freeze value
// Opacity        - texture opacity
// Emissive       - emissive
// Panorama       - environment sampler
//
// COLORS:
//
// LDiffuse22C    - gamma corrected light color
// LightColor2g   - gamma corrected color, (1,1,1) for panorama and (r,g,b) for colored light
// NOT GAMMA CORRECTED:
// sfSpecular.xyz - specular color
// sfColor.xyz    - texture color
// Checker        - checker (selection) color
// color          - resulting color
// IsExternalLight - 0 for panorama and 1 for extern lights
/////////////////////////////////////////////////////////////
#define RP_COMPOSITE 0
#define RP_DIFFUSE 1
#define RP_TRANSLUCENT 2
#define RP_LIGHT 3
#define RP_AO 4
#define RP_DEPTH 5
#define RP_REFLECTION 6
#define RP_REFRACTION 7
#define RP_CLEAR_COAT 8
#define RP_GLOSS 9
#define RP_FOG 10
#define RP_FOG_MASK 11
#define RP_FOG_LIGHT 12
#define RP_EMMISIVE 13
#define RP_FUZZ 14
#define RP_FUZZ_MASK 15
#define RP_FUZZ_LIGHT 16
#define RP_MICROPROTRUSIONS 17
#define RP_MICROPROTRUSIONS_MASK 18
#define RP_MICROPROTRUSIONS_LIGHT 19

#ifndef D_RRenderPass
#define D_RRenderPass 0
#endif
{
float Occlusion = clamp(Emissive*2.0, 0.0, 1.0);
float SpecOcclusion = Occlusion*Occlusion*Occlusion;
Emissive = clamp(Emissive*2.0-1.0, 0.0, 1.0);

float RSSS_Degree = 0;
#ifdef USE_NORMALMAP
	RSSS_Degree = SSS_Degree;
#endif
#ifdef PROCEDURAL_ENV

	float LCuu = atan(LightDir.z,LightDir.x)/(3.1415926*2.0);
	float LCas = asin(LightDir.y);
	float LCvv = 0.5+LCas/3.14159;	
	
	vec4 LightColor = texture(Panorama, vec2(LCuu, LCvv));	
	LightColor.xyz *= 5.0-LightColor.w*4.0;//extra light range from the texture alpha channel
//	LightColor.xyz *= getmodf(LightColor.xyz);
//	LightColor.xyz = pow(LightColor.xyz,vec3(gamma));


#endif

	int iCurrentIteration = int(CurrentIteration);

	vec4 lightColor = lerp(LightColor, LightColor2g,IsExternalLight);


	#if D_RRenderPass == RP_GLOSS
		FragColor = vec4(Gloss,Gloss,Gloss,1); 
		return;
	#endif
	
	float pi = 3.1415926;
	float pi2 = 3.1415926*2;	
	
	float cavBugE = 0.0;

	float sLightIntensity = LightIntensity;
#ifdef VOLUME
	sLightIntensity = 0;
#endif
	
#ifdef USE_CAVITY
	cavBugE = max(saturate(ca0*cavityIntensity*1.25 - 0.25), saturate(-ca0*bulgeIntensity*1.25 - 0.5));
#endif
	cavBugE = max(cavBugE, alpha);
	float iCavBugE = 1.0-cavBugE;
	
	
	vec4 Specular_Modulator = vec4(1);
	vec4 Microprotrusions_Modulator = vec4(1,1,1,1);
	vec4 Anisotropic_Modulator = vec4(1,1,1,1);
	vec4 Fuzz_Modulator = vec4(1,1,1,1);

	vec4 ColorModulatorC = vec4(1,1,1,1);
	vec4 GlossModulatorC = vec4(1,1,1,1);
	vec4 MetallModulatorC = vec4(1,1,1,1);
#ifdef USE_COLORTEX
	mxy=texture(CustomSampler1,oMPos.xy);
	myz=texture(CustomSampler1,oMPos.yz);
	mzx=texture(CustomSampler1,oMPos.zx);
	mxy=(mxy*wxy+myz*wyz+mzx*wzx)/sw;
	ColorModulatorC = mxy;
#endif
#ifdef USE_GLOSSTEX
	gxy=texture(CustomSampler4,oMPos.xy);
	gyz=texture(CustomSampler4,oMPos.yz);
	gzx=texture(CustomSampler4,oMPos.zx);
	gxy.y=(gxy.y*wxy+gyz.y*wyz+gzx.y*wzx)/sw;
	GlossModulatorC = gxy;
#endif
#ifdef USE_METALLTEX
	mmxy=texture(CustomSampler5,oMPos.xy);
	mmyz=texture(CustomSampler5,oMPos.yz);
	mmzx=texture(CustomSampler5,oMPos.zx);
	mmxy.y=(mmxy.y*wxy+mmyz.y*wyz+mmzx.y*wzx)/sw;
	MetallModulatorC = mmxy;
#endif	
		
	
#ifdef ANISOTROPIC	
	float anisotropic = Anisotropic/1.5;
	float anisotropic05 = pow(anisotropic,0.7);
	float anisoAngle = AnisotropicAngle*3.6;
#ifdef USE_METALLTEX
	anisotropic = lerp(anisotropic, anisotropic*MetallModulatorC.x,AnisoByMetR);
	anisoAngle = lerp(anisoAngle, MetallModulatorC.z*360.0,AnisoAngByMetB);
#endif
#ifdef USE_GLOSSTEX
	anisotropic = lerp(anisotropic, anisotropic*GlossModulatorC.x,AnisoByGlossB);
#endif
	
	float anisoRadAngle = anisoAngle * 0.017453;
	vec2 anisoDir;
	anisoDir.x = cos(anisoRadAngle);
	anisoDir.y = sin(anisoRadAngle);
	vec2 anisoDirI = -anisoDir;
	
	Gloss *= 1.0-anisotropic/4.0;

#endif

	const float gamma = 2.2; 
	const float igamma = 1.0/2.2; 
	vec3 Emiss = sfColor.xyz * max(sLightIntensity, Emissive) * max(EmissionGain, Emissive);

#ifndef TC_DEFINED
	vec3 tColor = pow(sfColor.xyz,vec3(gamma));
	vec3 tSpecular = pow(sfSpecular.xyz,vec3(gamma));
#endif
	tSpecular = tSpecular*alpha;


	ioPM = vec4(defAlbedo*0.5, sfColor.w);
	ioPQ1 = vec4(0.5);
	ioPQ2 = vec4(0.05, 0.05, 0.05, 0.0);
	ioPQ3 = vec4(Emiss, 0.0)*0.5;
	ioPQ4 = vec4(0.5);
	ioPN = vec4(0.5, 0.5, defMetall*0.5+0.5, Gloss*0.5+0.5);
	ioDisplacement = 0;
#ifdef MC_COVER
	ioDisplacement = nrm.z;
	ioPN.y = Gloss;
	ioPN.z = metl;
#endif
	ioNormal = vec4(GlobalNormal.xyz, 0.0);
	ioGlobalNormal = vec4(normalize(GlobalNormal.xyz*mat3(g_WorldMatrix)), 0.0);
	vec3 oRawPosSc = oRawPos*NGScale;
	ioPosition = vec4(oRawPos.xyz, 1.0);
	ioGlobalPosition = (ioPosition*g_WorldMatrix);
#ifdef NODE_CODE
	vec3 oMPosSc = oMPos*NGScale;
#ifndef HAS_IN_CAVITY
	#ifdef USE_CAVITY
		float icavity = -ca0*0.5+0.5;
		ioCavity = vec4(icavity, icavity, icavity, icavity);
	#else
		ioCavity = vec4(0.5,0.5,0.5,0.5);
	#endif
#endif	
	ioTime = vec4(TimeSeconds, TimeSeconds, TimeSeconds, TimeSeconds);                 // shader playback time (in seconds)
	ioMouse = vec4(MousePos.x, MousePos.y, MousePos.z, 0.0);                // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = vec4(oRawPos*NGScale, 0.0);
	ioUV = ioFragCoord;
	

	ioFragCoord_DX = vec4(dFdx(oRawPosSc.xyz)*NGScale, 0.0);
	ioUV_DX = ioFragCoord_DX;
	ioNormal_DX = vec4(dFdx(oRawNormal.xyz), 0.0);
	ioPosition_DX = vec4(dFdx(oRawPos.xyz), 0.0)*NGScale;

	ioFragCoord_DY = vec4(dFdy(oRawPosSc.xyz), 0.0);
	ioUV_DY = ioFragCoord_DY;
	ioNormal_DY = vec4(dFdy(oRawNormal.xyz), 0.0);
	ioPosition_DY = vec4(dFdy(oRawPos.xyz), 0.0)*NGScale;

	ioLightDir = vec4(LightDir.xyz, 0.0);
	ioCameraPosition = vec4(g_LocalViewPos.xyz, 0.0);
	ioIteration = vec4One * CurrentIteration;
	
	ioOcclusion = vec4(Occlusion);

#ifndef PPP
//	float SSS_Degree = 0;
	vec3 NormalSSS = GlobalNormal;//normalize(oN*WPanMatrix);
#endif	


	vec3 iNormalSm = GlobalNormal-normalize(cross(dFdx(oRawPos),dFdy(oRawPos)));

	vec3 Pxx=oRawPos+dFdx(oRawPos);
	vec3 Pyy=oRawPos+dFdy(oRawPos);//*IncSign;		

#ifdef NG_AFFECTS_NORMAL
	vec4 _origPM =  ioPM;
	vec4 _origPQ1 = ioPQ1;
	vec4 _origPQ2 = ioPQ2;
	vec4 _origPQ3 = ioPQ3;
	vec4 _origPQ4 = ioPQ4;
	vec4 _origPN =  ioPN; 
	float _origDisplacement = ioDisplacement;
	{
		ioPosition = vec4(Pxx, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioFragCoord = (ioPosition*NGScale);
		ioUV = ioFragCoord;
//		ioFragCoord = vec4(Pxx*0.005/(OverallScale+1e-10),0.0);
		NODE_CODE;
		Pxx = ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale;
	}
	ioPM =  _origPM;
	ioPQ1 = _origPQ1;
	ioPQ2 = _origPQ2;
	ioPQ3 = _origPQ3;
	ioPQ4 = _origPQ4;
	ioPN =  _origPN; 
	ioDisplacement = _origDisplacement;
	{
		ioPosition = vec4(Pyy, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioFragCoord = (ioPosition*NGScale);
		ioUV = ioFragCoord;
//		ioFragCoord = vec4(Pyy*0.005/(OverallScale+1e-10),0.0);
		NODE_CODE;
		Pyy = ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale;
	}
	ioPM =  _origPM;
	ioPQ1 = _origPQ1;
	ioPQ2 = _origPQ2;
	ioPQ3 = _origPQ3;
	ioPQ4 = _origPQ4;
	ioPN =  _origPN; 
	ioDisplacement = _origDisplacement;
#endif	
	{
		ioPosition = vec4(oRawPos, 1.0);
//		ioFragCoord.xyz /= (OverallScale+0.001);
		ioUV = ioFragCoord;
		ioFragCoord = (ioPosition*NGScale);
		ioUV = ioFragCoord;
		NODE_CODE;
		
	}	

	
	

	ioPN.z = saturate(ioPN.z*2.0-1.0);

	
	
#ifdef UNPACK_PBM
	UNPACK_PBM;
	
	RSSS_Degree = ioR_DiffuseSSS;
	Gloss = ioR_Gloss;
	tColor = ioR_AlbedoColor.xyz*(1.0-ioR_Metalness);
	sfColor.w = ioPM.w;
	tSpecular.xyz = mix(ioR_ReflectionColor.xyz, ioR_AlbedoColor.xyz, vec3(ioR_Metalness));
	//iSpecularFace.xyz = tSpecular.xyz;
//	SpecularEdge
	sfSpecular.xyz = tSpecular.xyz;
	Emiss = vec3(0);//ioPQ3.xyz*0.0;
	//NormalSSS = GlobalNormal;//normalize(oN*WPanMatrix);	
#endif
#ifdef NG_AFFECTS_NORMAL
	vec3 iPD = (ioPosition.xyz+GlobalNormal.xyz*ioDisplacement/NGScale);
	vec3 iz = normalize(iPD-Pyy);
	vec3 ix = normalize(cross(normalize(Pxx-iPD), iz)); 
	ioNormal.xyz = -normalize(ix-iNormalSm);
	
	
	Normal.xyz = mix(normalize(ioNormal.xyz*WPanMatrix), Normal.xyz, vec3(ioR_DiffuseSSS));
	GlobalNormal.xyz = ioNormal.xyz;
#endif	
	ReflectionDir = oVDir - GlobalNormal * dot(oVDir, GlobalNormal) * 2.0;
	ReflectionDir = normalize(ReflectionDir*WPanMatrix);	
#endif


#ifdef PPP
	vec3  GlobalNormal=vec3(nrm.x*2.0-1.0,0.0,nrm.y*2.0-1.0);
	GlobalNormal.y=sqrt(1.0-GlobalNormal.x*GlobalNormal.x-GlobalNormal.z*GlobalNormal.z);	
	vec3 nn=normalize(oN);
	vec3 tt=normalize(oT-nn*dot(oT,nn)*Denorm);
	vec3 bb=normalize(oB-(nn*dot(oB,nn)+tt*dot(oB,tt))*Denorm);
	GlobalNormal=normalize(nn*GlobalNormal.y-tt*GlobalNormal.x-bb*GlobalNormal.z);

	Normal    = GlobalNormal;	
	
	vec3  ReflectionDir = normalize(ViewDir-2.0*Normal*dot(ViewDir,Normal));
	Normal    = normalize(Normal*WPanMatrix);
	vec3 NormalSSS    = normalize(oN*WPanMatrix);

	ReflectionDir = normalize(ReflectionDir*WPanMatrix);
	ViewDir = normalize(oVDir*WPanMatrix);

#ifdef VIEW_ALL
#endif
#ifdef VIEW_ENV
	FragColor = LightColor;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_COLOR
	FragColor = sfColor;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_RELIEF
	sfColor.xyz = vec3(0.5,0.5,0.5);
	sfSpecular.xyz = vec3(0.15,0.15,0.15);
	RSSS_Degree = 0;
//	sfColor.w = 1;
	Emiss.xyz *= 0;
	Gloss = 0.5;
#endif
#ifdef VIEW_SPECULAR
	FragColor.xyz = vec3(Gloss);
	FragColor.w = sfColor.w;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_ROUGH
	FragColor.xyz = vec3(1.0-Gloss);
	FragColor.w = sfColor.w;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif
#ifdef VIEW_SPCOLOR
	FragColor = sfSpecular;
	FragColor.w = sfColor.w;
	if(sfColor.w<CutOutLevel) discard;
	return;
#endif

#endif

#if D_RRenderPass == RP_DIFFUSE
	vec4 flatColor = vec4(pow(tColor.xyz, vec3(igamma)), ioPM.w); 
	FragColor = lerp(flatColor,flatColor*0.5,Freeze*FreezeMod);
	return;
#endif


	float Roughness = 1.0 - Gloss;
	float RoughnessFadeE = Roughness*Roughness;
	float GlossFadeE = Gloss*Gloss;

	float dotNV = saturate(abs(dot(Normal,ViewDir)));
	vec3 br = texture(tBRDF,vec2(dotNV,pow(Gloss,0.88))).xyz*1.5;

	float opp = 0.85-GlossFadeE*0.85+(1.0-GlossFadeE*GlossFadeE)*0.15;
	float uu = atan(ReflectionDir.z,ReflectionDir.x)/6.2831853;
	float as = asin(ReflectionDir.y);
	float vv = 0.5+as/3.1415926*(2048.0-pow(2.0,opp*7.0))/2048;	

	vec4 ReflectionColor = vec4(0,0,0,0);
	vec4 SSReflection = vec4(0.0, 0.0, 0.0, 0.0);

#ifdef ANISOTROPIC

	vec3 vDir0A = normalize(oVDir);
	float awxy=GlobalNormal.z*GlobalNormal.z;
	float awyz=GlobalNormal.x*GlobalNormal.x;
	float awzx=GlobalNormal.y*GlobalNormal.y;
	
	dN=vec3(anisoDir.x-0.5,0.5-anisoDir.y,0.0)*awxy;
	dN+=vec3(0.0,anisoDir.x-0.5,0.5-anisoDir.y)*awyz;
	dN+=vec3(0.5-anisoDir.y,0.0,anisoDir.x-0.5)*awzx;
	dN*=anisotropic;
	vec3 WorldAnisoNorm1=normalize(GlobalNormal+dN);
	vec3 WorldAnisoDirG1 = vDir0A - WorldAnisoNorm1 * dot(vDir0A, WorldAnisoNorm1) * 2.0;
	vec3 WorldAnisoDir1 = normalize(WorldAnisoDirG1*WPanMatrix);

	dN=vec3(anisoDirI.x-0.5,0.5-anisoDirI.y,0.0)*awxy;
	dN+=vec3(0.0,anisoDirI.x-0.5,0.5-anisoDirI.y)*awyz;
	dN+=vec3(0.5-anisoDirI.y,0.0,anisoDirI.x-0.5)*awzx;
	dN*=anisotropic;
	vec3 WorldAnisoNorm2=normalize(GlobalNormal+dN);
	vec3 WorldAnisoDirG2 = vDir0A - WorldAnisoNorm2 * dot(vDir0A, WorldAnisoNorm2) * 2.0;
	vec3 WorldAnisoDir2 = normalize(WorldAnisoDirG2*WPanMatrix);

	
	
	float AnisoSteps = lerp(2,16,GlossFadeE*anisotropic05);
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		for(float ai = 0; ai < AnisoSteps; ai+=1.0){
			vec3 cAnisoDir = lerp(WorldAnisoDir1, WorldAnisoDir2, ai/AnisoSteps);
			
	//		float dotNV = saturate(abs(dot(Normal,ViewDir)));
	//		vec3 br = texture(tBRDF,vec2(dotNV,pow(Gloss,0.88)))*1.5;

			float aopp = 0.85-GlossFadeE*0.85+(1.0-GlossFadeE*GlossFadeE)*0.15;
			float auu = atan(cAnisoDir.z,cAnisoDir.x)/6.2831853;
			float aas = asin(cAnisoDir.y);
			float avv = 0.5+aas/3.1415926*(2048.0-pow(2.0,aopp*7.0))/2048;	

			vec4 ResReflectionColor = textureLod(Panorama, vec2(auu, avv), aopp * 7.0);	
			
			ResReflectionColor.xyz *= 5.0-ResReflectionColor.w*4.0;//extra light range from the texture alpha channel
			ResReflectionColor.xyz *= getmodf(ResReflectionColor.xyz);
			ResReflectionColor.xyz = pow(ResReflectionColor.xyz,vec3(gamma));
			
			ReflectionColor += ResReflectionColor*(1.0-cos(ai/AnisoSteps*pi2));
		}
		#ifdef SHADOWS
		#ifdef SSREFLECTIONS
			if(iCurrentIteration % 4 == 3){
				SSReflection = ScreenSpaceRayTrace(oWorldPos.xyz, normalize(reflect(normalize(oWorldPos-g_LocalViewPos)/*oVDir*/, GlobalNormal)), Roughness, 24.0+64.0*Gloss*Gloss, 1.0, 0.1+Roughness*0.5, Roughness);
				ReflectionColor.xyz = lerp(ReflectionColor.xyz, SSReflection.xyz, saturate(SSReflection.w))*4.0;
				SSReflection.xyz *= 4.0;
			} else ReflectionColor.xyz *= 0.0;
		#endif
		#endif
		ReflectionColor = ReflectionColor/AnisoSteps*(1.0-anisotropic);
	#endif

#else	
	
	//reflection
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		ReflectionColor = textureLod(Panorama, vec2(uu, vv), opp * 7.0);	
		
		ReflectionColor.xyz *= 5.0-ReflectionColor.w*4.0;//extra light range from the texture alpha channel
		ReflectionColor.xyz *= getmodf(ReflectionColor.xyz);
		ReflectionColor.xyz = pow(ReflectionColor.xyz,vec3(gamma));
		#ifdef SHADOWS
				
			#ifdef SSREFLECTIONS
				if(iCurrentIteration % 4 == 3){
					SSReflection = ScreenSpaceRayTrace(oWorldPos.xyz, normalize(reflect(normalize(oWorldPos-g_LocalViewPos)/*oVDir*/, GlobalNormal)), Roughness, 24.0+64.0*Gloss*Gloss, 1.0, 0.1+Roughness*0.5, Roughness);
					ReflectionColor.xyz = lerp(ReflectionColor.xyz, SSReflection.xyz, saturate(SSReflection.w))*4.0;
					SSReflection.xyz *= 4.0;
				} else ReflectionColor.xyz *= 0.0;
			#endif
		#endif		
	#endif
#endif
	vec4 ReflectionColor0 = ReflectionColor;

	vec3 DNormal = Normal;
#ifdef USE_NORMALMAP_PPP
	DNormal = mix(DNormal, NormalSSS, RSSS_Degree);
#endif

	uu = atan(DNormal.z,DNormal.x)/6.2831853;
	vv=0.5+asin(DNormal.y*0.9999)/3.1415926*(64.0-0.5)/64.0;	
	vec4 DiffuseColor=texture(PanoramaDiffuse,vec2(uu,vv));

	//vv=0.5+asin(Normal.y)/3.1415926*(64.0-0.5)/64.0;	
	//vec4 DiffuseColor=textureLod(Panorama, vec4(uu, vv, 0, 7.0));	

	DiffuseColor.xyz *= 2.0-DiffuseColor.w;
	DiffuseColor.xyz *= getmodf(DiffuseColor.xyz)*pow(Occlusion, 0.3);;
	DiffuseColor.xyz = pow(DiffuseColor.xyz,vec3(gamma)) * br.z;
	vec3 Diff = DiffuseColor.xyz;
	
	ReflectionColor.xyz *= (tSpecular.xyz*br.x + br.yyy * saturate(pow(tSpecular.x+tSpecular.y+tSpecular.z, 0.3)*3.0) )*cavBugE*SpecOcclusion;
	
#ifdef SHADOWS
	vec3 H = normalize(LightDir-oVDir); 
	
	
	//GGX BRDF
//	float GGXalpha = lerp(pow(Roughness, 3.0), pow(Roughness, 1.8), Roughness) * 0.99 + 0.01;//) * (Roughness * 0.99 + 0.01);   // roughness offset for glossy surfaces
	float GGXalpha = saturate(Roughness * Roughness+LightScatter*0.25) * 0.995 + 0.005;   // roughness offset for glossy surfaces
	
	float dotNL = saturate(dot(GlobalNormal,LightDir));
	float dotNH = saturate(dot(GlobalNormal,H));
	float dotLH = saturate(dot(LightDir,H));
	
	float F, D, vis;

	float alphaSqr = GGXalpha * GGXalpha;
	
#ifdef ANISOTROPIC	
	float Specular = 0;
	for(float ai = 0; ai < AnisoSteps; ai+=1.0){
		vec3 cAnisoNorm = lerp(WorldAnisoNorm1, WorldAnisoNorm2, ai/AnisoSteps);
		float dotNLA = saturate(dot(cAnisoNorm,LightDir));
		float dotNHA = saturate(dot(cAnisoNorm,H));
		
		float denom = dotNHA * dotNHA *(alphaSqr-1.0) + 1.0f;
		D = alphaSqr/(pi * denom * denom);
	
		float k = GGXalpha/2.0f;
		vis = 1.0f/(dotNLA*(1.0f - k) + k) * 1.0f/(dotNV*(1.0f - k) + k);
	
		Specular += dotNLA * D  * vis*(1.0-cos(ai/AnisoSteps*pi2));
	}
	Specular /= AnisoSteps;
	Specular /= (1.0-anisotropic);
	Specular /= (0.75-Gloss/4.0);
	
#else

	float denom = dotNH * dotNH *(alphaSqr-1.0) + 1.0f;
	D = alphaSqr/(pi * denom * denom);
	
	// V
	float k = GGXalpha/2.0f;
	vis = 1.0f/(dotNL*(1.0f - k) + k) * 1.0f/(dotNV*(1.0f - k) + k);
	
	float Specular = dotNL * D  * vis;	
#endif
	//Burley12 BRDF
	float BurleyF = dotLH * RoughnessFadeE;
	float Diffuse = dotNL * (1.0f + BurleyF * pow(1.0f - dotNL, 5.0f)) * ((1.0f + BurleyF * pow(1.0f - dotNV, 5.0f))+0.5)/1.5;

#ifdef USE_NORMALMAP
	float SSSLambLNV = saturate(dot(GlobalNormal,LightDir));
	Diffuse = lerp(Diffuse,SSSLambLNV,RSSS_Degree);
#endif	
	
	//shading
	//shading
	float shd = (1.0 - RefShade)*0.25;
	float mshd = 1.0-shd;
	vec3 d = vec3(1.0,1.0/255.0,1.0/255.0/255.0);
	
	
	vec4 SPos4 = vec4(oWorldPos,1.0);
	SPos4 = SPos4*ShadowTM;
	SPos4.y = 1.0 - SPos4.y;
	vec3 SPos = SPos4.xyz;

	float shadowBias = 0.05;	
	
//#ifdef SPOS_IN_PIXEL_SHADER
//	vec4 SPos4 = vec4(oWorldPos,1.0);
//	SPos4 = SPos4*ShadowTM;
//	SPos4.y = 1.0 - SPos4.y;
//	vec3 SPos = SPos4.xyz;
	
	vec3 m = texture(ShadowSampler,SPos.xy).xyz;	
	
	float shadowZDist = SPos.z-dot(m,d);
	
	float shiftToLight = 2.0;
	float shadowGradientFade = WShadowMapSize;
	float Multiplier = 0;//saturate(shiftToLight-(shadowZDist)*shadowGradientFade*2.0)*mshd + shd;
	
	float iCircleShift = -2.0;
	
	vec3 laZ = GlobalNormal;
	laZ = normalize(laZ);
	vec3 laX = cross(LightDir, laZ); 
	laX = normalize(laX);
	vec3 laY = cross(laZ, laX);
	
	float iShadowMulCnt = 0.0;
	if(CurrentIteration < 128){
		for(float iy = -3.0; iy < 3.5; iy+=1.0){
			float iCS = max(0.0, abs(iCircleShift)-1.0);
			for(float ix = -3.0+iCS; ix < 3.5-iCS; ix+=1.0){
				float iShadowScatter = 500.0*abs(shadowZDist)*LightScatter*(saturate(1.0-(0.0078125*CurrentIteration))+0.1);
				
				vec4 pxSSPos4 = vec4(oWorldPos.xyz, 1.0) * g_WorldViewProjectionMatrix; 
				vec4 v4Random = fract(abs(cos(vec4((CurrentIteration+ix+pxSSPos4.x)*1335.2212, (CurrentIteration+pxSSPos4.y+iy)*1540.3813, (CurrentIteration+pxSSPos4.z+iy)*5140.381, (CurrentIteration+pxSSPos4.z+ix)*1335.221)))*112.0)*2.0-vec4(1.0,1.0,1.0,1.0);

				v4Random.x = (v4Random.x+v4Random.z)*0.5;
				v4Random.y = (v4Random.y+v4Random.w)*0.5;
				
				float yToCamera = abs(0.0-v4Random.y)*0.4;
				vec4 SPos4 = vec4(oWorldPos+((GlobalNormal*v4Random.y)+(laX*v4Random.x*2.0))*iShadowScatter,1.0);
				SPos4 = SPos4*ShadowTM;
				SPos4.y = 1.0 - SPos4.y;
				vec3 SPos = SPos4.xyz;
				
				vec3 m = texture(ShadowSampler,SPos.xy).xyz;	
				
				float iShadowMul = 1.0-max(abs(v4Random.x),abs(v4Random.y));
				iShadowMul = iShadowMul;
				iShadowMulCnt += iShadowMul;
				float shadowZ = dot(m,d);
				float iShadowZDist = SPos.z-shadowZ;
				float iMultiplier = saturate((abs(v4Random.x)*iShadowScatter*2.0)+shiftToLight+(shadowZ*yToCamera)-(iShadowZDist)*shadowGradientFade*2.0)*mshd + shd;
				Multiplier +=iMultiplier*iShadowMul;
			}
			iCircleShift+= 1.0;
		}
		Multiplier = pow(Multiplier/iShadowMulCnt,0.5);
	} else Multiplier = saturate(shiftToLight-(shadowZDist)*shadowGradientFade*2.0)*mshd + shd;
	
	float dc = Multiplier * saturate(dot(GlobalNormal,LightDir));
	float dcc=dc;//shd + dc*mshd;
	float diffuseFade = pow(dotNV,0.5/pi)*GlossFadeE+(1.0-GlossFadeE);

	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass <= RP_AO
		DiffuseColor.xyz = diffuseFade * Diffuse * Multiplier*mshd + vec3(shd,shd,shd);
		DiffuseColor.xyz = pow(DiffuseColor.xyz,vec3(igamma));
		DiffuseColor.xyz *= getmodf(DiffuseColor.xyz);
		DiffuseColor.xyz = pow(DiffuseColor.xyz,vec3(gamma));
		Diff = DiffuseColor.xyz;
	#endif	
	
	vec3 EnvTexture = ReflectionColor.xyz * (1-IsExternalLight) * lightColor.xyz;

#ifdef SSREFLECTIONS
	vec3 EnvSpec = 0.8*lerp(tSpecular, vec3(1.0,1.0,1.0), pow(lerp(pow(Gloss,0.2), Gloss, Gloss)*(1.0-dotNV),pi*1.3)) * (Specular * Multiplier * lightColor.xyz+SSReflection.xyz*SSReflection.w);// * (1-IsExternalLight);
#else
	vec3 EnvSpec = 0.8*lerp(tSpecular, vec3(1.0,1.0,1.0), pow(lerp(pow(Gloss,0.2), Gloss, Gloss)*(1.0-dotNV),pi*1.3)) * Specular * Multiplier * lightColor.xyz;// * (1-IsExternalLight);
#endif	
	
	float EnvLerp = saturate((Roughness * 5.0f)-2.0f);
	
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
		ReflectionColor.xyz = lerp(EnvTexture , EnvSpec , max(EnvLerp, IsExternalLight))*alpha;
	#endif
#endif

	#if D_RRenderPass <= RP_LIGHT
		DiffuseColor.xyz *= lightColor.xyz;
	#endif

	#if D_RRenderPass < RP_TRANSLUCENT
		#ifdef SSGI
		#ifdef SHADOWS
//			if(iCurrentIteration % 2 == 1){
				vec4 IndirectLight = ScreenSpaceRayTrace(oWorldPos.xyz, GlobalNormal.xyz, 1.0, 16.0, 1.0, 1.0, Roughness);
				DiffuseColor.xyz += IndirectLight.xyz*IndirectLight.w*SecondLightIntensity*0.01;
	//		}
		#endif
		#endif
	#endif

	#if D_RRenderPass < RP_TRANSLUCENT
		DiffuseColor.xyz *= tColor;
	#endif
	
#ifdef SHADOWS
	float iTranslucence = Translucence;
	vec3 iSSScolor = SSScolor.xyz;
#ifdef VOLUME	
	float VolSSSDens = max(max(1.0-transparentColor.x, 1.0-transparentColor.y), 1.0-transparentColor.z)*densityFloat;
	iTranslucence = 1.5-VolSSSDens;
	iSSScolor.xyz = transparentColor.xyz*vec3(VolSSSDens);
	DiffuseColor.xyz *= vec3(1.0-abs(anisotropy));
#endif		
#ifdef USE_SSSHADOW	
	//SSS
	#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_TRANSLUCENT

		float InvLambLightNV = saturate(dot(-GlobalNormal,LightDir));
		float SSSe = pow(saturate(1.0-(SPos.z-dot(m,d))*(1.0 - iTranslucence) * 100.0),3.0);
		vec3 SSS = vec3(SSSe);
		SSS = lerp(iSSScolor.xyz*tColor, tColor, max(pow(SSS,vec3(5,5,5)),pow(saturate(0.5-InvLambLightNV), 1.5))) * SSS*lightColor.xyz;
		SSS = lerp(DiffuseColor.xyz, SSS, (InvLambLightNV/2.0+0.5));
		#if D_RRenderPass == RP_TRANSLUCENT
			DiffuseColor.xyz = SSS - DiffuseColor.xyz;
		#else 
			DiffuseColor.xyz = SSS;	  //activation SSS
		#endif	
	#endif	
#else	
	#if D_RRenderPass == RP_TRANSLUCENT
		DiffuseColor.xyz = vec3(0,0,0);
	#endif
#endif
	
#endif
	#if D_RRenderPass == RP_AO
		DiffuseColor.xyz *= 2.0;
	#endif
	#if D_RRenderPass > RP_AO
		DiffuseColor.xyz = vec3(0,0,0);
	#endif
	
	color.xyz = DiffuseColor.xyz + ReflectionColor.xyz;

	#if D_RRenderPass == RP_EMMISIVE
		FragColor = vec4(Emiss.x, Emiss.y, Emiss.z, 1.0); 
		return;
	#endif

#ifdef VOLUME	
	Emiss.xyz = tColor.xyz*emitColor.xyz;	
#endif
	
	/////////
///// EXT ///////
/////////////	


#ifdef SHADOWS
	float fInLight = saturate(2.0-(SPos.z-dot(m,d))*400);
#endif
	
	
////// REFRACTION ////////////////
#ifdef REFRACTION
#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFRACTION
	float rrE = 1.0-pow((1.0-dotNV), SpecFresnelExp)*Gloss;

		
	vec3 RefractionDir = refract(normalize(ViewDir), normalize(Normal), 1.0-RefractionIOR);
	ReflectionDir = normalize(RefractionDir*WPanMatrix);

	float rrGloss = 1.0-lerp(RefractionRoughness, RefractionRoughness*GlossModulatorC.r, RefractionRoughByTxt);
	float rrGlossFadeE = rrGloss*rrGloss;
	float rropp = 0.85-rrGlossFadeE*0.85+(1.0-rrGlossFadeE*rrGlossFadeE)*0.15;
	
	float rruu = atan(RefractionDir.z,RefractionDir.x)/pi2;
	float rras = asin(RefractionDir.y);
	float rrvv = 0.5+rras/pi*(2048.0-pow(2.0,rropp*7.0))/2048;

	
	
	
	vec4 RefractionColorP = textureLod(Panorama, vec2(rruu, rrvv), rropp * 7.0);	
	RefractionColorP.xyz *= 5.0-RefractionColorP.w*4.0;//extra light range from the texture alpha channel
	RefractionColorP.xyz *= getmodf(RefractionColorP.xyz);
	RefractionColorP.xyz = pow(RefractionColorP.xyz,vec3(gamma));

	
	vec3 iRefractionColor = pow(RefractionColor.xyz, vec3(2.2))*pow(1.0-alpha,0.5);
	vec3 RREnergyComp = 1.0-iRefractionColor;
#ifdef SHADOWS
/*
////////////////////////////////////////
	float ccRoughness = 1.0-ccGloss;
	float ccGGXalpha = lerp(pow(ccRoughness, 3.0), pow(ccRoughness, 1.8), ccRoughness) * 0.99 + 0.01;

	float ccalphaSqr = ccGGXalpha * ccGGXalpha;

	float ccdenom = dotNH * dotNH *(ccalphaSqr-1.0) + 1.0f;
	float ccD = ccalphaSqr/(pi * ccdenom * ccdenom);
	
	// V
	float cck = ccGGXalpha/2.0f;
	float ccvis = 1.0f/(dotNL*(1.0f - cck) + cck) * 1.0f/(dotNV*(1.0f - cck) + cck);
	
	float ccSpecular = dotNL * ccD  * ccvis;	

////////////////////////////////////////
	ccReflectionColor.xyz = ccReflectionColor.xyz * fInLight * lightColor.xyz * (1-IsExternalLight);
	float ccEnvLerp = saturate(-5.0f + (ccRoughness * 20.0f));
	ccReflectionColor.xyz = lerp(ccReflectionColor.xyz , ccSpecular * Multiplier * lightColor.xyz, max(ccEnvLerp, IsExternalLight));
	*/
#endif
	color.xyz = color.xyz*RREnergyComp+RefractionColorP.xyz*iRefractionColor*rrE;
#endif	
#endif	



/////// Reflaction		
	
	uu = atan(ReflectionDir.z,ReflectionDir.x)/pi2;
	as = asin(ReflectionDir.y);
	vv = 0.5+as/pi*(2048.0-pow(2.0,opp*7.0))/2048;	
	
#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
	
////// ARTISTIC ////////////////////	
#ifdef ARTISTIC
	vec4 iSpecularFace = SpecularFace;

	vec3 gSpecularFace = pow(iSpecularFace.xyz, vec3(gamma));
	vec3 gSpecularEdge = pow(SpecularEdge.xyz, vec3(gamma));
	
	vec3 spReflectionColor = ReflectionColor0.xyz;
	
	float SpecularE = iCavBugE;
	float spE = pow((1.0-dotNV)*SpecularE, SpecFresnelExp)*Gloss;

	vec3 SpecularColor = lerp(gSpecularFace.xyz, gSpecularEdge.xyz, spE)*SpecularE;
	SpecularColor = lerp(SpecularColor, SpecularColor*ColorModulatorC.xyz, SpecTextured);
	vec3 spEnergyComp = (1.0-gSpecularFace);//*iCavBugE;
#ifdef SHADOWS

	EnvLerp = saturate(-7.0f + (Roughness * 20.0f));
	spReflectionColor = lerp(spReflectionColor * fInLight * lightColor.xyz * (1-IsExternalLight) , Specular * Multiplier * lightColor.xyz+SSReflection.xyz*SSReflection.w, max(EnvLerp, IsExternalLight));

#endif
	color.xyz = color.xyz*spEnergyComp+spReflectionColor.xyz*SpecularColor;
#endif	




////// PHYSICAL ////////////////////	
#ifdef PHYSICAL
	vec3 gSpecularEdge = pow(SpecularEdge.xyz, vec3(gamma));
	vec3 spReflectionColor = ReflectionColor0.xyz;
	
	float SpecularE = iCavBugE;

	vec3 SpecularColor = gSpecularEdge*SpecularE;
	
	float rDotNV = lerp(dotNV,1.0, Roughness*Roughness);
	
    SpecularColor.x *=fresnelIE(RefractionIndexR, ExtinctionCoefR, rDotNV);
    SpecularColor.y *=fresnelIE(RefractionIndexG, ExtinctionCoefG, rDotNV);
    SpecularColor.z *=fresnelIE(RefractionIndexB, ExtinctionCoefB, rDotNV);
 	
	SpecularColor = lerp(SpecularColor, SpecularColor*ColorModulatorC.xyz, SpecTextured);
	float spEnergyComp = 1.0-max(max(gSpecularEdge.x, gSpecularEdge.y), gSpecularEdge.z)*iCavBugE;

#ifdef SHADOWS
	EnvLerp = saturate(-7.0f + (Roughness * 20.0f));
	spReflectionColor = lerp(spReflectionColor * fInLight * lightColor.xyz * (1-IsExternalLight) , Specular * Multiplier * lightColor.xyz +SSReflection.xyz*SSReflection.w, max(EnvLerp, IsExternalLight));
	
#endif
	color.xyz = color.xyz*spEnergyComp+spReflectionColor*SpecularColor;

#endif
#endif



////// CLEAR COAT ////////////////
#ifdef CLEAR_COAT
#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_CLEAR_COAT

	vec3 gClearCoatFace = pow(ClearCoatFace.xyz, vec3(gamma));
	vec3 gClearCoatEdge = pow(ClearCoatEdge.xyz, vec3(gamma));

	float ccGloss = 1.0-lerp(ClearCoatRoughness, ClearCoatRoughness*GlossModulatorC.r, CCGlossByGlossTxtR);
	float ccRoughness = 1.0-ccGloss;
	float ccGlossFadeE = ccGloss*ccGloss;
	float ccopp = 0.85-ccGlossFadeE*0.85+(1.0-ccGlossFadeE*ccGlossFadeE)*0.15;
	
	vec4 ccReflectionColor = textureLod(Panorama, vec2(uu, vv), ccopp * 7.0)*SpecOcclusion;	

	ccReflectionColor.xyz *= 5.0-ccReflectionColor.w*4.0;//extra light range from the texture alpha channel
	ccReflectionColor.xyz *= getmodf(ccReflectionColor.xyz);
	ccReflectionColor.xyz = pow(ccReflectionColor.xyz,vec3(gamma));
	#ifdef SSREFLECTIONS
		#ifdef SHADOWS
		vec4 SSCCReflection = vec4(0.0, 0.0, 0.0, 0.0);
		if(iCurrentIteration % 4 == 1){
			SSCCReflection = ScreenSpaceRayTrace(oWorldPos.xyz, normalize(reflect(normalize(oWorldPos-g_LocalViewPos)/*oVDir*/, GlobalNormal)), ccRoughness, 24.0+64.0*ccGloss*ccGloss, 1.0, 0.1+ccRoughness*0.5, Roughness);
			ccReflectionColor.xyz = lerp(ccReflectionColor.xyz, SSCCReflection.xyz, saturate(SSReflection.w))*4.0;
			SSCCReflection.xyz *= 4.0;
		} else ccReflectionColor.xyz *= 0.0;
		#endif
	#endif

	
	float ClearCoatE = lerp(1, GlossModulatorC.a, CCByGlossTxtA)*lerp(1, ialpha, CCPaintReplace);
	float ccE = pow((1.0-dotNV)*ClearCoatE, CCFresnelExponent)*ccGloss;

	vec3 ClearCoatColor = lerp(gClearCoatFace.xyz, gClearCoatEdge.xyz, ccE)*ClearCoatE;
	vec3 CCEnergyComp = 1.0-ClearCoatColor;
#ifdef SHADOWS

////////////////////////////////////////
//	float ccGGXalpha = lerp(pow(ccRoughness, 3.0), pow(ccRoughness, 1.8), ccRoughness) * 0.99 + 0.01;
	float ccGGXalpha = saturate(ccRoughness * ccRoughness+LightScatter*0.2) * 0.995 + 0.005;   // roughness offset for glossy surfaces

	float ccalphaSqr = ccGGXalpha * ccGGXalpha;

	float ccdenom = dotNH * dotNH *(ccalphaSqr-1.0) + 1.0f;
	float ccD = ccalphaSqr/(pi * ccdenom * ccdenom);
	
	// V
	float cck = ccGGXalpha/2.0f;
	float ccvis = 1.0f/(dotNL*(1.0f - cck) + cck) * 1.0f/(dotNV*(1.0f - cck) + cck);
	
	float ccSpecular = dotNL * ccD  * ccvis;	

////////////////////////////////////////
	ccReflectionColor.xyz = ccReflectionColor.xyz * fInLight * lightColor.xyz * (1-IsExternalLight);
	float ccEnvLerp = saturate(-5.0f + (ccRoughness * 20.0f));
	ccReflectionColor.xyz = lerp(ccReflectionColor.xyz , ccSpecular * Multiplier * lightColor.xyz, max(ccEnvLerp, IsExternalLight));
	
#ifdef SSREFLECTIONS
#ifdef SHADOWS
	ccReflectionColor.xyz += SSReflection.xyz*SSReflection.w;
#endif
#endif	
	
#endif
	color.xyz = color.xyz*CCEnergyComp+ccReflectionColor.xyz*ClearCoatColor.xyz;
#endif	
#endif	


////// MICROPROTRUSIONS ///////////
#ifdef MICROPROTRUSIONS
#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_MICROPROTRUSIONS && D_RRenderPass <= RP_MICROPROTRUSIONS_LIGHT)
	float exPI = 3.1415926;
	float exPI2 = 6.2831853;

	vec3 FurNormal = Normal+ViewDir * dot(ViewDir, Normal) * 2.0;
	FurNormal = normalize(FurNormal*WPanMatrix);
	
	float MicroprotrusionsAm = Microprotrusions/100.0/**Microprotrusions_Modulator.w*/;
	float MicroprotrusionsAmExPI = pow(MicroprotrusionsAm, exPI);
	float MicroprotrusionsE = lerp(saturate(1.0-pow(dotNV,MicroprotrusionsAm*exPI)), 1.0, MicroprotrusionsAmExPI);
	#if D_RRenderPass == RP_MICROPROTRUSIONS_MASK
		FragColor = vec4(MicroprotrusionsE, MicroprotrusionsE, MicroprotrusionsE, 1.0);
		return;
	#endif
	vec4 rMicroprotrusionsColor;
	rMicroprotrusionsColor.xyz = lerp(pow(MicroprotrusionsColor.xyz, vec3(2.2)), tColor.xyz,MicroprotrusionsTint);
	vec3 McN = normalize(FurNormal);//*(1.0-dotNV));
	McN = normalize((McN*1.5+ViewDir*(1.0-dotNV)));
#ifdef SHADOWS
	vec3 SMcN = normalize((GlobalNormal+(oVDir+dN)*(1.0-dotNV)));

	float LambLightNVMP = max(0.0,dot(GlobalNormal,LightDir));
	float MLightNV = 1.0-(dot(SMcN,LightDir)*dot(GlobalNormal,LightDir));
	vec4 MGlobalIllumination = DiffuseColor*rMicroprotrusionsColor*(1.0-MicroprotrusionsAmExPI)+(rMicroprotrusionsColor+rMicroprotrusionsColor*lightColor*rMicroprotrusionsColor*MicroprotrusionsAmExPI)*LambLightNVMP/2.0;
	rMicroprotrusionsColor = (rMicroprotrusionsColor*MLightNV*lightColor+MGlobalIllumination)*fInLight*LambLightNVMP;
#else
	uu = atan(GlobalNormal.z,GlobalNormal.x)/exPI2;
	vv=0.5+asin(GlobalNormal.y*0.9999)/exPI*(64.0-0.5)/64.0;	
	vec4 MicroprotrusionsLambColor=texture(PanoramaDiffuse,vec2(uu,vv));
	
	uu = atan(McN.z,McN.x)/exPI2;
	vv=0.5+asin(McN.y)/exPI*(64.0-0.5)/64.0;	
	vec4 MicroprotrusionsLColor=texture(PanoramaDiffuse,vec2(uu,vv));
	vec4 MGlobalIllumination = DiffuseColor*rMicroprotrusionsColor+rMicroprotrusionsColor*MicroprotrusionsLambColor*rMicroprotrusionsColor*MicroprotrusionsAm;
	rMicroprotrusionsColor = rMicroprotrusionsColor*MicroprotrusionsLColor/1.2+MGlobalIllumination;
#endif
	#if D_RRenderPass == RP_MICROPROTRUSIONS_LIGHT
		FragColor = vec4(rMicroprotrusionsColor.x, rMicroprotrusionsColor.y, rMicroprotrusionsColor.z, 4.0)/4.0; 
		return;
	#endif
	color.xyz = lerp(color.xyz, rMicroprotrusionsColor.xyz, MicroprotrusionsE);
#endif
#endif

//////////////////////////////////


////// Fuzz ///////////
#ifdef FUZZ
#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_FUZZ && D_RRenderPass <= RP_FUZZ_LIGHT)
	float FuzzAm = max(Fuzz, FuzzOnTop * GlobalNormal.y)/20.0*Fuzz_Modulator.w;
	float FuzzE = saturate(max(1.0-pow(dotNV,FuzzAm),FuzzAm/pi));
	FuzzE = lerp(FuzzE, FuzzE*GlossModulatorC.z, FuzzByGlossTxtB)*lerp(1, ialpha, FuzzPaintReplace);
	#if D_RRenderPass == RP_FUZZ_MASK
		FragColor = vec4(FuzzE, FuzzE, FuzzE, 0.25)*4.0; 
		return;
	#endif
	vec3 rFuzzColor = pow(FuzzColor.xyz, vec3(gamma))*Fuzz_Modulator.xyz;
	rFuzzColor = lerp(rFuzzColor, rFuzzColor*color.xyz, FuzzTint);
#ifdef SHADOWS
	float LambLightNV = max(0.0,dot(GlobalNormal,LightDir));
	rFuzzColor = rFuzzColor*(pow(fInLight, 1.0-LambLightNV)*pow(LambLightNV,0.5))*lightColor.xyz;
#else
	uu = atan(GlobalNormal.z,GlobalNormal.x)/pi2;
	vv=0.5+asin(GlobalNormal.y*0.9999)/pi*(64.0-0.5)/64.0;	
	vec3 FuzzLColor=texture(PanoramaDiffuse,vec2(uu,vv)).xyz;
	rFuzzColor = rFuzzColor*FuzzLColor;
#endif
	#if D_RRenderPass == RP_FUZZ_LIGHT
		FragColor = vec4(rFuzzColor.x, rFuzzColor.y, rFuzzColor.z, 8.0)/8.0; 
		return;
	#endif
	color.xyz = lerp(color.xyz, rFuzzColor, FuzzE);
#endif

#endif
	
////// OPACITY /////////	

	color.xyz  = color.xyz + Emiss;	
// FOG	
#ifdef IS_VOXEL_SHADER
	float Wde = saturate(pow((1.0/oExtra.w)*pow(WFogDensity/10000.0,2.0),WFogPower));
	
	#if D_RRenderPass == RP_DEPTH
		FragColor = vec4(Wde, Wde, Wde, 1.0); 
		return;
	#endif

#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_FOG && D_RRenderPass <= RP_FOG_LIGHT)
	
   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette*Wde)).xyz;
   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette/50.0-1.0)).xyz;

#ifdef SHADOWS	



	color.xyz = lerp(color.xyz,vec3(Multiplier,Multiplier,Multiplier),WLightSilhouette/100.0).xyz;

	// FOG
#ifdef SPOS_IN_PIXEL_SHADER
#ifdef D_WFogDensity
	#ifdef D_WVolumeFogSamples


#define FOG_STEPS 32
		vec3 WOldSVPos = SPos.xyz;
		float WOldFogWde = pow((1.0/oExtra.w)*(WFogDensity/10000.0,2.0),WFogPower);
		float WFogWde = 0;
		float WFogStep = 1.0/FOG_STEPS;
		float WFogLerpPos = 0.0;
		float VSWdeDeltaSum = 0.0;
		float VSWdeDeltaWOShadowSum = 0.0;
//		int iWVolumeFogSamples = max(3,WVolumeFogSamples);
		
		vec3 WFogVolumeColorResult = vec3(0,0,0);
		
		
		for(int iVSS = 0; iVSS < FOG_STEPS; iVSS++){
			WFogLerpPos += WFogStep;
			float WFogLerpPosRand = WFogLerpPos-(WFogStep*WFogRand);
			
			vec4 zP = vec4(lerp(oPos.xyz , g_LocalViewPos.xyz,WFogLerpPos), 1.0);
			vec4 zPC = zP * g_WorldViewProjectionMatrix;
			vec4 zExtra = vec4(0,0,0,0);
			zExtra.yz =  (1.0 + zPC.xy / zPC.w ) / 2.0;
			zExtra.z = (1.0 - zExtra.z);
			zExtra.yz += vec2(du/2,dv/2);
			zExtra.w=1.0/zPC.w;//In.Color2.x;
		
			float VSWde = pow((1.0/lerp(oExtra.w, 1.0, WFogLerpPosRand))*(WFogDensity/10000.0,2.0),WFogPower);
			float VSWdeDelta = saturate(WOldFogWde-VSWde);
				
			vec4 SPos4VS = vec4(lerp(oWorldPos.xyz, g_LocalViewPos.xyz, WFogLerpPosRand),1.0);
			SPos4VS = SPos4VS * ShadowTM;
			SPos4VS.xy += vec2(0.5/ShadowMapSide,0.5/ShadowMapSide);
			SPos4VS.y = 1.0 - SPos4VS.y;

			vec3 dVS = vec3(1.0,1.0/255.0,1.0/255.0/255.0);

			vec3 VSPos = SPos4VS.xyz;
			vec3 mVS = texture(ShadowSampler,VSPos.xy).xyz;	
				
			float MultiplierVS = saturate(2.0-(VSPos.z-dot(mVS,dVS)-shadowBias)*WShadowMapSize*2.0);
			WFogVolumeColorResult += WFogColor.zyx*lightColor.xyz*MultiplierVS*VSWdeDelta;
			WOldFogWde = VSWde;
			VSWdeDeltaSum += VSWdeDelta;
			VSWdeDeltaWOShadowSum += VSWdeDelta*MultiplierVS;
		}
		
		float fogMask = saturate(min(Wde, Wde*pow(VSWdeDeltaWOShadowSum/VSWdeDeltaSum, max(0.1,WFogShadows-1.0))));
		vec3 fogLight = WFogVolumeColorResult/VSWdeDeltaSum;
		color.xyz = lerp(color.xyz,lerp(WFogColor.zyx*lightColor.xyz, fogLight, min(1.0, WFogShadows)), fogMask).xyz;
		
		#if D_RRenderPass == RP_FOG_LIGHT 
			FragColor = saturate(vec4(fogLight.x/2.0, fogLight.y/2.0, fogLight.z/2.0, 1.0)); 
			return;
		#endif
		
		#if D_RRenderPass == RP_FOG_MASK
			FragColor = saturate(vec4(fogMask,fogMask,fogMask,1)*2.0); 
			return;
		#endif	
		
	#else
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif	
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx,Wde).xyz;
	#endif
#endif	
#endif			
#endif			
//// RR END ///

	vec3 ResColor = pow(color.xyz*LDiffuse22C,vec3(igamma));
	color.xyz = lerp(ResColor,ResColor*0.5,Freeze*FreezeMod);//+saturate(pow(1.0-dotNV,20.0)*15.0);
	color.w = mix(sfColor.w, max(sfColor.w*sfColor.w*sfColor.w, 1.0-dotNV), Gloss)*saturate(1.0-(1.0-sfColor.w)*(1.0-sfColor.w)*(1.0-sfColor.w));

#ifdef VOLUME	
	float rVolumeDens = max(max(1.0-transparentColor.x, 1.0-transparentColor.y), 1.0-transparentColor.z)*densityFloat;
	color.w = color.w*pow(dotNV, max(0.1, 2.0-rVolumeDens*2.5))*pow(rVolumeDens, 0.15);
#endif
	
#ifdef SHADOWS
	if(fract(CurrentIteration * 0.1) < (1.0-color.w*color.w)) {
		discard;
	}
	color.w = 1.0;
#endif
}