// Vertex shader
uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;

uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;


in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

void main() {
	v_TexCoord0 = vec2(vec4(TexCoord0, 0.0, 1.0) * g_TextureMatrix0);
	v_TexCoord1 = vec2(vec4(TexCoord1, 0.0, 1.0) * g_TextureMatrix1);
	v_TexCoord0.y=1.0-v_TexCoord0.y;
	v_TexCoord1.y=1.0-v_TexCoord1.y;


	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;

	v_Color = Color;
}

// Fragment shader

uniform vec3 ExtraGamma;
#include "/Templates/contrast.glsl"

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;

uniform sampler2D s_Sampler0;
uniform float MulFactor;
uniform float MulFactorAlpha;

uniform vec3 ViewPos;

uniform sampler2D AScreenSampler;
uniform sampler2D DepthSampler;
uniform sampler2D Panorama;

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_ScreenToWorldMatrix;

uniform mat4 mFrom;
uniform mat4 mRayDir;

uniform float aSceneTime;
uniform float UseACES;

out vec4 FragColor;
void main() {
	vec4 c = texture(AScreenSampler, v_TexCoord0);
	c.xyz*=MulFactor;
	c.w*=MulFactorAlpha;
	if(UseACES > 0.0){
		c.xyz = ndAcesTonemap(c.xyz);
	} 
	c.xyz = pow(c.xyz,vec3(1.0/2.2));
	
	vec3 dotRawDepth = vec3(1.0,1.0/255.0,1.0/255.0/255.0);
	vec4 depthRaw = texture(DepthSampler, vec2(v_TexCoord0.x,1.0-v_TexCoord0.y));
	float pxDepth = dot(dotRawDepth, depthRaw.xyz)*65536.0;
		
//	c.w=saturate(c.w*2.0);
	//vec4 c1 = texture(s_Depth, v_TexCoord1);	
	//c.xyz+=(c1.xyz-0.5)*2;
	
#ifdef NODE_CODE
	#define ioPanorama Panorama;
	ioCameraPosition = vec4(ViewPos, 0.0);
	
//	vec4 vFrom = mix(mix(mFrom[0],mFrom[1], v_TexCoord0.x),mix(mFrom[2],mFrom[3], v_TexCoord0.x), fract(100.0-v_TexCoord0.y)); 
//	vec4 vRayDir = mix(mix(mRayDir[0],mRayDir[1], v_TexCoord0.x),mix(mRayDir[2],mRayDir[3], v_TexCoord0.x), fract(100.0-v_TexCoord0.y)); 
	vec4 vRayDir = (vec4(v_TexCoord0.x*2.0-1.0, fract(100.0-v_TexCoord0.y)*2.0-1.0, 1.0, 1.0) * g_ScreenToWorldMatrix);
	vRayDir /= vRayDir.w;
	vRayDir.xyz-=ioCameraPosition.xyz;
	vRayDir.w = 0;
	float uMod = sin(v_TexCoord0.y*3.14159);
	ioRayDir = normalize(-vRayDir);//-normalize(vec4(cos(v_TexCoord0.x*6.28319)*uMod,v_TexCoord0.y*2.0-1.0/*asin(1.0-oTexCoord.y*2.0)*0.318310*/, sin(v_TexCoord0.x*6.28319)*uMod, 0.0));
	////////////////////////////////////////////////
	ioResolution = vec4(4096.0, 2048.0, 0.0, 0.0);           // viewport resolution (in pixels)
	ioTime = vec4(aSceneTime);                 // shader playback time (in seconds)
	ioTimeDelta = 0.033*vec4One;            // render time (in seconds)
	ioFrame = vec4Zero;                // shader playback frame
	ioMouse = vec4Zero;                // mouse pixel coords. xy: current (if MLB down), zw: click
//	ioDate;                 // (year, month, day, time in seconds)
	ioFragCoord = vec4(v_TexCoord0.x,1.0-v_TexCoord0.y, v_TexCoord0.x,1.0-v_TexCoord0.y);
	ioPosition = ioFragCoord;
	ioNormal = vec4(0.0, 1.0, 0.0, 0.0);

	ioPM = vec4(c.xyz*0.5, 1.0);
	ioPQ1 = vec4(0.5);
	ioPQ2 = vec4(0.0);
	ioPQ3 = vec4(0.5);
	ioPQ4 = vec4(0.5);
	ioPN = vec4(0.5, 0.5, 0.0, 0);

	ioDisplacement = vec4(pxDepth);//vec4Zero;

	NODE_CODE;


//	Normal.xyz = -ioNormal.xyz;

//	tSpecular = ioAlbedoColor.xyz*saturate(ioMetal.xyz);
	c.xyz = ioPM.xyz*2.0;
	c.w = 1.0;
//	ioReflectionColor *= vec4One-saturate(ioMetal);
//	tColor = ioAlbedoColor.xyz;
//	tSpecular += ioReflectionColor.xyz;
//	Gloss = ioGloss.w;
//	Emiss = ioEmissive.xyz;
//	sfColor.w = ioOpacity.w;
#endif	
	
	
	FragColor = c;
}