// Vertex shader

uniform mat4 ShadowTM;

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;
in vec3 Tangent;
in vec3 BiTangent;


out float oDepth;
out vec3 oPos;
out vec2 oTexCoord;
out vec3 N;
out vec3 T;
out vec3 B;
out vec4 oIndices;
out vec4 oWeights;

void main() {
	vec4 P = vec4(Pos, 1.0);
	P *= ShadowTM;
#ifdef SCALE_Z
	P.z = P.z/2.0;
#endif // SCALE_Z
	oDepth = P.z;
	
	N=Normal;
	T=Tangent.xyz;
	B=BiTangent.xyz;
	
	oTexCoord.x = TexCoord.x;
	oTexCoord.y = TexCoord.y;
	oPos = P.xyz;
	
	
	gl_Position = P;
	

}

// Fragment shader

in float oDepth;
in vec3 oPos;
in vec2 oTexCoord;
in vec3 N;
in vec3 T;
in vec3 B;

uniform sampler2D s_NormalMap;
uniform sampler2D s_ColorMap;
uniform sampler2D s_SpecularMap;
       
out vec4 FragColor;
void main() {

#ifdef SCULPT
	vec4 normal = vec4(N, 0.0);
	
#else	
	vec4 nrm = texture(s_NormalMap,oTexCoord);   
	nrm.w = 0;

	vec3  N2=vec3(nrm.x*2-1,0.0,nrm.y*2-1);
	N2.y=sqrt(1-N2.x*N2.x-N2.z*N2.z);	
	vec3 nn=normalize(N);
	vec3 tt=normalize(T-nn*dot(T,nn));
	vec3 bb=normalize(B-nn*dot(B,nn)-tt*dot(B,tt));
	N2=nn*N2.y-tt*N2.x-bb*N2.z;

	vec3 N3 = normalize(N2);	

	vec4 normal = vec4(N3.x, N3.y, N3.z, 0.0);

#endif
	
	
    vec4 c = vec4(oDepth, normal.x, normal.y, normal.z);
 
    FragColor = c;
}