// Vertex shader

uniform float Lx;
uniform float Ly;
uniform vec4 QuadPosition;//, Vector4D(aGPUQX / (pModelPointsScope->Lx / GPUQuadSize), aGPUQY / (pModelPointsScope->Ly / GPUQuadSize), aGPUQX, aGPUQY);

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;
in vec3 Tangent;
in vec3 BiTangent;
in vec4 Indices;
in vec4 Weights;

out vec4 oPos;
out vec2 oTexCoord;
out vec4 oqPos;
out vec4 oWeights;

void main() {
	float GPUQuadSize = 512.0;
	
	oTexCoord.x = (TexCoord.x-QuadPosition.x)*(Lx/GPUQuadSize);
	oTexCoord.y = (TexCoord.y-QuadPosition.y)*(Ly/GPUQuadSize);

	oWeights = Weights;

//	oTexCoord.x = TexCoord.x;
//	oTexCoord.y = TexCoord.y;
	

	oPos.x = TexCoord.x*2.0-1.0;
	oPos.y = TexCoord.y*2.0-1.0;
	oPos.z = 1.0;
	oPos.w = 1.0;

	oqPos.x = TexCoord.x;//Pos.x*0.5+0.5;
	oqPos.y = 1.0-TexCoord.y;//1.0-(Pos.y*0.5+0.5);
	oqPos.z = 1.0;
	oqPos.w = 1.0;
	
	gl_Position = oPos;
	
}
// Fragment shader


in vec4 oPos;
in vec2 oTexCoord;
in vec4 oqPos;
in vec4 oWeights;


uniform float Lx;
uniform float Ly;

uniform sampler2D s_MTexture;
uniform sampler2D s_Q1Texture;
uniform sampler2D s_Q2Texture;
uniform sampler2D s_Q3Texture;
uniform sampler2D s_Q4Texture;
uniform sampler2D s_NTexture;
uniform sampler2D s_DTexture;


out vec4 FragData[4];


uniform float TimeSeconds;


void main(){
	if(oTexCoord.x < 0 || oTexCoord.y < 0 || oTexCoord.x > 1.0 || oTexCoord.y > 1.0) discard;
	
	float LSpecI = 0.2;
	vec4 zr4 = vec4(0,0,0,0);
	float LxE = 1.0/Lx;
	float LyE = 1.0/Ly;
	float LxEw = 0.5/Lx;
	float LyEh = 0.5/Ly;
	
	vec2 wPos = vec2(oqPos.x, 1.0-oqPos.y);	

	
	vec4 s_V0 = texture(s_MTexture, oTexCoord);
	vec4 s_V1 = texture(s_Q1Texture, oTexCoord);
	vec4 s_V2 = texture(s_Q2Texture, oTexCoord);
	vec4 s_V3 = texture(s_Q3Texture, oTexCoord);
	vec4 s_V4 = texture(s_Q4Texture, oTexCoord);
	vec4 s_V5 = texture(s_NTexture, oTexCoord);
	vec4 s_V6 = texture(s_DTexture, oTexCoord);

#ifdef EFFECT
EFFECT
#endif	
	
	
	FragData[0] = s_V1;
	FragData[1] = s_V2;
	FragData[2] = s_V3;
	FragData[3] = s_V4;

}

