
// Vertex shader

#include "/Templates/layer_quad_vs.glsl"

// Fragment shader
#line 7 7
in vec4 oPos;
in vec2 oTexCoord;
in vec4 oqPos;

in vec4 oIOPosition;
in vec4 oIONormal;



uniform sampler2D s_SourceColor;
uniform sampler2D s_SourceFloat;
uniform sampler2D s_SourceBytes;

uniform sampler2D s_MTexture;
uniform sampler2D s_Q1Texture;
uniform sampler2D s_Q2Texture;
uniform sampler2D s_Q3Texture;
uniform sampler2D s_Q4Texture;
uniform sampler2D s_NTexture;
uniform sampler2D s_DTexture;

uniform sampler2D s_LinkedLayer;

uniform sampler2D s_AO;
uniform sampler2D s_Cavity;

uniform vec4 LiteLinkedLayerColor;

uniform vec4 LiteSourceColor;
uniform vec4 LiteSourceFloat;
uniform vec4 LiteSourceBytes;

uniform float SpecularIntensity;
uniform float DepthTransparency;
uniform float ColorTransparency;
uniform float MetalnessOpacity;
uniform float RoughMod;
uniform float GlossMod;
uniform float CurLayerId;
uniform float MaxFloatValue;
uniform float MinFloatValue;
uniform float Contrast;
uniform float Brightness;
uniform float SpecContrast;
uniform float SpecularMod;
uniform float SpecBrightness;
uniform float MetalBrightness;
uniform float ReplaceAlpha;
uniform float FillNGLayer;

uniform float TimeSeconds;

uniform float ReplaceDepth;
uniform float LayerHeight;

uniform	float QCColorOffset;
uniform	float QCBytesOffset;
uniform	float QCBytesOffset2;
uniform	float QCFloatOffset;

uniform	float QCColorMultiply;
uniform	float QCColorMultiplyInv;
uniform	float QCBytesMultiply;
uniform	float QCBytesMultiply2;
uniform	float QCFloatMultiply;


uniform float TextureWidth;//, float(pModelPointsScope->Lx));
uniform float TextureHeight;//, float(pModelPointsScope->Ly));
uniform vec4 QuadPosition;//, Vector3D(aGPUQX, aGPUQY, GPUQuadSize));

//out vec4 FragColor;
out vec4 FragData[7];


vec3 HCYtoRGB (vec3 hsv){
	while(hsv.x<0.0)hsv.x+=360.0;
	while(hsv.x>=360.0)hsv.x-=360.0;
	int i;
	float f, p, q, t, hTemp;
	float h = hsv.x;
	float s = hsv.y;
	float v = hsv.z;
	float r, g, b;
	vec3 rgb;
	if (s == 0.0 || h == -1.0){ // s==0? Totally unsaturated = grey
		rgb.x = rgb.y = rgb.z = v;
	}
	float C=s;
	hTemp = h / 60.0;
	float v0=0;
	float cmax=1;
	for(int j=0;j<2;j++){
		if(s>cmax)s=cmax;
		if(j==0) s = 1.0;
		float X=C*(1-abs((mod(hTemp, 2.0))-1));
		i = int(floor(hTemp));                 // which sector
		switch (i){
			case 0: r = C; g = X; b = 0; break;
			case 1: r = X; g = C; b = 0; break;
			case 2: r = 0; g = C; b = X; break;
			case 3: r = 0; g = X; b = C; break;
			case 4: r = X; g = 0; b = C; break;
			case 5: r = C; g = 0; b = X; break;
			default: r=0 ; g=0 ; b=0 ; break ; // Should never occur
		}
		if(j==0){
			v0=0.3*r+0.59*g+0.11*b;
			if(v<v0)cmax=v/v0;
			else cmax=(1-v)/(1-v0);
		}
	}
	float m=v-(0.3*r+0.59*g+0.11*b);
	rgb.x = b+m;
	rgb.y = g+m;
	rgb.z = r+m;
	return rgb;
}


vec4 toRGB3 (vec4 clr){
	vec3 hsv = vec3(clr.x,clr.y,clr.z);	
	if(clr.y<0)clr.y=0;
	if(clr.y>1)clr.y=1;
	vec4 result;
	result.xyz = HCYtoRGB(hsv);
	result.w = clr.w;
	return result;
}

vec3 RGBtoHCY (vec3 rgb){
	float r = rgb.z;
	float g = rgb.y;
	float b = rgb.x;
	vec3 hsl;
	float h, s, v;
	float mn = r, mx = r;
	int maxVal = 0;
	if (g > mx) { mx = g; maxVal = 1; }
	if (b > mx) { mx = b; maxVal = 2; }
	if (g < mn) mn = g;
	if (b < mn) mn = b;
	float  delta = mx - mn;
	v = 0.3*r+0.59*g+0.11*b;
	if (delta != 0){
		s = delta;
	}else{
		s = 0;
		h = 0;
		hsl.x = h;
		hsl.y = s;
		hsl.z = v;
		return hsl;
	}
	if (s == 0.0f){
		h = 0;
		hsl.x = h;
		hsl.y = s;
		hsl.z = v;
		return hsl;
	}else{
		switch (maxVal){
			case 0: h = 0 + ( g - b ) / delta; break;     // yel  < h < mag
			case 1: h = 2 + ( b - r ) / delta; break;     // cyan < h < yel
			case 2: h = 4 + ( r - g ) / delta; break;     // mag  < h < cyan
			default: h = 0 ; break ; // Should never occur
		}
	}
	h *= 60;
	if (h < 0) h += 360;
	hsl.x = h;
	hsl.y = s;
	hsl.z = v;
	return hsl;
}


vec4 toHCY (vec4 clr){
	vec3 hsv = clr.xyz;	
	vec4 result;
	result.xyz = RGBtoHCY(hsv);
	result.w = clr.w;
	return result;
}

float Getcpow(const vec4 c){
	return c.z*0.3+c.y*0.59+c.x*0.11;
}

#include "/Templates/layer_filters.glsl"


	#define iResultColorD iResultMaps[COLOR_TARGET]
//	#define iResultColor (iResultMaps[COLOR_TARGET]*vec4(QCColorMultiply, QCColorMultiply, QCColorMultiply, 1.0)+vec4(QCColorOffset, QCColorOffset, QCColorOffset, 0))
	#define iResultColor ((iResultMaps[COLOR_TARGET]-vec4(QCColorOffset, QCColorOffset, QCColorOffset, 0))/vec4(QCColorMultiply, QCColorMultiply, QCColorMultiply, 1.0))
	#define iResultFloat iResultMaps[FLOAT_TARGET]

void main() {
	
	vec4 inAO = texture(s_AO, vec2(oqPos.x, oqPos.y));
	vec4 inCavity = texture(s_Cavity, vec2(oqPos.x, oqPos.y));
	vec4 inLinkedLayer = max(texture(s_LinkedLayer, vec2(oqPos.x, oqPos.y)), LiteLinkedLayerColor);
	ioMaskLayer = inLinkedLayer;
#ifdef INVERSE_LINKAGE
	inLinkedLayer.w = 1.0-inLinkedLayer.w;
#endif	

	vec4 iResultMaps[7];
	vec4 iResultMapsS[7];
	
	iResultMaps[0] = texture(s_MTexture, vec2(oqPos.x, oqPos.y));
	iResultMaps[1] = texture(s_Q1Texture, vec2(oqPos.x, oqPos.y));
	iResultMaps[2] = texture(s_Q2Texture, vec2(oqPos.x, oqPos.y));
	iResultMaps[3] = texture(s_Q3Texture, vec2(oqPos.x, oqPos.y));
	iResultMaps[4] = texture(s_Q4Texture, vec2(oqPos.x, oqPos.y));
	iResultMaps[5] = texture(s_NTexture, vec2(oqPos.x, oqPos.y));
	iResultMaps[6] = texture(s_DTexture, vec2(oqPos.x, oqPos.y));

	iResultMapsS[0] = iResultMaps[0];
	iResultMapsS[1] = iResultMaps[1];
	iResultMapsS[2] = iResultMaps[2];
	iResultMapsS[3] = iResultMaps[3];
	iResultMapsS[4] = iResultMaps[4];
	iResultMapsS[5] = iResultMaps[5];
	iResultMapsS[6] = iResultMaps[6];

	ioBackgroundMTL	= iResultMaps;
	
	vec4 iResultColorBuf = iResultColorD;


#if COLOR_TARGET == 5
	vec4 iLayerColor = max(texture(s_SourceColor, vec2(oqPos.x, oqPos.y)), LiteSourceColor);
#else		
	vec4 iLayerColor = max(texture(s_SourceColor, vec2(oqPos.x, oqPos.y)), LiteSourceColor).zyxw;
#endif		
	vec4 iLayerFloat = max(texture(s_SourceFloat, vec2(oqPos.x, oqPos.y)), LiteSourceFloat);
//	vec4 iLayerBytes = max(texture(s_SourceBytes, vec2(oqPos.x, oqPos.y)), LiteSourceBytes);
	vec4 iLayerBytes = texture(s_SourceBytes, vec2(oqPos.x, oqPos.y));
	
	ioSpecularMask = iLayerBytes.wwww;
	
//	float Specular = pow(SpecularIntensity,2.2);

#ifdef IS_FOLDER
//	iLayerBytes.x = 1.0;
//	iLayerBytes.y = 1.0;
//	iLayerBytes.z = 1.0;
//	iLayerBytes.w = 1.0;
#endif

//	iLayerColor.xyz = pow(iLayerColor.xyz,vec3(2.2,2.2,2.2));
//	iResultColor.xyz = pow(iResultColor.xyz,vec3(2.2,2.2,2.2));
	

	
	float v = RGBToFloat(iLayerFloat);
//	v = v/MaxFloatValue;
	
	ioLayerColor = iLayerColor;
	ioLayerBytes = iLayerBytes;
	ioLayerFloat = vec4(v, v, v, v);	

	vec4 meshNormal = oIONormal;//vec4(0);//meshNormalRaw;
	vec4 meshPosition = oIOPosition;//vec4(meshPositionX, meshPositionY, meshPositionZ, 0.0);
	
////////////////////////////////////////////////////////////	
	iLayerColor.w *= inLinkedLayer.w;
	iLayerBytes.w *= inLinkedLayer.w;
	float iReplaceAlpha = ReplaceAlpha;

#if COLOR_TARGET == 5
	iLayerColor.x = 1.0-iLayerColor.z; 
	iLayerColor.y = iLayerColor.y; 
#endif

	iLayerColor.xyz = (iLayerColor.xyz-vec3(0.5))*(1.0+Contrast)+vec3(Brightness*0.01)+vec3(0.5);
	iLayerColor.w *= ColorTransparency;

	float iLayerColorAlpha = iLayerColor.w;
//	iLayerColor.w *= 0.5;

	v *= inLinkedLayer.w;
////////////////////////////////////////////////////////////	

	iResultMaps[0].w = 0;
//	iLayerColor.xyz = iLayerColor.xyz* meshPosition.xyz;
	iLayerColor = saturate(iLayerColor);

	NGMask = max(max(vec4(iLayerColorAlpha), iLayerBytes.wwww), FillNGLayer);

	iLayerColorAlpha = mix(iLayerColorAlpha, iLayerBytes.w, ReplaceAlpha);
#ifdef bmBlend
	float A = iLayerColorAlpha;///max(iLayerColorAlpha+iResultColor.w,0.001);
	vec4 oColor = iResultColor*(1.0-A)+iLayerColor*A;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmBlendP
	int r = (oqPos.x*1000.0+oqPos.y*1234.0+oqPos.x*oqPos.y*22134.0) % (255.0-pow(iLayerColorAlpha,0.05)*255.0);
	vec4 oColor = iResultColor;
	if(r==0) oColor = iLayerColor;
//	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+iLayerColor*iLayerColorAlpha;
	oColor.w = 1;//saturate(iLayerColorAlpha+iResultColor.w);
#endif	
#ifdef bmDarken
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+min(iLayerColor,iResultColor)*iLayerColorAlpha;
	oColor.w = iResultColor.w;
#endif
#ifdef bmMultiply
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iLayerColor*iResultColor)*iLayerColorAlpha;
	oColor.w = iResultColor.w;
#endif	
#ifdef bmColorBurn
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(1.0 - (1.0 - iResultColor) / iLayerColor)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmLinearBurn
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iResultColor + iLayerColor - 1.0)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmLighten
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+max(iLayerColor,iResultColor)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmScreen
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(1.0 - (1.0 - iResultColor) * (1.0 - iLayerColor))*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmColorDodge
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iResultColor / (1.0 - iLayerColor))*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmLinearDodge
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iResultColor + iLayerColor)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmOverlay
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iResultColor > .5 ? 1.0 - 2.0 * (1.0 - iResultColor) * (1.0 - iLayerColor) : 2.0 * iResultColor * iLayerColor)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmSoftLight
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+((1.0 - iResultColor) * iResultColor * iLayerColor + iResultColor * (1.0 - (1.0 - iResultColor) * (1.0 - iLayerColor)))*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmHardLight
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iLayerColor > .5 ? 1.0 - (1.0 - iResultColor) * (1.0 - 2.0 * (iLayerColor - .5)) : iResultColor * (2.0 * iLayerColor))*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmVividLight
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iLayerColor > .5 ? iResultColor / (1.0 - (iLayerColor - .5) * 2.0) : 1.0 - (1.0 - iResultColor) / (iLayerColor * 2))*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmLinearLight
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iLayerColor > .5 ? iResultColor + 2.0 * (iLayerColor - .5) : iResultColor + 2.0 * iLayerColor - 1)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmPinLight
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iLayerColor > .5 ? max(iResultColor, 2.0 * (iLayerColor - .5)) : min(iResultColor, 2.0 * iLayerColor))*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmHardMix
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+((iLayerColor > 1.0 - iResultColor) ? 1.0 : .0)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmDifference
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+abs(iResultColor - iLayerColor)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmExclusion
	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+(iResultColor + iLayerColor - 2.0 * iResultColor * iLayerColor)*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmHue
////////////
	float s1=Getcpow(iResultColor);
	vec4 A = toHCY(iLayerColor);	
	vec4 B1 = toHCY(iResultColor);
	
	if(A.y==0){
		A.z=B1.z;
	}else{
		A.y=B1.y;
		A.z=B1.z;
	}
	
	A = toRGB3(A);

	float mx=0;
	for(int i=0;i<3;i++)mx=max(mx,A[i]);
	if(mx>1.0)A.xyz =A.xyz/mx;


	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+A*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmSaturation
////////////
	vec4 A = toHCY(iLayerColor);	
	vec4 B1 = toHCY(iResultColor);
	if(B1.y!=0)A.x=B1.x;
	else A.y=0;
	A.z=B1.z;
	toRGB3(A);

	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+A*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmColor
	vec4 B1=iResultColor;
	vec4 A = toHCY(iLayerColor);	
	B1 = toHCY(B1);	
	A.z=B1.z;
	A = toRGB3(A);

	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+A*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmLightnrss

	vec4 B1=iResultColor;
	vec4 A = toHCY(iLayerColor);	
	B1 = toHCY(B1);
	if(B1.y!=0)A.x=B1.x;
	A.y=B1.y;
	A = toRGB3(A);

	vec4 oColor = iResultColor*(1.0-iLayerColorAlpha)+A*iLayerColorAlpha;
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmModulate2x
	vec4 oColor = saturate(iResultColor*(1.0-iLayerColorAlpha)+(iLayerColor*iResultColor*2)*iLayerColorAlpha);
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmAdd
	vec4 oColor = saturate(iResultColor*(1.0-iLayerColorAlpha)+(iResultColor+iLayerColor)*iLayerColorAlpha);
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	
#ifdef bmSubtract
	vec4 oColor = saturate(iResultColor*(1.0-iLayerColorAlpha)+(iResultColor-(vec4(1,1,1,1)-iLayerColor))*iLayerColorAlpha);
	oColor.w = saturate(iLayerColor.w+iResultColor.w);
#endif	


#ifdef bmReplace
	vec4 oColor = iLayerColor;
#endif	

	oColor.xyz = oColor.xyz *QCColorMultiply+vec3(QCColorOffset);

	iResultColorD = oColor;


	iLayerBytes.z = 1.0-((1.0-iLayerBytes.z) * RoughMod);
	iLayerBytes.z = iLayerBytes.z*GlossMod;

	iLayerBytes.x+=MetalBrightness*0.01;
	iLayerBytes.z+=SpecBrightness*0.01;

	iLayerBytes.x = iLayerBytes.x*QCBytesMultiply+QCBytesOffset;
	iLayerBytes.z = iLayerBytes.z*QCBytesMultiply2+QCBytesOffset2;

	iResultMaps[BYTES_TARGET1][BYTES_CNL1] = saturate(mix(iResultMaps[BYTES_TARGET1][BYTES_CNL1], iLayerBytes.x, iLayerBytes.w*MetalnessOpacity));
	iResultMaps[BYTES_TARGET2][BYTES_CNL2] = saturate(mix(iResultMaps[BYTES_TARGET2][BYTES_CNL2], iLayerBytes.z, iLayerBytes.w*SpecularMod));


#ifdef NODE_CODE
	ioPM = iResultMaps[0]; 
	ioPQ1 = iResultMaps[1];
	ioPQ2 = iResultMaps[2];
	ioPQ3 = iResultMaps[3];
	ioPQ4 = iResultMaps[4];
	ioPN = iResultMaps[5]; 
	
	ioReplaceAlpha = vec4(iReplaceAlpha);
	ioCavity = inCavity;//vec4(0.5,0.5,0.5,0.5);
	ioOcclusion = inAO.xxxx;//vec4(0.5,0.5,0.5,0.5);
	ioTime = vec4(TimeSeconds, TimeSeconds, TimeSeconds, TimeSeconds);
	ioMouse = vec4(0.0, 0.0, 0.0, 0.0);           
	ioUV = vec4(oTexCoord, 0,0);//meshPosition;
	ioFragCoord = meshPosition+vec4(134.231,251.731,244.533,0.0);
	ioPosition = meshPosition;
	ioNormal = meshNormal;
//	ioTSNormal = vec4(iResultMaps[5].xy, 1.0, 1.0);
	
//	ioAlbedoColor = iLayerColor.zyxw;
//	ioReflectionColor = iLayerColor.zyxw;
//	ioGloss = iLayerBytes.zzzz;
//	ioEmissive = vec4(0.0, 0.0, 0.0, 0.0);
//	ioOpacity = iLayerColor.wwww;
//	ioMetal = iLayerBytes.xxxx;
	ioDisplacement = v*50.0;

	ioLightDir = vec4One;
	ioCameraPosition = vec4One;
	ioIteration = vec4One;

	NODE_CODE;

//	iResultMaps[5].xy = ioTSNormal.xy;

//	iLayerColor = ioAlbedoColor.zyxw;
//	iLayerColor.w = ioOpacity.w;
	
//	iLayerBytes = vec4(ioMetal.w, iLayerBytes.y, ioGloss.w, NGMask.w);
	iLayerBytes.w = NGMask.x;

	iReplaceAlpha = ioReplaceAlpha.w;
	iResultMaps[0] = mix(iResultMapsS[0], ioPM, NGMask); 
	iResultMaps[1] = mix(iResultMapsS[1], ioPQ1, NGMask);
	iResultMaps[2] = mix(iResultMapsS[2], ioPQ2, NGMask);
	iResultMaps[3] = mix(iResultMapsS[3], ioPQ3, NGMask);
	iResultMaps[4] = mix(iResultMapsS[4], ioPQ4, NGMask);
	iResultMaps[5] = mix(iResultMapsS[5], ioPN, NGMask);
	//iResultMaps[0].w = ioPM.w;
	v =  mix(v, ioDisplacement*0.02, NGMask.w);
	
#endif


	iResultMaps[0].w = mix(saturate(iResultMaps[0].w+iResultMapsS[0].w), iResultMaps[0].w, NGMask.w*iReplaceAlpha);


	v = mix(iResultFloat.x+v*DepthTransparency, LayerHeight*iLayerColorAlpha*0.01+v*DepthTransparency, ReplaceDepth);

	
	iResultFloat = vec4(v, v, v, v);//SaveFloatTo3Bytes(v);//*256.0f);

	/*
#ifdef MakeSpecular
	iLayerColor = vec4(Specular, Specular, Specular, iLayerColorAlpha);//*iLayerBytes.y;
#endif
	*/

#if COLOR_TARGET == 0
	iResultMaps[2].xyz = mix(iResultMaps[2].xyz, vec3(saturate(SpecularIntensity)), iLayerColorAlpha);
#endif	
//	oColor.xyz = oColor.xyz;//pow(oColor.xyz,vec3(0.454545,0.454545,0.454545));
//	FragColor = oColor;
//	iResultColor = oColor;
//	iResultColor.x = 1.0;
//	iResultColor.y = 0.0;

#if COLOR_TARGET == 5
//	iResultMaps[5].x = iResultMaps[5].x; 
//	iResultMaps[5].y = iResultMaps[5].y; 
	iResultMaps[5].zw =  iResultColorBuf.zw;
#endif

	FragData[0] = iResultMaps[0]; //int MTextureID;  // [freeze]Albedo <-> Emissive RGB, Alpha -- IOR/clear coat
	FragData[1] = iResultMaps[1]; //int Q1TextureID; // Reflection Rainbow <-> anisotropy, freeze, clearcoat roughness, volume -- microprotrusions roughness
	FragData[2] = iResultMaps[2]; //int Q2TextureID; // Specular Color RGB <-> Emissive Color), Refraction&Translu blur -- Specular edge power
	FragData[3] = iResultMaps[3]; //int Q3TextureID; // RGB Trans(SSS)/Refraction <-> coat edge color, sss (w/o specular normal) -> sss (w/o diff normal) -> Refraction Rainbow 
	FragData[4] = iResultMaps[4]; //int Q4TextureID; // RGB microprotrusions <-> specular edge color, clearCoat edge power -- microprotrusions (with edge power) & volume pow
	FragData[5] = iResultMaps[5]; //int NTextureID;  // normalX/direction Rainbow&anisotropy, normalY/direction Rainbow&anisotropy, Refract - translucence - Metall, Velvet(microprotrusions with tint) -- gloss
	FragData[6] = iResultMaps[6]; //int DTextureID;  // Depth32
	
	
	
}

