# 
# The Paint room toolset definition.
# 
# Insert commands and conditions within the main(){...} function
# use 
#   tools_item("IdentifierOfTheTool");
# to add new item into the toolset.
# use 
#   tools_section("Section name");
# to add tools section.
# The command
#   default_tool("IdentifierOfTheTool");
# defines the tool used by default in the room.
#

import coat
from cTemplates.Structs import *

@d_template
def PaintTools():
   coat.PureIconic()
   coat.tools_section("Paint")
   coat.tools_item("[StdPen]StdPen")
   coat.tools_item("[Pencil]Pencil")
   coat.tools_item("[Airbrush]Airbrush")
   coat.tools_item("[ChangeColor]ChangeColor")
   coat.tools_item("[ChangeHeight]ChangeHeight")
   coat.tools_item("[SmudgeTool]SmudgeTool")
   coat.tools_item("[POWRELAX]POWRELAX")
   coat.tools_item("[CloneTool]CloneTool")
   coat.tools_item("[RectTransformTool]RectTransformTool")
   coat.tools_item("[CopyPaste]CopyPaste")
   coat.tools_item("[CurveTool]CurveTool")
   coat.tools_item("[TextTool]TextTool")
   coat.tools_item("[PictTool]PictTool")
   coat.tools_item("[EraserTool]EraserTool")
   coat.tools_item("[CutFace]CutFace")
   coat.tools_item("[FreezeTool]FreezeTool")
   coat.tools_item("[FillTool]FillTool")
   coat.tools_item("[MagicWand]MagicWand")
   coat.tools_item("[PickTool]PickTool")
   coat.tools_item("[PlaneTool]PlaneTool")
   coat.tools_item("[MeasureTool]MeasureTool")
   coat.tools_item("[TopoSymmTool]TopoSymmTool")
   if(coat.is_ptex()): coat.tools_item("PTEX_RES") # /Ptex res+
   coat.default_tool("[StdPen]StdPen")
   PaintTools.IncludeContent()

@d_tools_section("Tweak/Sculpt", PaintTools)
def TweakSculpt():
   coat.tools_item("[SculptTool]{1}SCULPT_DRAG") # Move
   coat.tools_item("[SculptTool]{1}SCULPT_SELTRANSFORM") # Select/Transform
   coat.tools_item("[SculptTool]{1}SCULPT_DRAW") # Draw
   coat.tools_item("[SculptTool]{1}SCULP_COLLAPSE") # Collapse
   coat.tools_item("[SculptTool]{1}SCULP_EXPAND") # Expand
   coat.tools_item("[SculptTool]{1}SCULP_FOLLOW") # Shift
   coat.tools_item("[SculptTool]{1}SCULP_FOLLOW_TANGENT") # Smudge
   coat.tools_item("[SculptTool]{1}SCULP_PLANE") # Flatten
   coat.tools_item("[SculptTool]{1}SCULP_SMOOTH") # Smooth
   coat.default_tool("[SculptTool]{1}SCULPT_DRAW")


