import coat
import cPy.cCore
import os
import sys
import time


call_id: int = 0

_action_list = list()

class cTemplate(cPy.cCore.cAction):
    def __init__(self):
        cPy.cCore.cAction.__init__(self)
        self.if_has_Enabled_content = False
        self.is_first = False
        self.Enabled = True
        self.child: cTemplate = None
        self.Before: list[cTemplate] = list()
        self.After:  list[cTemplate] = list()
        self.Content: list[cTemplate] = list()
        self.Implementation =  lambda: self.IncludeContent()
        self.last_call_id: int = -1
        self.call_count: int = 0

        global _action_list
        _action_list.append(self)
        self._action_idx = len(_action_list)-1

    def UICmd(self):
        return "python:ExecActionByIdx("+str(self._action_idx)+")#"+self.Implementation.__name__

    def __str__(self):
        return self.UICmd()

    def RunBeforeList(self):
        for act in self.Before:
            if act.Enabled:
                act()

        for act in self.Content:
            act.RunBeforeList()

    def Run(self, run_before_list = True):
        global call_id
        if not self.Enabled: 
            return

        if run_before_list:
            call_id += 1
            self.RunBeforeList()

        if self.if_has_Enabled_content and not self.HasEnabledContent():
            return False

        self.Implementation()

        for act in self.After:
            act()

        return True
    
    def IncludeContent(self):
        global call_id
        result: bool = False
        first: bool = True        
        if call_id != self.last_call_id:
            self.call_count = 0
            self.last_call_id = call_id
        self.call_count += 1
        if self.call_count < 10:
            for act in self.Content:
                if act != None: 
                    act.is_first = first
                    if act.Run(False):
                        result = True
                        first = False
        return result

    def __call__(self):
        global call_id
        call_id += 1
        self.Run()

    def HasEnabledContent(self):
        for act in self.Content:
            if act.Enabled and act.HasEnabledContent():
                return True
            if not act.if_has_Enabled_content and act.Enabled:
                return True

        return False

def d_class(cls_to_decorate):
    """
    Register base class types
    """
    def get_class_name(self):
        return cls_to_decorate.__name__

    def new_element(self):
        X = self.__class__()
        X.SetParents()
        return X

    setattr(cls_to_decorate, 'get_class_name', get_class_name)
    setattr(cls_to_decorate, 'new_element', new_element)
    try:
        instance_for_reg = cls_to_decorate()
        cPy.cCore.cREG.reg_class(instance_for_reg)
    except Exception as e:
        print(f"[@d_class]: !!! CALSS REG ERROR {cls_to_decorate.__name__}: {e}")

    return cls_to_decorate

def d_slot(func):
    n_action = cTemplate()
    n_action.Implementation = func
    return n_action

def d_template(func):
    n_action = cTemplate()
    n_action.Implementation = func
    return n_action

def d_child(parent: cTemplate = None):
    def cChildActionD(func):
        n_action = cTemplate()
        n_action.Implementation = func
        if parent != None:
            parent.Content.append(n_action)
        return n_action
    return cChildActionD

#### Tools Section


def new_tools_section(section_name, n_action: cTemplate):
    coat.tools_section(section_name)
    n_action.IncludeContent()

class ToolsSection(cTemplate):
    def __init__(self, section_name = None, parent: cTemplate = None):
        if section_name != None:
            cTemplate.__init__(self)
            self.Implementation =  lambda: new_tools_section(section_name, self)
            self.if_has_Enabled_content = True
        if parent != None:
            parent.Content.append(self)

def d_tools_section(section_name: str, parent: cTemplate = None):
    def cToolsSectionD(func):
        n_action = cTemplate()
        n_action.Implementation =  lambda: new_tools_section(section_name, n_action)
        n_action.if_has_Enabled_content = True
        n_action.child = cTemplate()
        n_action.child.Implementation = func
        n_action.Content.append(n_action.child)
        if parent != None:
            parent.Content.append(n_action)
        return n_action
    return cToolsSectionD


#### Main menu

def new_main_menu(submenu_name, n_action: cTemplate):
    coat.start_main_menu(submenu_name)
    n_action.IncludeContent()

class MainMenu(cTemplate):
    def __init__(self, menu_name = None, parent: cTemplate = None):
        cTemplate.__init__(self)
        if menu_name != None:
            self.Implementation =  lambda: new_main_menu(menu_name, self)
            self.if_has_Enabled_content = True
        if parent != None:
            parent.Content.append(self)

def d_main_menu(menu_name: str, parent: cTemplate = None):
    def cToolsSectionD(func):
        n_action = MainMenu(menu_name)
        n_action.child = cTemplate()
        n_action.child.Implementation = func
        n_action.Content.append(n_action.child)
        if parent != None:
            parent.Content.append(n_action)
        return n_action
    return cToolsSectionD


#### Submenu

def new_submenu(menu_name, n_action: cTemplate):
    coat.menu_submenu(menu_name)
    n_action.IncludeContent()
    coat.menu_exit()

class Submenu(cTemplate):
    def __init__(self, submenu_name = None, parent: cTemplate = None):
        cTemplate.__init__(self)
        if submenu_name != None:
            self.Implementation =  lambda: new_submenu(submenu_name, self)
            self.if_has_Enabled_content = True
        if parent != None:
            parent.Content.append(self)


def d_submenu(submenu_name: str, parent: cTemplate = None):
    def cToolsSectionD(func):
        n_action = Submenu(submenu_name)
        n_action.child = cTemplate()
        n_action.child.Implementation = func
        n_action.Content.append(n_action.child)
        if parent != None:
            parent.Content.append(n_action)
        return n_action
    return cToolsSectionD

#### Submenu

def new_rmb_menu(n_action: cTemplate):
    coat.start_rmb_panel()
    n_action.IncludeContent()
    coat.show_rmb_panel()

class RMBMenu(cTemplate):
    def __init__(self, parent: cTemplate = None):
        cTemplate.__init__(self)
        self.Implementation = lambda: new_rmb_menu(self)
        self.if_has_Enabled_content = True
        if parent != None:
            parent.Content.append(self)


def d_rmb_menu(func):
        n_action = RMBMenu()
        n_action.child = cTemplate()
        n_action.child.Implementation = func
        n_action.Content.append(n_action.child)
        return n_action

#### Menu Section

def new_menu_section(n_action: cTemplate):
    # if n_action.is_first:
    coat.menu_separator()
    n_action.IncludeContent()

class MenuSection(cTemplate):
    def __init__(self, parent: cTemplate = None):
        cTemplate.__init__(self)
        self.Implementation =  lambda: new_menu_section(self)
        self.if_has_Enabled_content = True
        if parent != None:
            parent.Content.append(self)

def d_menu_section(Menu: cTemplate = None):
    def cToolsSectionD(func):
        n_action = MenuSection()
        n_action.child = cTemplate()
        n_action.child.Implementation = func
        n_action.Content.append(n_action.child)
        if Menu != None:
            Menu.Content.append(n_action)
        return n_action
    return cToolsSectionD




