import coat
from cTemplates.Structs import *

CreateEditMenu = MainMenu("COMMANDS")

@d_menu_section(CreateEditMenu)
def S_Undo():
   coat.menu_item("UNDO") # Undo
   coat.menu_hotkey("Z", 0, 1, 0) # CTRL+Z
   coat.menu_item("REDO") # Redo
   coat.menu_hotkey("Y", 0, 1, 0) # CTRL+Y
   coat.menu_separator()

@d_submenu("GIZMOLESS", CreateEditMenu)
def GIZMOLESS():
       coat.menu_item("TRANSFORM_TRANSLATE_SNAP")
       coat.menu_item("TRANSFORM_TRANSLATE_FREE")
       coat.menu_item("TRANSFORM_TRANSLATE_X")
       coat.menu_item("TRANSFORM_TRANSLATE_Y")
       coat.menu_item("TRANSFORM_TRANSLATE_Z")
       coat.menu_separator()
       coat.menu_item("TRANSFORM_SCALE_FREE")
       coat.menu_item("TRANSFORM_SCALE_X")
       coat.menu_item("TRANSFORM_SCALE_Y")
       coat.menu_item("TRANSFORM_SCALE_Z")
       coat.menu_separator()
       coat.menu_item("TRANSFORM_ROTATE_FREE")
       coat.menu_item("TRANSFORM_ROTATE_X")
       coat.menu_item("TRANSFORM_ROTATE_Y")
       coat.menu_item("TRANSFORM_ROTATE_Z")
       coat.menu_separator()
       coat.menu_item("StartObjTransform3D")
       coat.menu_hotkey("N", 0, 0, 0)
 
@d_menu_section(CreateEditMenu)
def S_DefineScaleCorrespondence():
   coat.menu_item("DefineScaleCorrespondence") # Edit Scene Scale

@d_menu_section(CreateEditMenu)
def S_UVOverlapping():
   if coat.IsInRoom("UV") or coat.IsInRoom("Modeling"):
            coat.menu_item("CheckUVOverlapping") # Overlapper UV Map
            coat.menu_hotkey(">", 0, 1, 0) # CTRL+>
            coat.menu_item("UncheckUVOverlapping") # Overlapper UV Map
            coat.menu_hotkey("<", 0, 1, 0) # CTRL+<
            coat.menu_separator()
 
@d_menu_section(CreateEditMenu)
def S_CalculateMaps():
   coat.menu_item("OCCLUSION_TOOL") # Calculate Occlusion
   coat.menu_item("CAVITY_TOOL") # Calculate Curvature
   coat.menu_item("LIGHTBAKING_TOOL") # Light Baking Tool

@d_menu_section(CreateEditMenu)
def S_Edit():
   if not coat.is_new_scene():
        # menu_item("PSProjectionCommands");/PSProjectionCommands
        coat.menu_item("EDIT_CURR_LAYER") # Sync Layer w/ Ext. Editor
        coat.menu_item("EDIT_ALL_LAYERS") # Edit All Layers in Ext. Editor
        coat.menu_item("EDIT_ALL_ROUGH_LAYERS") # Edit All Roughness Layers
        coat.menu_item("EDIT_ALL_METAL_LAYERS") # Edit All Metal Layers
        coat.menu_item("EDIT_PROJECTION") # Edit Projections in Ext. Editor
@d_menu_section(CreateEditMenu)
def S_Project():
   if not coat.is_new_scene():
        coat.menu_item("ProjectThrough") # Project Through
        coat.menu_item("Project_scale") # External Editor Projection Scale
 
@d_menu_section(CreateEditMenu)
def S_Options():
   coat.menu_item("LoadHotkeys") # Load Hotkeys
   coat.menu_item("SaveHotkeys") # Save Hotkeys
   coat.menu_item("CustomizeUI") # Customize UI
   coat.menu_item("OPTIONS") # Preferences
   coat.menu_item("ResetSettings") # Reset settings
   coat.menu_item("EditDataPlacement") # Relocate 3DCoat's data
   coat.menu_item("ConvertMaterials") # Convert Older Materials (pre 4.5)

@d_menu_section(CreateEditMenu)
def S_NodeGraph():
   coat.menu_item("NODEBAKING_TOOL") # Node Baking Tool

@d_menu_section(CreateEditMenu)
def S_Extension():
   coat.menu_insert_extensions("Edit")
