/*---------------------------------------------------*/
//Mission 6
//Purpose: Create the new layer and add primitive.
//File: Primitives.as
/*---------------------------------------------------*/
Debug     dbg;
DebugLog  log = dbg.log();
string orange_Color = "4292730333";
string mission_Abort = "Mission_Abort";
string mission_Done = "Well_Done";


void GoToStartMission() {
	cmd("$SETPAGE_Sculpt");
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
}

 void main() {
  UI  ui;
  SculptRoom  room;
  SculptLayer sl;
	
  string mission_Explain = "Primitive_Explain";
   
  ui.enableWindow("STARTMENU", false);
  room.clear();

  cmd ("$SETPAGE_Sculpt");
  cmd ("$StopEditCurves");

  
  int FontID = GetFontFileID("Fira_Sans_Condensed_16");
  
  int X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int Y0 = 8 * GetWorkAreaHeight() / 100;
  
  cmd ("$SCULP_PRIM");
  
  SetFloatingMessageBox(X0, Y0, mission_Explain,orange_Color,1);
  int istatus = 1;
  bool noExit = true;
  
  while(noExit) {
	Step(1);
	
	float X = GetMouseX();
	float Y = GetMouseY();
	if(LMBPressed()){
		istatus = ScriptMessagePressButton(X,Y);
		if (istatus == 0) { noExit = false; } //abort
	}
	if (IsPressKeyID(0x0D)) {
        noExit = false;
		istatus = 1;
	}	
  }
  SetScriptMessage("reset","");
    
  if (istatus==1) {
	noExit = true;
  } else {
	int XC = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YC = GetWorkAreaHeight() / 2;
	SetFloatingMessage(XC, YC, mission_Abort, orange_Color);
	log += "abort";
	Wait( 3000 );
	SetScriptMessage("reset","");
	SetShowModalDlg(false);
    GoToStartMission();
    SetShowModalDlg(true);
    return;
  }
  
  sl.rename("Sphere");
  sl.select("Sphere").toSurface();
  
  cmd ("$VoxelSculptTool::prm_SpherePrim");
  cmd ("$PENOP0");
  
  UI uii;
		
  int bret = 0;
  bool bEditBox = false;
  string prims = "$VoxelSculptTool::prm_SpherePrim;$VoxelSculptTool::prm_CubPrim;$VoxelSculptTool::prm_EllipsePrim;$VoxelSculptTool::prm_CylinderPrim;$VoxelSculptTool::prm_ConePrim;$VoxelSculptTool::prm_CapsulePrim;$VoxelSculptTool::prm_TubePrim;$VoxelSculptTool::prm_NGonPrim;$VoxelSculptTool::prm_GearPrim;$VoxelSculptTool::prm_LathePrim";
  cmd("$VoxTreeBtn6");
  while (noExit) {
	Step( 1 ); //Rendering cycle
	if (istatus == 0 || istatus == 5) { noExit = false; break; }
	if (istatus == 1) {
		istatus = WaitWhileNoExecuteCommand("$VoxelSculptTool::prm_CubPrim",CommandMessage(X0,Y0,"HL_Button_Select_Prim",0)); 
		if (istatus == 3) { 
			bret |= 0x1;
			Wait( 100 );
			SetEditBoxValue("$CubPrim::[76]#%$sa",200.0);
			SetEditBoxValue("$CubPrim::[76]#%$sb",200.0);
			SetEditBoxValue("$CubPrim::[76]#%$sc",200.0);
			SetSliderValue("$CubPrim::DetailsLevel[76]",0.1);
			Step( 1 );
			Wait( 100 );
			istatus = WaitWhileNoExecuteCommand("$PrimitivesTool::Apply[76]",CommandMessage(X0,Y0,"HL_Button_Apply_Prim",1));
			if (istatus == 3) { bret |= 0x2; istatus = 4; }
		}
	}
	if (istatus == 2 || istatus == 3) istatus = 4;  
    if (istatus == 4) istatus = WaitWhileNoExecuteCommand("$VoxelSculptTool::prm_EllipsePrim",CommandMessage(X0,Y0,"HL_Button_Select_Prim",1));
	if (istatus == 3) {
		Wait( 1000 );
		SetEditBoxValue("$EllipsePrim::[76]#%$sa",100.0);
		SetEditBoxValue("$EllipsePrim::[76]#%$sb",200.0);
		SetEditBoxValue("$EllipsePrim::[76]#%$sc",100.0);
		SetSliderValue("$EllipsePrim::DetailsLevel[76]",0.1);
		Step( 1 );
		Wait( 100 );
		istatus = WaitWhileNoExecuteCommand("$PrimitivesTool::Apply[76]",CommandMessage(X0,Y0,"HL_Button_Apply_Prim",1));
		if (istatus == 3) { bret |= 0x4; }
	}
	if (istatus == 1) istatus = 1;
	else {
		if (istatus == 2 || istatus == 3) istatus = WaitWhileNoExecuteCommand("$VoxelSculptTool::prm_WasherPrim",CommandMessage(X0,Y0,"HL_Button_Select_Prim",1));
		if (istatus == 3) {
			Wait( 1000 );
			SetSliderValue("$WasherPrim::InnerDiameter[76]",250.0);
			SetSliderValue("$WasherPrim::OuterDiameter[76]",400.0);
			SetSliderValue("$WasherPrim::Thickness[76]",40.0);
			SetSliderValue("$WasherPrim::DetailsLevel[76]",0.1);
			Step( 1 );
			Wait( 100 );
			istatus = WaitWhileNoExecuteCommand("$PrimitivesTool::Apply[76]",CommandMessage(X0,Y0,"HL_Button_Apply_Prim",1));
			if (istatus == 3) { bret |= 0x8; istatus = 5; }
		}
		if (istatus == 2) istatus = 5;
	}
  }
  if (istatus!=0 && ((bret&0x0f)==0x0f)) {
	  cmd("$[Page4]Draw");
	  cmd("$PENOP0");
	  istatus = LBMObject();
  }
  
  int Y = GetWorkAreaHeight() / 2;
  int X = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  
  if(istatus!=0){
    cmd("$[Page4]Grow");
   	if ( (bret&0x0f)!=0x0f ) 
		SetFloatingMessageBoxTime(X, Y,"Mission_Not_Complete",orange_Color,0,5000);
	else 
		SetFloatingMessageBoxTime(X, Y, mission_Done, orange_Color,0,5000);
	log += "End Mission";
  } else {
	SetFloatingMessage(X, Y, mission_Abort,orange_Color);
	Wait( 3000 );
	SetScriptMessage("reset","");
  }
  
  SetShowModalDlg(false);
  GoToStartMission();
  SetShowModalDlg(true);
 }

 // Left mouse
int LBMObject() {

    bool bFirst = true;
    bool noExit = true;
	int iret = 1;
	float xStart;
    float yStart;
    string explain = "Primitive_Show_Result";
    
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	
	SetFloatingMessageBox(XX, YY, explain, orange_Color,3);
	log += "\n start while noExit";
    while(noExit) {
        Step( 10 ); //Rendering cycle
        float X = GetMouseX();
        float Y = GetMouseY();
	    log += "  X Y " + X + " " + Y;
		bool bAlt = Alt();
		bool bObj = true;
        if(LMBPressed()){
			int Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status == 0) { noExit = false; iret = 0; }     //abort
			else if (Status == 2) { noExit = false; iret = 2; } //next
			if(bFirst){
                xStart=GetMouseX();
                yStart=GetMouseY();
			    log += "    bFirst xStart yStart " + xStart + " " + yStart;
                bFirst=false;
				bObj = ScreenRayPicksObject(xStart,yStart);
				log += "  bObj " + (bObj ? "true" : "false");
			}
		}
        while (LMBPressed() && noExit) { 
            Step( 10 ); //Rendering cycle
			float x=GetMouseX();
            float y=GetMouseY();
            log += "    x y " + x + " " + y;
			if ( (bObj && bAlt) || (!bObj)) {
				int dMotion = (bAlt)?200:300;
				if (abs(x-xStart) > dMotion) {
					SetScriptMessage("reset","");
					Wait( 2000 );
					noExit = false;
					break;
				}
			}
			bAlt = Alt();
	    } // while LMBPressed()
        log += "  stop while LMBPressed()";

        if (IsPressKeyID(0x1B)) {
            noExit = false;
	    }
        bFirst = true;
    } // while noExit
    log += "stop while noExit\n";

    SetScriptMessage("reset","");
    
    return iret;
}
 
 
string CommandMessage(int x, int y, string msg, int i ){
  string abort = GetTextID("ABORT");
  string cmd_MSG = "";
  cmd_MSG += x;
  cmd_MSG += ";";
  cmd_MSG += y;
  cmd_MSG += ";";
  cmd_MSG += GetTextID(msg);
  cmd_MSG += ";1";
  cmd_MSG += ";";
  cmd_MSG += orange_Color;
  cmd_MSG += ";0";
  if ( i == 1 || i == 2) {
	cmd_MSG += ";1,0,0,Textures//arrowback.png,0,";
	cmd_MSG += orange_Color;
	cmd_MSG += ",0";
  }	
  cmd_MSG += ";0,0,0,";
  cmd_MSG += abort;
  cmd_MSG += ",1,";
  cmd_MSG += orange_Color;
  cmd_MSG += ",0";
  if( i == 0 || i == 1) {
	cmd_MSG += ",0";
	cmd_MSG += ";2,0,0,Textures//arrowforward.png,2,";
	cmd_MSG += orange_Color;
	cmd_MSG += ",0";
  }
  return cmd_MSG; 
}



