/*----------------------------------------------------*/
// Mission 8
// Purpose: Layers (Delete/duplicate/clear operations)
// File: LayerOperations.as
/*-----------------------------------------------------*/
/*
1.Layers_Start
  Hello! Let's learn the layer operations.
  Hit Enter to start.
2.Layers_ShowHide
  This is the object. 
  It consist of several layers.
  Click on the highlighting icons to hide the layer.
3.Layers_GHost
  Let's learn switch to the ghost mode.
  Click on the highlighting icons one by one.
4.Layers_Hides
  Hide the all layers except the current.
  Press the layer eye by holding the 'Alt' key.
5.Layers_Edit
  Click twice on layer and rename.
6.Layers_Replace
  Replace the layers.
  Press the LM button on highlighted sign and drag and drop layer to any another.
7.Layers_Union
  Let's make union layers.
  Press the left mouse button + SHIFT button and move layers to any another by manipulator icon.
8.Layers_Copy
  Let's copy of the layer.
  Press the left mouse button + ALT button and move layers to any another by manipulator icon.
9.Layers_Subtract
  Let's subtract of the layer.
  Press the left mouse button + CTRL button and move layers to any another by manipulator icon.
10.Layers_Move
11.Layers_Surface
  Click the layer and switch to the surface mode and back.
*/

Debug     dbg;
DebugLog  log = dbg.log();

string layers_Start = "Layers_Start";
string layers_ShowHide = "Layers_ShowHide";
string layers_GHost = "Layers_GHost";

string mission_Complete = "Mission_Complete";
string mission_Abort = "Mission_Abort";
string orange_Color = "4292730333";

const int iABORT = 0;
const int iOK = 2;
const int iShow = 3;
const int iGhost = 4;
const int iHideAll = 5;
const int iEdit = 6;
const int iReplace = 7;
const int iUnion = 8;
const int iSubtract = 9;
const int iCopy = 10;
const int iMove = 11;
const int iSurface = 12;

string GetCommandMessage(string explainMessage, int i) {
	int X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int Y0 = 8 * GetWorkAreaHeight() / 100;
  
    string mission_Explain_HL = GetTextID(explainMessage);
	string abort = GetTextID("ABORT");
    
	string cmd_MSG = "";
	cmd_MSG += X0;
	cmd_MSG += ";";
	cmd_MSG += Y0;
	cmd_MSG += ";";
	cmd_MSG += mission_Explain_HL;
	cmd_MSG += ";1";
	cmd_MSG += ";";
	cmd_MSG += orange_Color;
	cmd_MSG += ";0";
	if ( (i & 1) == 1 ) {
		cmd_MSG += ";1,0,0,Textures//arrowback.png,0,";
		cmd_MSG += orange_Color;
		cmd_MSG += ",0";
	}		
	cmd_MSG += ";0,0,0,";
    cmd_MSG += abort;
	cmd_MSG += ",1,";
	cmd_MSG += orange_Color;
	cmd_MSG += ",0";
	if( (i & 2) ==  2) {
		cmd_MSG += ",0";
		cmd_MSG += ";2,0,0,Textures//arrowforward.png,2,";
		cmd_MSG += orange_Color;
		cmd_MSG += ",0";
    }
	return cmd_MSG;
}

void GoToStartMission() {
	SetShowModalDlg(false);
	cmd("$SETPAGE_Sculpt");
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
	SetShowModalDlg(true);
}


void main() {

    UI  ui;
	SculptLayer sl;
    SculptRoom  room;
	Vox vox;
	
	ui.enableWindow("STARTMENU", false);
	
    room.clear();
    bool noExit = true;    
	
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
  
	int FontID = GetFontFileID("Fira_Sans_Condensed_16");
  
    int X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
    int Y0 = 8 * GetWorkAreaHeight() / 100;
  
	ShowMessageWhilePressKey(XX,YY, layers_Start, orange_Color, 0x0D, "");
  
	open( "StartMenu\\files\\Generic_Bust_Male_Angular.3b" );
	
	cmd ("$SETPAGE_Sculpt");
	cmd ("$PENOP0");
	
	string S = "3.0,3.0,3.0,";
	
	SetVolumesScaling(S);
	
	int istate = iShow;
	
	int bret = 0;
	
	Wait( 1000 );
	
	while (noExit && (istate > 0)) {
		Step( 1 ); 	// Rendering cycle
		if (istate == 0 || istate == 2) { 
			noExit = false; 
			break; 
		}
		string cmd_MSG;
		if (istate == iShow) { // back
			cmd_MSG = GetCommandMessage(layers_ShowHide,2);
			istate = HighlightUIBoolTreeElements(1,2,cmd_MSG,1,"UIBoolPressed",true);
			if ( istate == iOK) { // ok!
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iGhost; // next
			}
		}
		if (istate == iGhost){
			cmd_MSG = GetCommandMessage(layers_GHost,3);
			istate = HighlightUIBoolTreeElements(3,2,cmd_MSG,1,"UIBoolPressed",true);
			if ( istate == iOK ) {
				SetFloatingMessage(X0,Y0,"Super",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iHideAll; //next
			}
			if (istate == 3) istate = iShow; // pred
			if (istate == 4) { Wait(200); istate = iHideAll; } //next
		}
		if(istate == iHideAll){
			istate = HideAllLayers();
			if ( istate == 3 ) {
				SetFloatingMessage(X0,Y0,"Super",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iEdit; //next
			} else {
				istate = (istate == 1)?iGhost:((istate == 2) ? iEdit : 0);
			}
		}
		if(istate == iEdit){
			istate = ChangeNameLayer();
			if( istate == 3) {
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iReplace;
			} else {
				istate = (istate == 1)?iHideAll:((istate == 2) ? iReplace : 0);
			}
		}
		if (istate == iReplace){
			istate = ReplaceNameLayer();
			if( istate == 3) {
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iUnion;
			} else {
				istate = (istate == 1)?iEdit:((istate == 2) ? iUnion : 0);
			}
		}
		if (istate == iUnion){
			istate = WasDragNDropVox(1);
			if (istate == 3){
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iSubtract;
			} else {
				istate = (istate == 1)?iReplace:((istate == 2) ? iSubtract : 0);
			}
		}
		if (istate == iSubtract){
			istate = WasDragNDropVox(2);
			if (istate == 3){
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iCopy;
			} else {
				istate = (istate == 1)?iUnion:((istate == 2) ? iCopy : 0);
			}
		}
		if (istate == iCopy){
			istate = WasDragNDropVox(3);
			if (istate == 3){
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iMove;
			} else {
				istate = (istate == 1)?iSubtract:((istate == 2) ? iMove : 0);
			}
		}
		if (istate == iMove){
			istate = MoveLayers();
			if (istate == 3){
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iSurface;
			} else {
				istate = (istate == 1)?iCopy:((istate == 2) ? iSurface : 0);
			}
		}
		if( istate == iSurface){
			istate = VoxSurfModes();
			if (istate == 3){
				SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
				Wait( 2000 );
				SetScriptMessage("reset","");
				istate = iOK;
			} else {
				istate = (istate == 1)?iMove:0;
			}
		}
	}
	if (istate == iOK) { 
		Wait( 500 );
		SetFloatingMessageBoxTime(X0, Y0, mission_Complete, orange_Color,0,3000);
		log += "End Mission";
	} else if (istate == iABORT) {
		SetFloatingMessage(X0,Y0,mission_Abort,orange_Color);
		Wait( 2000 );
		SetScriptMessage("reset","");
	}
	GoToStartMission();
}

int VoxSurfModes() {
	int Status = -1;
	
	int backContinue = 4;
	bool noExit = true;
	 
	float xStart = 0;
    float yStart = 0;
    
	string cmd_explain = "Layers_Surface";
    
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	
	SetFloatingMessageBox(XX, YY, cmd_explain, orange_Color,backContinue);
	
	int ilevel =  GetVolumesCount()/2;
	int ilevel1 = ilevel;
	
	bool bPressed = false;
	bool bVox = true;
	int nb = 0;
	while(noExit) {

		Step( 1 ); //Rendering cycle
     
		float X = GetMouseX();
        float Y = GetMouseY();
	 	
		int n = GetVolumesCount();
		if (n > 1) {
			ilevel = n/2;
			HighlightUIBoolTreeElement(2,ilevel,0.5);
		}
		if (LMBPressed()){ 
			bVox = !IsVoxSurfVolume(ilevel);
		}
			
		while(LMBPressed()){
			
			Step( 1 );
			
			Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status > -1 && Status < 3 ) {
				noExit = false; 
			}  //exit
			
			bPressed = true;
		}
		if ( bPressed ) {
			bool bVoxLevel = !IsVoxSurfVolume(ilevel);
			if(bVox!= bVoxLevel) { 
				nb++;
			}
				
			if (nb == 2) {
				Status = 3;
				noExit = false;
			}
			bPressed = false;
		}
	}
	SetScriptMessage("reset","");
	return Status;
}

int HideAllLayers() {
	
	int Status = -1;
	
	int backContinue = 4;
	bool noExit = true;
	 
	float xStart = 0;
    float yStart = 0;
    
	string cmd_explain = "Layers_Hides";
    
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	
	SetFloatingMessageBox(XX, YY, cmd_explain, orange_Color,backContinue);
	
	int ilevel =  GetVolumesCount()/2;
	int ilevel1 = ilevel;
	
	bool bPressed = false;
	bool bVox = true;
	bool isAlt = false;
	int nb = 0;
	while(noExit) {

		Step( 1 ); //Rendering cycle
     
		float X = GetMouseX();
        float Y = GetMouseY();
	 	
		int n = GetVolumesCount();
		if (n > 1) {
			ilevel = n/2;
			if(ilevel==0) ilevel = 1;
			HighlightUIBoolTreeElement(1,ilevel,0.1);
		}
		if (LMBPressed()){ 
			bVox = !IsVisibleVolume(ilevel-1);
		} 
		
		while(LMBPressed()){
			
			Step( 1 );
			
			Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status > -1 && Status < 3 ) {
				noExit = false; 
			}  //exit
			
			bPressed = true;
		}
	    isAlt = Alt(); // alt
		
		if ( bPressed && isAlt ) {
			bool bVoxLevel = !IsVisibleVolume(ilevel-1);
			if(bVox!= bVoxLevel) { 
				nb++;
			}
			if (nb == 1) {
				Status = 3;
				noExit = false;
			}
			bPressed = false;
		}
	}
	SetScriptMessage("reset","");
	return Status;
}

int MoveLayers(){
	Vox vox;
	
	int backContinue = 4;
	bool noExit = true;
	 
	float xStart = 0;
    float yStart = 0;
    
	string cmd_explain = "Layers_Move";
    
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	int Status = -1;
	
	SetFloatingMessageBox(XX, YY, cmd_explain, orange_Color,backContinue);
	
	string curr_name = GetCurVolume();
	int ilevel =  GetVolumeLevel(curr_name);
	
	bool bPressed = false;
	
	while(noExit) {

		Step( 1 ); //Rendering cycle
     
		float X = GetMouseX();
        float Y = GetMouseY();
	 	
		if (LMBPressed()){ 
			curr_name = GetCurVolume();	
			ilevel = GetVolumeLevel(curr_name);
		} 	
			
		while(LMBPressed()){
			
			Step( 1 );
			
			Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status > -1 && Status < 3 ) {
				noExit = false; 
			}  //exit
			
			bPressed = true;
		}
		if ( bPressed ) {
			bool dropWidget = WasDroppedUIElement();
			if ((ilevel !=-1) && dropWidget)
			{ 
				string curr_name2 = GetCurVolume();	
				int icurrent = GetVolumeLevel(curr_name2);
				if((curr_name2 == curr_name) && (icurrent!=ilevel)){
					noExit = false; 
					Status = 3;
				}
			}
			bPressed = false;
		}
	}
	SetScriptMessage("reset","");
	return Status;
}

int WasDragNDropVox(int dragMode) {
	
	string explain;
	int backContinue = 4;
	
	int  n = 0;
	int  retCode = -1;
	bool wasMoved = false;
	
	bool dup = false;
	bool summ = false;
    bool sub = false;
	bool noExit = true;
	string cmd_Explain;
	
	if	(dragMode == 1) cmd_Explain = "Layers_Union";
	else if (dragMode == 2) cmd_Explain = "Layers_Subtract";
	else if (dragMode == 3) cmd_Explain = "Layers_Copy";
	else return -1; // error!
	
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	
	SetFloatingMessageBox(XX, YY, cmd_Explain, orange_Color, backContinue);
	
	while (noExit) {
		Step(1); //Rendering cycle
		n = GetVolumesCount();	
		wasMoved = false;
		while (LMBPressed()) {
			Step(1);
			
			dup = IsPressKeyID(0x12); // alt
			summ = IsPressKeyID(0x10);//shft
			sub = IsPressKeyID(0x11);//ctrl
			
			float X = GetMouseX();
			float Y = GetMouseY();
			retCode = ScriptMessagePressButton(X, Y);
			if (retCode >= 0) noExit = false;
			wasMoved = true;
		}
		if (wasMoved) {
			int n1 = GetVolumesCount();
			bool isDoneOp = (n!=n1);
			bool dropWidget = WasDroppedUIElement();
			if (dropWidget && isDoneOp) {
				if (((dragMode == 1) && summ) ||
					((dragMode == 2) && sub) ||
					((dragMode == 3) && dup)) {
					noExit = false;
					retCode = 3;
				}
			}
		}
	}
	SetScriptMessage("reset", "");
	return retCode;
}


int ChangeNameLayer(){
	Vox vox;
	
	int backContinue = 4;
	bool noExit = true;
	 
	float xStart = 0;
    float yStart = 0;
    
	string cmd_explain = "Layers_Edit";
    
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	int Status = -1;
	
	SetFloatingMessageBox(XX, YY, cmd_explain, orange_Color,backContinue);
	
	int nv = GetVolumesCount();
	
	int bret = 0;
	array<string> aNames;
	string Names;
	Names = vox.names();
	GetArrayNames(aNames,Names);
	
	string curr_name = aNames[aNames.length()-1];
	SetCurVolume(curr_name);
	
	
	curr_name = GetCurVolume();
    int idx =  FindCurVolumeIndex();
	
	log += curr_name;
	string highlightedID = "$VoxTreeBranch::Root[";
	highlightedID += (idx-1);
	highlightedID += "]";
	highlightedID += "[0]";
	while(noExit) {

		Step( 1 ); //Rendering cycle
     
		float X = GetMouseX();
        float Y = GetMouseY();
		
		HighlightUIElement(highlightedID,1);	 	
		
		while(LMBPressed() || IsDoubleClick(true)){
			
			Step( 1 );
			
			Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status > -1 && Status < 3 ) {
				noExit = false; 
			}  //exit
			
			curr_name = GetCurVolume();	
			// find curr index in tree 
			idx = FindCurVolumeIndex();
		}
		// undo / redo
		bool CTRL = IsPressKeyID(0x11);
		bool ZKEY = IsPressKeyID(0x7A);
		if(CTRL){ //+Z, +V 
			Wait( 500 );
			// find curr index in tree 
			idx = FindCurVolumeIndex();
			curr_name = GetCurVolume();	
		}

		if ((idx !=-1) )
		{ 
			if(IsChangeName(curr_name, idx)){
				noExit = false; 
				Status = 3;
			}
		}
	}
	SetScriptMessage("reset","");
	return Status;
}

int ReplaceNameLayer() {
	Vox vox;
	
	int backContinue = 4;
	bool noExit = true;
	 
	float xStart = 0;
    float yStart = 0;
    
	string cmd_explain = "Layers_Replace";
    
	int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
	int YY = 8 * GetWorkAreaHeight() / 100;
	int Status = -1;
	
	SetFloatingMessageBox(XX, YY, cmd_explain, orange_Color,backContinue);
	
	int idx =  FindCurVolumeIndex();
	string curr_name = GetCurVolume();
	
	bool bPressed = false;
	
	while(noExit) {

		Step( 1 ); //Rendering cycle
     
		float X = GetMouseX();
        float Y = GetMouseY();
	 	
		if (LMBPressed()){ 
			idx = FindCurVolumeIndex();
			curr_name = GetCurVolume();	
		} 	
			
		while(LMBPressed()){
			
			Step( 1 );
			
			Status = ScriptMessagePressButton(X,Y);
			// check status (<-,stop,->)
			if (Status > -1 && Status < 3 ) {
				noExit = false; 
			}  //exit
			
			bPressed = true;
		}
		if ( bPressed ) {
			bool dropWidget = WasDroppedUIElement();
			if ((idx !=-1) && dropWidget)
			{ 
				int icurrent = FindCurVolumeIndex();
				string curr_name2 = GetCurVolume();	
				if(idx != icurrent && (curr_name2 == curr_name)){
					noExit = false; 
					Status = 3;
				}
			}
			bPressed = false;
		}
	}
	SetScriptMessage("reset","");
	return Status;
}

void GetArrayNames(array<string> &a, string Names){
	uint i;
	for(i = 0; i < Names.length();i++) {
		int i1 = Names.findFirst(",",i);
		if (i1 != -1) { 
			a.insertLast(Names.substr(i,i1-i));
			i += (i1-i+1);
		} else break;
	}
	a.insertLast(Names.substr(i,Names.length()-i));
}
	
int FindIndexName(string s, array<string> &a ) {
	int ret = -1;
	for(uint i = 0; i < a.length();i++) {
	   if(s == (a[i])) { 
			ret = i; 
			break;
	   }
	}
	return ret;
}
