from cTemplates.Rooms import reg_main_menu

import coat
from cTemplates.Structs import *
import cTemplates.MainMenu.File as FileMenu
import cTemplates.MainMenu.Edit as EditMenu
import cTemplates.MainMenu.View as ViewMenu
import cTemplates.MainMenu.Textures as TexturesMenu
import cTemplates.MainMenu.Layers as LayersMenu
import cTemplates.MainMenu.Freeze as FreezeMenu
import cTemplates.MainMenu.Hide as HideMenu
import cTemplates.MainMenu.Windows as WindowsMenu
import cTemplates.MainMenu.Scripts as ScriptsMenu
import cTemplates.MainMenu.Capture as CaptureMenu
import cTemplates.MainMenu.Help as HelpMenu
import cTemplates.MainMenu.Debug as DebugMenu
import cTemplates.MainMenu.Curves as CurvesMenu
import cTemplates.MainMenu.Symmetry as SymmetryMenu
import cTemplates.menu

################
### File Manu
TexturaFileMenu = MainMenu("FILE")

TexturaFileMenu.Content.append(FileMenu.S_New)

@d_submenu("Install", TexturaFileMenu)
def Install():
       coat.menu_item("InstallExtension") # Install Extension
       coat.menu_item("InstallQuixelAssetAsMaterial") # Install Quixel asset as Smart Material

TexturaFileMenu.Content.append(FileMenu.S_CreateExtension)

TexturaFileMenu.Content.append(FileMenu.Browse)
TexturaFileMenu.Content.append(FileMenu.S_Save)


@d_submenu("Import", TexturaFileMenu)
def Import():
        coat.menu_item("ImportDPMesh") # {CY}Model for Per Pixel Painting
        coat.menu_separator()		
        coat.menu_item("OPENOBJ") # Model for Microvertex Painting
        coat.menu_hotkey("O", 1, 1, 0) # SHIFT+CTRL+O
        coat.menu_item("OPENOBJ_PTEX") # Model for PTEX
        coat.menu_separator()		
        if coat.is_ppp(): 
            coat.menu_separator()		
            coat.menu_item("ImportPositions") # Import Vertex Positions
            coat.menu_item("ReplaceGeometry") # Replace Geometry
            coat.menu_item("ImportLockedNormals")

TexturaFileMenu.Content.append(FileMenu.S_Export_PPP)

Export = Submenu("Export", TexturaFileMenu)
Export.Content.append(FileMenu.S_Export_MV)

TexturaFileMenu.Content.append(FileMenu.S_Exit)

TexturaFileMenu.Before.append(FileMenu.CheckRoom)

### File Menu        
##############
### Window Menu        

Popups = Submenu("Popups")
Popups.Content.append(WindowsMenu.Popups_S1)
Popups.Content.append(WindowsMenu.Popups_paint)
@d_menu_section(Popups)
def Popups_paint():
    coat.menu_item("Blending")
    coat.menu_item("Curves_Tree")
    coat.menu_item("CurvParamsPopup")
    coat.menu_item("Extensions")
    coat.menu_item("FPS_monitor")
    coat.menu_item("Layers")
    coat.menu_item("MASK")
    coat.menu_item("MATERIALS")
    coat.menu_item("Materials")
    coat.menu_item("MtlHistory")
    coat.menu_item("PALETTE")
    coat.menu_item("PanoramasList")
    coat.menu_item("Pen")
    coat.menu_item("PenOpt")
    coat.menu_item("Picker")
    coat.menu_item("PRESETS")
    coat.menu_item("Projector")
    coat.menu_item("Shapes")
    coat.menu_item("STRIPS")
    coat.menu_item("SUBOBJECTS")
    coat.menu_item("SYMMETRY")
    coat.menu_item("TOOL_PARAMO")

WindowsMenu.WindowsMenu.Content.insert(0, Popups)
WindowsMenu.Popups.Enabled = False

### Window Menu        
##############

@reg_main_menu
def PaintMainMenu():
    TexturaFileMenu()
    print("RegMainMenu")
    EditMenu.GIZMOLESS.Enabled = False
    EditMenu.S_NodeGraph.Enabled = False
    EditMenu.CreateEditMenu()

    ViewMenu.View_S_Print.Enabled = False
    ViewMenu.View_S_Show.Enabled = False
    ViewMenu.CreateViewMenu()

    if not coat.is_new_scene():
        SymmetryMenu.SymmetryMenu()
        TexturesMenu.TexturesMenu()
        LayersMenu.LayersMenu()
        FreezeMenu.FreezeMenu()
        HideMenu.HideMenu()


    CurvesMenu.CurvesMenu()

    WindowsMenu.WindowsMenu()

    ScriptsMenu.ScriptsMenu()
    CaptureMenu.CaptureMenu()
    HelpMenu.HelpMenu()
    if coat.IsDebug():
        DebugMenu.DebugMenu()

    coat.menu_item("PaintDependency")
    coat.menu_item("PickMethod")


cTemplates.menu.DefaultMenu.Implementation = PaintMainMenu.Implementation