/** \mainpage 3DCoat Core API introduction
 * The **Core API** is a powerful method to extend 3DCoat's functionality. You can automate the job or add principally new tools. This is not just the scripting,
 * the code you write runs at full speed of compiled C++. We use **Microsoft Visual Studio** for the compiling. But the whole process is entirely transparent for you.
 * You don't need to configure anything or manage complex project configurations. 3DCoat will lead you through the whole process with a simple wizard.
 * \section qstart Quickstart.
 * The core API requires **Visual Studio 2022 Community** with the C++ features installed. If you have not installed the Visual Studio, 
 * 3DCoat will help to install it with correct options.\n
 * The start is quite easy. Just use **Scripts->Create new Core API script**\n
 * \image html core_api_start.png
 * Choose the template and path for your project. Then 3DCoat will assist you in installing the Visual Studio if needed.\n
 * Each example is well documented and uses relatively simple syntax, so it is easy to understand from basic to complex.\n
 * There are several important notes you need to know:\n
 * 1) Always start your project from one of the examples. Even if you want to make everything from scratch, use **Scripts->Create new Core API script->Minimal c++ program** as your starting point. Don't create the project manually!\n
 * 2) Use \ref Debugging; it is very convenient; all 3DCoat native data types are shown in a user-friendly interface.\n
 * 3) Always follow the Visual Studio linter hints to write the correct code. Hover the data types and function names to access the documentation on-the-fly.\n
 * \image html linter.png
 * 4) Don't read the full documentation. It is impossible to remember. Follow the \ref Examples first. And then look at the documentation if you need some details.\n
 * 5) Look the C++ syntax, but don't read the whole manual, take the basics first - https://beginnersbook.com/2017/08/c-plus-plus-tutorial-for-beginners/\n
 * 6) Click on the item in the **Script** menu to execute. Use RMB click to get the useful set of commends - **edit**, **build**, **rebuild**. Yoy may also **create distributive** 
 * of your script to share with oher users.\n
 * \image html rmb_script.png
 * \section The API reference
 * Pay attention. The API uses the same set of classes as 3DCoat. For the uniform look of the code, some types referred to in this document were renamed. For example,
 * coat::vec3 is the same as cVec3. Please, use notation like coat::vec3 instead of cVec3 for 3d vectors (and similar for other vectors and matrices).\n \n
 * General I/O: coat::io\n
 * Dialog management: coat::dialog\n
 * Mesh operations: coat::Mesh\n
 * Scene roots: coat::Scene\n
 * Scene element: coat::SceneElement\n
 * Volume management: coat::Volume\n
 * UI management: coat::ui\n
 * 2D-vectors math: coat::vec2, look the cVec2 for details.\n
 * 3D-vectors math: coat::vec3, look the cVec3 for details.\n
 * 4D-vectors math: coat::vec4, look the cVec4 for details.\n
 * 3D-matrix math: coat::mat3, look the cMat3 for details.\n
 * 4D-matrix math: coat::mat4, look the cMat4 for details.\n
 * Symmetry management: coat::symm \n
 * array: coat::list, look the cList and \ref CoatArrays for details.\n
 * Class registration rules and principles: \ref ClassEngine \n
 * Vector operations: \ref CoatMath \n
 * Primitives: \ref CoreAPI_Primitives, coat::box, coat::sphere, coat::ellipse, coat::gear, coat::cylinder, coat::ngon, coat::tube, coat::spiral, coat::torus. 
 * \section CMakeLists Edit, auto-complete, correct hints
 * 3DCoat generates cmake Visual Studio project to simplify the coding. If the <a href="https://visualstudio.microsoft.com/vs/community/"><b>free Visual Studio Express 2022</b></a> installed,
 * the project will open automatically after the **Script->Create Core API script**. Of course, you should select the CPP file in the
 * Solution Explorer to edit the code. We generate the project only to be able to edit with auto-complete and see the
 * correct hints in the editor. Anyway, you can use **Build->Build All**
 * in the **Visual Studio** to check for the syntax errors.
 * \section Debugging
 * Use Visual Studio for the debugging. Use **Debug->Attach to process, 3DCoatGL64.exe**, then open your script in Visual Studio, and set the breakpoint.
 * Attach:\n
 * \image html attach.png
 * Select process:\n
 * \image html sel_coat_process.png
 * Set breakpoint:
 * \image html breakpoint.png
 *
  * As soon as the script is executed, the VS stops at the breakpoint. Ensure that there is the 3dcoat.natvis file in the project folder.
 * In this case, all the native 3DCoat types are shown correctly.\n
 * ***!!!*** Pay attention that if you ended the debug session and want to change the source file, you need to activate **Debug->Detach All**, otherwise 3DCoat will
 * not be able to compile the project because the .pdb file is locked by the Visual Studio. Detach, then change sources, then attach again, and run the
 * project using the **Scripts->click on the project filename**.
 * \image html detach.png
 * \section Examples
 * Looking the \ref RichExamples is the best way to understand the API. Use **Scripts->Create new Core API script** to experiment with that examples.
 * <div class="sample"><img src="minimal.png"><div>\link minimal.cpp \endlink<br>The minimal c++ program</div></div>
 * \subsection CoreAPI_cpp_basics C++ and CoreAPI basics
 * <div class="sample"><img src="HelloWorld.png"><div>\link HelloWorld.cpp \endlink<br>The simplest program - just show the Hello world!</div></div>
 * <div class="sample"><img src="Strings.png"><div>\link Strings.cpp \endlink<br>﻿ Simple strings manipulations</div></div>
 * <div class="sample"><img src="Arrays.png"><div>\link Arrays.cpp \endlink<br>﻿ Very basic arrays operations</div></div>
 * <div class="sample"><img src="Logging.png"><div>\link Logging.cpp \endlink<br>﻿ Output to the log file, writing to the text file</div></div>
 * <div class="sample"><img src="ui_command.png"><div>\link ui_command.cpp \endlink<br>This example demonstrates how to click any item in UI</div></div>
 * <div class="sample"><img src="dialogs.png"><div>\link dialogs.cpp \endlink<br>This example demonstrates the power of the dialogs and UI. It describes how to register the elements into the UI.</div></div>
 * \subsection CoreAPI_SculptTree SculptTree operations
 * <div class="sample"><img src="square_volume.png"><div>\link square_volume.cpp \endlink<br>Iterate over the sculpt tree, show the basic stats - square, volume</div></div>
 * \subsection CoreAPI_GenerateObjects Generate objects
 * <div class="sample"><img src="meshes.png"><div>\link meshes.cpp \endlink<br>Generate the voxel figure that consists of random spheres</div></div>
 * <div class="sample"><img src="meshes_surface_merge.png"><div>\link meshes_surface_merge.cpp \endlink<br>Generate the figure that consists of multiple spheres merged into the single surface object without booleans</div></div>
 * <div class="sample"><img src="metaballs.png"><div>\link metaballs.cpp \endlink<br>The metaballs example</div></div>
 * <div class="sample"><img src="GeneratorExample.png"><div>\link GeneratorExample.cpp \endlink<br>The basic generator example, just to demonstrate the principles of generators, look the \ref TreesGenerator.cpp for the more sophisticated example.</div></div>
 * <div class="sample"><img src="TreesGenerator.png"><div>\link TreesGenerator.cpp \endlink<br>The trees generator example</div></div>
 * \subsection CoreAPI_Primitives Construct scene using primitives
 * <div class="sample"><img src="csg_voxels.png"><div>\link csg_voxels.cpp \endlink<br>This example generates the detail for the further 3D printing using the voxels. The CSG principles demonstrated.</div></div>
 * <div class="sample"><img src="csg_surface.png"><div>\link csg_surface.cpp \endlink<br>This example generates the detail for the further 3D printing using the surface mode. The CSG principles demonstrated.</div></div>
 * <div class="sample"><img src="BrickWall.png"><div>\link BrickWall.cpp \endlink<br>Generate the surface figure "brick wall" that consists of boxes</div></div>
 * <div class="sample"><img src="capsule.png"><div>\link capsule.cpp \endlink<br>This example generates the surface figure that consists of capsule</div></div>
 * <div class="sample"><img src="ellipses.png"><div>\link ellipses.cpp \endlink<br>This example generates the surface figure that consists of ellipses</div></div>
 * <div class="sample"><img src="gear.png"><div>\link gear.cpp \endlink<br>This example generates the surface figure that consists of gear</div></div>
 * <div class="sample"><img src="HoneyComb.png"><div>\link HoneyComb.cpp \endlink<br>This example generates the surface figure that consists of honey combs (ngons)</div></div>
 * <div class="sample"><img src="OlympicRings.png"><div>\link OlympicRings.cpp \endlink<br>This example generates the surface figure "olimpic rings" that consists of toruses</div></div>
 * <div class="sample"><img src="RollingPin.png"><div>\link RollingPin.cpp \endlink<br>This example generates the surface figure rolling pin that consists of cylinders</div></div>
 * <div class="sample"><img src="spheres.png"><div>\link spheres.cpp \endlink<br>Generate the surface figure that consists of spheres</div></div>
 * <div class="sample"><img src="spiral.png"><div>\link spiral.cpp \endlink<br>This example generates the surface figure that consists of spiral</div></div>
 * <div class="sample"><img src="tube.png"><div>\link tube.cpp \endlink<br>This example generates the surface figure that consists of tube</div></div>
 * <div class="sample"><img src="WindRose.png"><div>\link WindRose.cpp \endlink<br>Generate the surface figure "windrose" that consists of cones</div></div>
 * <div class="sample"><img src="HelloWorld3D.png"><div>\link HelloWorld3D.cpp \endlink<br>Generate the text primitive</div></div>
 * <div class="sample"><img src="cup.png"><div>\link cup.cpp \endlink<br>Generate the surface figure "glass"</div></div>
 * <div class="sample"><img src="DoorStop.png"><div>\link DoorStop.cpp \endlink<br>This example generates the surface figure door stop that consists of half-sphere and cylinders</div></div>
 * <div class="sample"><img src="bolt_binary.png"><div>\link bolt_binary.cpp \endlink<br>This example generates the bolt composite (bolt head + thread stud)</div></div>
 * <div class="sample"><img src="bolt_rim.png"><div>\link bolt_rim.cpp \endlink<br>This example generates the bolt composite (rim head + round thread profile)</div></div>
 * <div class="sample"><img src="boltheads.png"><div>\link boltheads.cpp \endlink<br>This example generates the bolt heads (hexa,flat,lamb)</div></div>
 * <div class="sample"><img src="screw.png"><div>\link screw.cpp \endlink<br>This example generates the bolt composite (bolt head + thread stud)</div></div>
 * <div class="sample"><img src="thread.png"><div>\link thread.cpp \endlink<br>This example generates the surface figure that consists of thread</div></div>
 * <div class="sample"><img src="threadStud.png"><div>\link threadStud.cpp \endlink<br>This example generates the surface figure that consists of thread stud</div></div>
 * <div class="sample"><img src="washer.png"><div>\link washer.cpp \endlink<br>This example generates the washer primitives (flat,grover,quard)</div></div>
 * <div class="sample"><img src="nut.png"><div>\link nut.cpp \endlink<br>This example generates the nut primitive.</div></div>
 * <div class="sample"><img src="ffBlob.png"><div>\link ffBlob.cpp \endlink<br>This example generates the freeform primitive (blob)</div></div>
 * <div class="sample"><img src="ffCube.png"><div>\link ffCube.cpp \endlink<br>This example generates the freeform primitive (cube)</div></div>
 * <div class="sample"><img src="ffCylinder.png"><div>\link ffCylinder.cpp \endlink<br>This example generates the freeform primitive (cylinder)</div></div>
 * \subsection CoreAPI_Primitives Construct scene using primitives
 * <div class="sample"><img src="Dumbbell.png"><div>\link Dumbbell.cpp \endlink<br>This example generates the surface figure dumb-bell with usage of the debug mode</div></div>
 * <div class="sample"><img src="Logo3D.png"><div>\link Logo3D.cpp \endlink<br>This example generates the surface consist of logo 3D picture</div></div>
 * \subsection CoreAPI_Export Export
 */
/** \page RichExamples The Core API examples
 * Looking the \ref RichExamples is the best way to understand the API. Use **Scripts->Create new Core API script** to experiment with that examples.
 * <div class="sample"><img src="minimal.png"><div>\link minimal.cpp \endlink<br>The minimal c++ program</div></div>
 * \subsection CoreAPI_cpp_basics C++ and CoreAPI basics
 * <div class="sample"><img src="HelloWorld.png"><div>\link HelloWorld.cpp \endlink<br>The simplest program - just show the Hello world!</div></div>
 * <div class="sample"><img src="Strings.png"><div>\link Strings.cpp \endlink<br>﻿ Simple strings manipulations</div></div>
 * <div class="sample"><img src="Arrays.png"><div>\link Arrays.cpp \endlink<br>﻿ Very basic arrays operations</div></div>
 * <div class="sample"><img src="Logging.png"><div>\link Logging.cpp \endlink<br>﻿ Output to the log file, writing to the text file</div></div>
 * <div class="sample"><img src="ui_command.png"><div>\link ui_command.cpp \endlink<br>This example demonstrates how to click any item in UI</div></div>
 * <div class="sample"><img src="dialogs.png"><div>\link dialogs.cpp \endlink<br>This example demonstrates the power of the dialogs and UI. It describes how to register the elements into the UI.</div></div>
 * \subsection CoreAPI_SculptTree SculptTree operations
 * <div class="sample"><img src="square_volume.png"><div>\link square_volume.cpp \endlink<br>Iterate over the sculpt tree, show the basic stats - square, volume</div></div>
 * \subsection CoreAPI_GenerateObjects Generate objects
 * <div class="sample"><img src="meshes.png"><div>\link meshes.cpp \endlink<br>Generate the voxel figure that consists of random spheres</div></div>
 * <div class="sample"><img src="meshes_surface_merge.png"><div>\link meshes_surface_merge.cpp \endlink<br>Generate the figure that consists of multiple spheres merged into the single surface object without booleans</div></div>
 * <div class="sample"><img src="metaballs.png"><div>\link metaballs.cpp \endlink<br>The metaballs example</div></div>
 * <div class="sample"><img src="GeneratorExample.png"><div>\link GeneratorExample.cpp \endlink<br>The basic generator example, just to demonstrate the principles of generators, look the \ref TreesGenerator.cpp for the more sophisticated example.</div></div>
 * <div class="sample"><img src="TreesGenerator.png"><div>\link TreesGenerator.cpp \endlink<br>The trees generator example</div></div>
 * \subsection CoreAPI_Primitives Construct scene using primitives
 * <div class="sample"><img src="csg_voxels.png"><div>\link csg_voxels.cpp \endlink<br>This example generates the detail for the further 3D printing using the voxels. The CSG principles demonstrated.</div></div>
 * <div class="sample"><img src="csg_surface.png"><div>\link csg_surface.cpp \endlink<br>This example generates the detail for the further 3D printing using the surface mode. The CSG principles demonstrated.</div></div>
 * <div class="sample"><img src="BrickWall.png"><div>\link BrickWall.cpp \endlink<br>Generate the surface figure "brick wall" that consists of boxes</div></div>
 * <div class="sample"><img src="capsule.png"><div>\link capsule.cpp \endlink<br>This example generates the surface figure that consists of capsule</div></div>
 * <div class="sample"><img src="ellipses.png"><div>\link ellipses.cpp \endlink<br>This example generates the surface figure that consists of ellipses</div></div>
 * <div class="sample"><img src="gear.png"><div>\link gear.cpp \endlink<br>This example generates the surface figure that consists of gear</div></div>
 * <div class="sample"><img src="HoneyComb.png"><div>\link HoneyComb.cpp \endlink<br>This example generates the surface figure that consists of honey combs (ngons)</div></div>
 * <div class="sample"><img src="OlympicRings.png"><div>\link OlympicRings.cpp \endlink<br>This example generates the surface figure "olimpic rings" that consists of toruses</div></div>
 * <div class="sample"><img src="RollingPin.png"><div>\link RollingPin.cpp \endlink<br>This example generates the surface figure rolling pin that consists of cylinders</div></div>
 * <div class="sample"><img src="spheres.png"><div>\link spheres.cpp \endlink<br>Generate the surface figure that consists of spheres</div></div>
 * <div class="sample"><img src="spiral.png"><div>\link spiral.cpp \endlink<br>This example generates the surface figure that consists of spiral</div></div>
 * <div class="sample"><img src="tube.png"><div>\link tube.cpp \endlink<br>This example generates the surface figure that consists of tube</div></div>
 * <div class="sample"><img src="WindRose.png"><div>\link WindRose.cpp \endlink<br>Generate the surface figure "windrose" that consists of cones</div></div>
 * <div class="sample"><img src="HelloWorld3D.png"><div>\link HelloWorld3D.cpp \endlink<br>Generate the text primitive</div></div>
 * <div class="sample"><img src="cup.png"><div>\link cup.cpp \endlink<br>Generate the surface figure "glass"</div></div>
 * <div class="sample"><img src="DoorStop.png"><div>\link DoorStop.cpp \endlink<br>This example generates the surface figure door stop that consists of half-sphere and cylinders</div></div>
 * <div class="sample"><img src="bolt_binary.png"><div>\link bolt_binary.cpp \endlink<br>This example generates the bolt composite (bolt head + thread stud)</div></div>
 * <div class="sample"><img src="bolt_rim.png"><div>\link bolt_rim.cpp \endlink<br>This example generates the bolt composite (rim head + round thread profile)</div></div>
 * <div class="sample"><img src="boltheads.png"><div>\link boltheads.cpp \endlink<br>This example generates the bolt heads (hexa,flat,lamb)</div></div>
 * <div class="sample"><img src="screw.png"><div>\link screw.cpp \endlink<br>This example generates the bolt composite (bolt head + thread stud)</div></div>
 * <div class="sample"><img src="thread.png"><div>\link thread.cpp \endlink<br>This example generates the surface figure that consists of thread</div></div>
 * <div class="sample"><img src="threadStud.png"><div>\link threadStud.cpp \endlink<br>This example generates the surface figure that consists of thread stud</div></div>
 * <div class="sample"><img src="washer.png"><div>\link washer.cpp \endlink<br>This example generates the washer primitives (flat,grover,quard)</div></div>
 * <div class="sample"><img src="nut.png"><div>\link nut.cpp \endlink<br>This example generates the nut primitive.</div></div>
 * <div class="sample"><img src="ffBlob.png"><div>\link ffBlob.cpp \endlink<br>This example generates the freeform primitive (blob)</div></div>
 * <div class="sample"><img src="ffCube.png"><div>\link ffCube.cpp \endlink<br>This example generates the freeform primitive (cube)</div></div>
 * <div class="sample"><img src="ffCylinder.png"><div>\link ffCylinder.cpp \endlink<br>This example generates the freeform primitive (cylinder)</div></div>
 * \subsection CoreAPI_Primitives Construct scene using primitives
 * <div class="sample"><img src="Dumbbell.png"><div>\link Dumbbell.cpp \endlink<br>This example generates the surface figure dumb-bell with usage of the debug mode</div></div>
 * <div class="sample"><img src="Logo3D.png"><div>\link Logo3D.cpp \endlink<br>This example generates the surface consist of logo 3D picture</div></div>
 * \subsection CoreAPI_Export Export
 */

 /** \page CoatMath 3DCoat math/vectors operations
   * It is easy to operate over vectors/matrices within the 3DCoat API. Of course, look cVec2, cVec3, cVec4, cMat3, cMat4 references. In most cases, the operations are intuitive and semi-obvious.
   * There are several simple examples:\n
   * Vectors initialization:
   * \code
   *	coat::vec3 v(0,1,2); // define the 3d vector
   *	coat::vec3 z(0); // zero vector
   *	coat::vec3 x = coat::vec3::Zero; // other way to get zero vector
   *	coat::vec4 v4(1,2,3,4); // 4D vector
   *	coat::vec4 v41(x,1.0); // get 4D vector from the 3D vector, we insert the missing w component
   *	coat::vec3 v3 = v4.ToVec3(); // convert 4d vector to 3d, we just take x,y,z
   *	\endcode
   *	Vector operations examples:
   *	\code
   *	coat::vec3 c = coat::vec3::Cross(a,b); // cross-product
   *	float dp = a.dot(b); // dot-product
   *	dp = coat::vec3::Dot(a,b);// dot-product
   *	a.Normalize(); // normalization
   *	a = b.ToNormal(); // get normalized vector
   * \endcode
   * Usually, all transforms over the 3D vectors are performed using 4D matrices.
   * \code
   *	coat::mat4 m = comms::mat4::Scaling(3.0)*comms::mat4::Translation(1,2,3);// transform matrix definition, first, scale 3 times, then translate on (1,2,3)
   *	coat::vec3 x(1,2,3); // 3d vector declaration
   *	x.TransformCoordinate(m); // transform the vector coordinate by the 4D matrix
   *	coat::vec3 n(3,4,5);
   *	n.Normalize(); // normalize vector
   *	n.TransformNormal(m); // transform as vector, pay attention resulting vector is not mandatory normalized
   * \endcode
   */

   /** \page CoatArrays 3DCoat arrays
   * Use the coat::list<...> template if you need simple arrays. See the full descriprion of cList (same as coat::list) for the full description.\n
   * There are several examples of valid operations with arrays
   * \code
   *	 coat::list<int> array; // declare array of int-s
   *	 coat::list<int> array1;
   *	 array.Add(1); // add the single integer value 1
   *	 array1.Add(2, 10); // add 10 elements, each element is 2
   *	 array1.Insert(3, 5); // insert the value 5 at position 3
   *	 array1.RemoveAt(5, 2); // remove 2 elements at the position 5
   *	 int x[3] = { 7,8,9 };
   *	 array1.AddRange(x, 3); // add 3 elements from the regular array
   *	 array.AddRange(array1); // add the whole array 
   *	 array.Reverse(); // reverse the order of elements
   *	 int pos_of_2 = array1.find(2); // returns the position of the value 2, returns -1 if not found
   *	 for (int x : array) { // the for-cycle. In this case you may not erase array elements within the loop
   *	 	//... do something ...
   *	 }
   *	 for (int i = 0; i < array.Count(); i++) { // indexed for-loop, in this case you can remove elements within the cycle
   *	 	if (array[i] == 5) { // we remove element if it is exual to 5
   *	 		array.Remove(i--);
   *	 	}
   *	 }
   *	 array.Clear(); // set zero count of elements
   *	 array = array1; // you can assign one array to another one
   *	 array.forEach(
   *	 	[&](int x) {
   *	 		// do something with each element
   *	 	});
   *	 array1.Fill(7); // fill with the same value
   * \endcode 
   * Of course you can use any std containers like the **std::vector<...>**. But **coat::list** is more convenient and functionally rich. 
   * 3DCoat offers other types of arrays for more specific applications. This is StackArray for the fast array creation and access without 
   * the mandatory memory allocation and BigDynArray for the huge amount of elements when they can't be allocated into a single memory
   * chunk. Look also the \ref ValuesField for the rich toolset over the 2D float fields/images. 
   */

   /*examples start there*/
 /** \example minimal.cpp
 * The minimal c++ program
*![minimal](minimal.png)
*/

 /** \example HelloWorld.cpp
 * The simplest program - just show the Hello world!
*![HelloWorld](HelloWorld.png)
*/

 /** \example Strings.cpp
﻿ * Simple strings manipulations
*![Strings](Strings.png)
*/

 /** \example Arrays.cpp
﻿ * Very basic arrays operations
*![Arrays](Arrays.png)
*/

 /** \example Logging.cpp
﻿ * Output to the log file, writing to the text file
*![Logging](Logging.png)
*/

 /** \example ui_command.cpp
 * This example demonstrates how to click any item in UI
*![ui_command](ui_command.png)
*/

 /** \example dialogs.cpp
 * This example demonstrates the power of the dialogs and UI. It describes how to register the elements into the UI.
*![dialogs](dialogs.png)
*/

 /** \example square_volume.cpp
 * Iterate over the sculpt tree, show the basic stats - square, volume
*![square_volume](square_volume.png)
*/

 /** \example meshes.cpp
 * Generate the voxel figure that consists of random spheres
*![meshes](meshes.png)
*/

 /** \example meshes_surface_merge.cpp
 * Generate the figure that consists of multiple spheres merged into the single surface object without booleans
*![meshes_surface_merge](meshes_surface_merge.png)
*/

 /** \example metaballs.cpp
 * The metaballs example
*![metaballs](metaballs.png)
*/

 /** \example GeneratorExample.cpp
 * The basic generator example, just to demonstrate the principles of generators, look the \ref TreesGenerator.cpp for the more sophisticated example.
*![GeneratorExample](GeneratorExample.png)
*/

 /** \example TreesGenerator.cpp
 * The trees generator example
*![TreesGenerator](TreesGenerator.png)
*/

 /** \example csg_voxels.cpp
 * This example generates the detail for the further 3D printing using the voxels. The CSG principles demonstrated.
*![csg_voxels](csg_voxels.png)
*/

 /** \example csg_surface.cpp
 * This example generates the detail for the further 3D printing using the surface mode. The CSG principles demonstrated.
*![csg_surface](csg_surface.png)
*/

 /** \example BrickWall.cpp
 * Generate the surface figure "brick wall" that consists of boxes
*![BrickWall](BrickWall.png)
*/

 /** \example capsule.cpp
 * This example generates the surface figure that consists of capsule
*![capsule](capsule.png)
*/

 /** \example ellipses.cpp
 * This example generates the surface figure that consists of ellipses
*![ellipses](ellipses.png)
*/

 /** \example gear.cpp
 * This example generates the surface figure that consists of gear
*![gear](gear.png)
*/

 /** \example HoneyComb.cpp
 * This example generates the surface figure that consists of honey combs (ngons)
*![HoneyComb](HoneyComb.png)
*/

 /** \example OlympicRings.cpp
 *This example generates the surface figure "olimpic rings" that consists of toruses
*![OlympicRings](OlympicRings.png)
*/

 /** \example RollingPin.cpp
 * This example generates the surface figure rolling pin that consists of cylinders
*![RollingPin](RollingPin.png)
*/

 /** \example spheres.cpp
 * Generate the surface figure that consists of spheres
*![spheres](spheres.png)
*/

 /** \example spiral.cpp
 * This example generates the surface figure that consists of spiral
*![spiral](spiral.png)
*/

 /** \example tube.cpp
 * This example generates the surface figure that consists of tube
*![tube](tube.png)
*/

 /** \example WindRose.cpp
 * Generate the surface figure "windrose" that consists of cones
*![WindRose](WindRose.png)
*/

 /** \example HelloWorld3D.cpp
 * Generate the text primitive
*![HelloWorld3D](HelloWorld3D.png)
*/

 /** \example cup.cpp
 * Generate the surface figure "glass"
*![cup](cup.png)
*/

 /** \example DoorStop.cpp
 * This example generates the surface figure door stop that consists of half-sphere and cylinders
*![DoorStop](DoorStop.png)
*/

 /** \example bolt_binary.cpp
 * This example generates the bolt composite (bolt head + thread stud)
*![bolt_binary](bolt_binary.png)
*/

 /** \example bolt_rim.cpp
 * This example generates the bolt composite (rim head + round thread profile)
*![bolt_rim](bolt_rim.png)
*/

 /** \example boltheads.cpp
 * This example generates the bolt heads (hexa,flat,lamb)
*![boltheads](boltheads.png)
*/

 /** \example screw.cpp
 * This example generates the bolt composite (bolt head + thread stud)
*![screw](screw.png)
*/

 /** \example thread.cpp
 * This example generates the surface figure that consists of thread
*![thread](thread.png)
*/

 /** \example threadStud.cpp
 * This example generates the surface figure that consists of thread stud
*![threadStud](threadStud.png)
*/

 /** \example washer.cpp
 * This example generates the washer primitives (flat,grover,quard)
*![washer](washer.png)
*/

 /** \example nut.cpp
 * This example generates the nut primitive.
*![nut](nut.png)
*/

 /** \example ffBlob.cpp
 * This example generates the freeform primitive (blob)
*![ffBlob](ffBlob.png)
*/

 /** \example ffCube.cpp
 * This example generates the freeform primitive (cube)
*![ffCube](ffCube.png)
*/

 /** \example ffCylinder.cpp
 * This example generates the freeform primitive (cylinder)
*![ffCylinder](ffCylinder.png)
*/

 /** \example Dumbbell.cpp
 * This example generates the surface figure dumb-bell with usage of the debug mode
*![Dumbbell](Dumbbell.png)
*/

 /** \example Logo3D.cpp
 * This example generates the surface consist of logo 3D picture
*![Logo3D](Logo3D.png)
*/

