#pragma once

class LinkedObject;

struct MergeQueueElement{
	comms::cMeshContainer* mc;
	Matrix4D M;
};


struct BakedLayerInfo{
	Vector3D N;
	Vector4D Color;
	float Specular;
	float SpecMask;
	float Opacity;
	float Metall;
	float Opc;
	int SpaceID;
	int LayerID;
};
#define jmask(x) (1<<x)
enum JType{
	AxialMask	= 255,		///Axial symmetry degree, by default 4
	Vertical	= jmask(8),	///snaps only to vertical joints 
	Horizontal	= jmask(9),	///snaps only to horizontal joints
	Free		= jmask(10),///rotates anywhere
	Tile		= jmask(11),///may put multiple joints along line
	TypeMask	= jmask(12) + jmask(13) + jmask(14) + jmask(15),
	Type1		= jmask(12),///Type1 compatible, if no type specified, compatible to all types, multiple types may be supported by single joint
	Type2		= jmask(13),///Type2 compatible
	Type3		= jmask(14),///Type3 compatible
	Type4		= jmask(15),///Type4 compatible
	IsConnector = jmask(16),///Definition of the joint as ? connector for blocks that can not be inserted into themselves.
	IsPlug		= jmask(17),///Definition of the joint as ? plug for blocks that can not be inserted into themselves.
	KeepDirection = jmask(18),	///Keep direction
	ManualRotate  = jmask(19),	///Manual rotate
	AutoFlipX	= jmask(20), ///Auto flip X
	AutoFlipY	= jmask(21), ///Auto flip Y
	AutoFlipZ	= jmask(22)	///Auto flip Z
};
///Joints on the merged object for smapping, all coordinates are in local space of the object, object itself kept in VoxelSculptTool::CurrRawMesh
struct SnapJoint{
	Vector3D	JointPos;
	Vector3D	JointDir;
	Vector3D	JointT;
	Vector3D	JointB;
	Matrix4D	Transform;
	///0 - Tube, 1- Brick, 2 - Wall, 3-Free, 4-Scale, 5 - Bend, 6-WallBend 
	int			JointType;
	int			Connector; /// HashCode from connectorName for fixed size in a struct and fast compare
	int			ObjectGUID;
	AABoundBox	ObjectAB;
};
class VoxExpandContext {
public:
	int cellX, cellY, cellZ;
	int x0, y0, z0;
	Vector3D P0;
	VolumeCell* cell;
	VolumeCell* hiddenCell;
	VoxType sameInitial;
	VoxType* result;
	VoxType* initial;
	VoxType* hidden;
	bool changed;
	byte mask;
	inline int ofs(int x, int y, int z) {
		return x + y * 9 + z * 81;
	}
	void set(int x, int y, int z, int value);
	void report_change(int x, int y, int z);
};

inline void VoxExpandContext::report_change(int x, int y, int z) {
	x &= 7;
	y &= 7;
	z &= 7;
	if (x == 0)mask |= 1;
	if (x == 7)mask |= 2;
	if (y == 0)mask |= 4;
	if (y == 7)mask |= 8;
	if (z == 0)mask |= 16;
	if (z == 7)mask |= 32;
	changed = true;
}

struct VolumePaintContext {
	StackArray<char, 2048>* pool;
	cList<PenPoint>* points;
	VolumetricLayer* cl;
	VolumetricLayer* clgm;
	VolumetricLayer* clfa;
	VolumetricLayer* cl_backup;
	VolumetricLayer* clgm_backup;
	VolumetricLayer* cl_temp;
	VolumetricLayer* clgm_temp;
	VolumetricLayer* clfa_backup;
	VoxExpandContext* co;
	MtlContext* con;
	void* CellContext;
	void AllocContext(int size);
};

struct VolumePixelContext {
	VolumePaintContext* co;
	Vector4D* CL;
	Vector4D* CLGM;
	Vector4D* CLR;
	Vector3D* GMD;
	float w;	
};

struct RayPickPoint {
	Vector3D pos;
	Vector3D nrm;
	VolumeCell* vc;
	int TriIndex;
	Vector3D uvw;
	float dotpos;
};

class ABOcTreeLevel :public BaseClass {
public:
	uni_hash<AABoundBox, tri_DWORD> Cells;
	uni_hash<DWORD, tri_DWORD> Dirty;
};
class APICALL ABOcTree {
public:
	ABOcTree();
	int Depth;
	ClassArray<ABOcTreeLevel> Levels;
	void Update(VolumeObject* VO);
	void AddDirtyCell(int Level, tri_DWORD& tz, AABoundBox* AB);
	void Clear();
};

struct APICALL MCMeshInCell {
	MCMeshInCell() {
		M = NULL;
		CoverMeshes = NULL;
	}
	void free();
	StaticMesh* M;
	cList<StaticMesh*>* CoverMeshes;
	DWORD Dirty;
	Rct   Rect;
	AABoundBox mAB;
	float gcp;
	tri_DWORD T;
	WORD  RenderStamp;
};

class NodeGraph;


struct APICALL VoxShaderParams :public BaseClass {
	VoxShaderParams();
	cStr name;
	int VertexFormatID;
	int	ID;
	int TempTextures[8];
	cStr TexReplacement[8];
	float ngScale;
	int CurrentIteration;
	int SecondLightIntensity;
	int ScreenSampler;
	int ShadowSampler;
	int DepthSampler;
	int Sampler3;
	int var_du;
	int var_dv;
	int vpWidth;
	int vpHeight;
	int Svar;
	int Lvar;
	int LvarN;
	int LViewPos;
	int LViewDir;
	int MaterialTransform;
	int ShadowMin;
	int ShadowTM;
	int ColorVar;
	int BColorVar;
	int LightColor;
	int Opacity;
	int GridConst;
	int UndercutsEdgeValue;
	int UndercutsTopBottomValue;
	bool RequiresDepth;
	//Capabilities

	bool UseColorTexture;
	bool UseGlossTexture;
	bool UseMetalnessTexture;
	bool UseNormalmapTexture;
	bool DepthBased;
	bool UseCavity;
	bool NGUseCavity;
	bool FlatShading;
	DWORD AppMask;
	DWORD BoolHash;

	static bool permanent_edit;

	
	Matrix4D Transform;
	Matrix4D TransformInv;

	NodeGraph* refNodes = nullptr;
	NodeGraph& MaterialNodeGraph();
	cStr NodesResultExpression;

	cList<int> ShaderVarsForNodes;
	static cList<int> TryUnlinkShaders;


//	void EditNodes();

	ClassArray<ExShaderParam> ExParams;
	ExShaderParam* GetParam(const char* ID);
	bool AssignShader(const char* Name);
	void UnlinkShader();
	int Activate();
	void EnumTextures();
	bool Edit(bool Permanent = false);
	void CopyTo(VoxShaderParams* dest);
	void SetParamsUsage(bool set);
	bool IgnoreLayer0();
	DWORD CalcMask();
	DWORD CalcBoolHash();
	int ReAssignShader();
	virtual bool ProcessInEditor(BaseClass* Parent) override;
	SERIALIZE_LATER();

	int NGObjectIdx = -1;
};

struct SpScanResult {
	SpScanResult() {
		vca = NULL;
		TriIdx = 0;
		u = v = 0;
	}
	Vector3D Pos;
	Vector3D Pos0;
	Vector3D N;
	float Dist;
	VolumeObject* vo;
	VolumeCellAttrib* vca;
	int TriIdx;
	float u, v;
	int Dir;
	float Freeze;
};

struct APICALL SpOcTreeBase {
	int Level;
	//comms::cSphere	Bound;
	AABoundBox	Bound;
	void Clear();
	void Scan(const Vector3D& Start, const Vector3D& Dir, float Len, StackArray<SpScanResult>& res);
	static void ScanCell(VORenderQueue& rq, VolumeCellAttrib* vca, int idx, const Vector3D& Start, const Vector3D& Dir, StackArray<SpScanResult>& res);
	void DrawLevel(int L, DWORD Color);
};

struct SpOcTreeLeaf :public SpOcTreeBase {
public:
	VoxTreeBranch* vt;
	VolumeObject* VO;
	VolumeCell* vc;
	SpOcTreeLeaf* next;
};

struct APICALL SpOcTreeLevel :public SpOcTreeBase {
public:
	SpOcTreeBase* Cells[8];
	void AddCell(SpOcTreeLeaf* L, Vector3D Center, float Side);
};

class APICALL SpOcTree {
public:
	SpOcTree();
	SpOcTreeLevel L0;
	Vector3D Center;
	float Side;
	bool NeedFreeze;

	CellElmNodeAllocator alloc;
	CellElmABNode Root;
	BigDynArray<CellElmAB> Temp;

	void AddCell(VORenderQueue& vo, VolumeCell* vc);
	void AddSmoothedVO(VORenderQueue& vo);
	void Create(bool Smoothed = true, bool Anyway = false);
	//void CreateForVO(VORenderQueue& RQ);
	void Clear();
	void PrepareToScan();
	bool Scan(Vector3D Start, Vector3D Dir, float Len, SpScanResult& res);
	static bool ScanAll(Vector3D Start, Vector3D Dir, float Len, SpScanResult& res, bool Sharp = true);
	static void CreateAll(bool Smoothed = true);
	static void CreateVO(VolumeObject* VO);
	static void RestoreAll();
	static void ClearAll();
};

class APICALL VolumeColorizer {
public:
	struct ColorDebt {
		VolumeObject* vo;
		int Layer;
		void_hash<tri_DWORD, 16384,1024> cells;
	};
	struct cell {
		/// the local mesh list of pairs (position, normal)
		cList<std::pair<Vector3D, Vector3D>> verts;
		/// triangles indices
		cList<indtype> ids;
		/// color layers, defined as array that contains chunks
		///	DWORD LayerID (for color layer) or -1-LayerID (for specularity)
		/// DWORD [] - same amount of colors as verts has
		///	there may be multiple layers in the single array
		cList<DWORD> Layers;
	};
	cList<cell*> cells;
	int SingleLayer;

	VolumeColorizer();
	~VolumeColorizer();
	void AddCell(VolumeCell* vc);
	void RenderToVolume(VolumeObject* vo, const Matrix4D& MT);
	static void RenderAllVolumes(int Layer);

	static cList<ColorDebt*> debt;
	static ColorDebt* GetColorDebt(VolumeObject* vo, int L);
	static void FinishColorDebts();
};

#define REG_VOXEL_COLOR \
REG_AUTO(VolumeObject::GloballyIntentVoxelColoring, "UseVoxelColor");\
if (VolumeObject::GloballyIntentVoxelColoring) {\
	FSLIDER(GeneralPen::ColorOpacity, "ColorOpacity", 0, 1, 100, 0);\
	if (AppOptions::TexApproach == 2) {\
		FSLIDER(GeneralPen::SpecularDegree, "Roughness", 0, 1, 100, 2);\
	}\
	else\
		if (AppOptions::TexApproach == 0) {\
			FSLIDER(GeneralPen::SpecularDegree, "PEN_SPEC", 0, 1, 100, 0);\
		}\
	FSLIDER(GeneralPen::MetalnessDegree, "PEN_METAL", 0, 1, 100, 0);\
}\
DELIMITER;

#define SCOPED_VOXEL_COLOR \
	auto_keep(VolumeObject::GloballyAllowVoxelColoring);\
	VolumeObject::GloballyAllowVoxelColoring = VolumeObject::GloballyIntentVoxelColoring;\
	if (VolumeObject::GloballyIntentVoxelColoring && PolyMesh::CurrentLayerID == 0) {\
		if (PMS().Layers.Count() == 1) {\
			PMS().AddLayer(true);\
		} else {\
			ShowFloatingWarning("VoxelColorOverLayer0",3000,0,false);\
		}\
	}

class SubdCalcGraph;
class SubdLevelRef;

class LayerSubdStorage : public BaseClass{
public:
	int LayerID;
	cStr LayerInfo;
	virtual void Extract(VolumeObject* vo) {}
	virtual void RestoreTo(VolumeObject* vo, UnlimitedBitset* udim) {}
	virtual void Store(BinStream& bs) {}
	virtual void Restore(BinStream& bs) {}
	virtual void Subdiv(SubdCalcGraph& graph) {};
	virtual bool toRaw() { return false; }
	virtual void toCompact() {}
	virtual void scale(float s) {}
	virtual LayerSubdStorage* clone() { return nullptr; }

	SERIALIZE() { }
};

class LayerVecStorage : public LayerSubdStorage {
public:
	BigDynArray<std::pair<int, Vector3D>, 16384> vec;
	BigDynArray<Vector3D, 65536> raw;//temporary

	bool toRaw() override;
	void toCompact() override;	
	
	void Extract(VolumeObject* vo) override;
	void RestoreTo(VolumeObject* vo, UnlimitedBitset* udim) override;
	void AddTo(VolumeObject* vo, UnlimitedBitset* udim);
	void Store(BinStream& bs) override;
	void Restore(BinStream& bs) override;
	void Subdiv(SubdCalcGraph& graph) override;
	void scale(float sc) override;
	virtual LayerSubdStorage* clone();

	static void ApplyLayerDiff(SubdCalcGraph* ref, SubdCalcGraph* src_layers, VolumeObject* low_vo, VolumeObject* high_vo, int L, float scale, UnlimitedBitset* udim);

	SERIALIZE() { }
};

class LayerColorStorage : public LayerSubdStorage {
public:
	LayerColorStorage();
	int Type;// 0 - color, 1 - gloss/met 
	BigDynArray<std::pair<int, DWORD>, 16384> vec;
	BigDynArray<std::pair<Vector4D, float>, 65536> raw;//temporary

	bool toRaw() override;
	void toCompact() override;


	void Extract(VolumeObject* vo) override;
	void RestoreTo(VolumeObject* vo, UnlimitedBitset* udim) override;
	void AddTo(VolumeObject* vo);
	void Store(BinStream& bs) override;
	void Restore(BinStream& bs) override;
	void Subdiv(SubdCalcGraph& graph) override;
	virtual LayerSubdStorage* clone();

	static void ApplyLayerDiff(int Type, SubdCalcGraph* ref, SubdCalcGraph* src_layers, VolumeObject* low_vo, VolumeObject* high_vo, int L);

	SERIALIZE() { }
};

class SubdCalcGraph {
public:
	BigDynArray<tri_int, 65536> index;//vertex, number, start
	BigDynArray<std::pair<int, float>, 65536> weights;
	BigDynArray<Vector3D, 65536> initialPos;
	cList<LayerSubdStorage*> layers;

	void addIndex(int vertex, int num);
	void addWeight(int vertex, float weight);
	void ToBS(BinStream& BS);
	void FromBS(BinStream& BS);
	void Apply(BigDynArray<Vector3D, 65536>& a);
	void Apply(BigDynArray<Vector4D, 65536>& a);
	void Apply(BigDynArray<std::pair<Vector4D, float>, 65536>& a);
};

class SubdLevelRef : public BaseClass {
public:
	cStr refName;
	int Level;
	SubdCalcGraph toUpper;
	SubdCalcGraph toLower;
	SERIALIZE_LATER();
};

struct VolumeOperand {
public:
	VolumeOperand(){}
	VolumeOperand(VolumeObject* _op, const Matrix4D& _T, char _operation) : op(_op), T(_T), operation(_operation) {
		Tinv = T;
		Tinv.Invert();
		Vector3D v(T.Elem(0,0), T.Elem(1, 1), T.Elem(2, 2));
		density = v.Length();
	}
	VolumeObject* op;
	Matrix4D T;
	Matrix4D Tinv;
	float density;
	// 1 - subtract, 2 - intersect, 3 - union
	char operation;
};

/**
\brief One layer without hierarchy in the SculptRoom.
\details
Represents volume object. Volume object may be in volume or surface
representations depends on bool `InSurfaceRepresentation()`.
In volume mode voxels are modified and then mesh is generated.
In surface mode mesh is modified then voxels are generated.
The transform matrix of volume corresponds to latest selected instance in `VoxTree`.
There may be multiple references from `VoxTree` to the same `VolumeObject`.
\n
`VolumeObject` is voxel/surface object not placed in tree. `VoxTreeBranch` is the object reference.
All active `VoxelObject`'s are kept as linear set in `VTree` array.
`RootVTree` consists of hiererchial set of references of objects from this array.
Each `VolumeObject` contains complete information about geometry in local space.
Correct transform matrices are kept in `VoxTreeBranch` that refers this `VolumeObject`.
Transform matrices in `VolumeObject` correspond to non-instanced `VoxTree` element.
If object is instance transform matrix in `VolumeObject` is
different form `VoxTreeBranch` transform.

\see VoxTreeBranch
*/

class APICALL VolumeObject:public BaseClass{
public:
	typedef VolumeCell* (VolumeObject::*fnCellOperation)(int x,int y,int z);
	bool linkedToRetopoObj;
	bool topologyLockedByLinkedObject;
    /// Unique ID of the volume, same as `VoxTreeBranch::SpaceID`.
	int SpaceID;
	int LoadTimeSpaceID;
	cStr SpaceName;
    /// Cache reference.
	cStr CacheName;
	bool Ghost;
	const char* cache();

	VoxTreeBranch* boolean_root;

	float GetGlobalSummaryCut(const Vector3D& p, VoxTreeBranch* root = nullptr);
	Vector3D GetSummaryCutExcept(const Vector3D& p, VolumeObject* except, VoxTreeBranch* root = nullptr, float* density = nullptr);

	// 0 - none, 1 - subtract, 2 - intersect, 3 - add
	int CuttingOperation;
	bool FlipFaces;
	bool BooleansDisabled;

	ClassArray<SubdLevelRef> Subd;
	int CurrentSubdLevel;
	bool DestroySubdLevels();
	std::function<float(Vector3D)> volumetricalGettter;

	ClassArray<LinkedObject> linkedObjects;
	int NGObjectIdx = -1;


	static VolMarker Marker;
	static float AverageEdgeLengthInPen;
	static int BackBufferTextureID;
	static int BackBufferDepthID;
	static int BBSizeX;
	static int BBSizeY;
	static int VoxThreshold;
	static WORD RenderStamp;
	static Vector4D LightColor;
	static float LightScatter;
	static bool GloballyAllowVoxelColoring;
	static bool GloballyIntentVoxelColoring;
	/// `111` for external light, `rgb` for panorama.
	static Vector4D LightColor2;
    /// `1` for external light, `0` for panorama.
	static float IsExternalLight;
	static bool AllowBB;
	static bool WholeDirty;	
	static bool Incremental;
	static bool AllowProgress;
	static bool IgnoreDropUndo;
	static bool NoVoxMerge;
	static bool InvisibleMode;
	static Rct DirtRect;
	static bool GlobalSortTriangles;
	static void SetCur(VoxTreeBranch* tb,bool Fast=false,bool keepsym=false,bool flash=true);

	static bool WarnIfSurface(bool HasCancel);
	static bool CheckLockedVolume();

    /// Color to be restored when volume will be turned back to surface mode.
	BakedLayersStorage* OldColor;
    /// How scale is changed when passed to proxy mode.
	float ScaleChange;
	float VolumeExtrusion;

    
	BigDynArray<tri_DWORD> bkCells;
	VolumeObject();
	~VolumeObject();
	std_OnePoolType vpool; ///< pool for voxel values, words
	std_OnePoolType cpool; ///< pool for VolumeCell
	std_OnePoolType apool; ///< pool for VolumeCellAttrib
    /**
    \brief Represents `OcTree` structure for fast finding of volume cells.
    */
	ABOcTree		VoxOcTree;
	AABoundBox      LocalAABB; ///< AABB in local space
	float			PickFarPlane; ///< far plane position in picked radius 
	float			PickNearPlane; ///< closest plane position in picked radius
	float			PickAvgPlane; ///< average plane position in picked radius
	float			PickPlane; ///< plane position of picked center
	PickedPool		PickList; ///< temporary storage for cells to operate
	int				PickListDirty;
	AABoundBox		LastDrawn; ///< last drawn bound box of cells centers in local space
	int				Border; ///< border for dencity falloff in voxel objects, usually is 4
	cVec3i			MinCell; ///< min for bound box of cell indices, x,y,z
    cVec3i			MaxCell; ///< max for bound box of cell indices, x,y,z
	Matrix4D		Transform; ///< transform from local to global space
	Matrix4D		TransformInv; ///< transform from global to local space
	bool			Visible; ///< better refer visibility from VoxTreeBranch
	bool			InCache; ///< is in cache state
	bool			SurfaceColorChanged;
	int RawObjTris;
	int RawInSurfaceRepresentation;
	int CurCacheMethod = 4;
	int LastPolycount;
	float			ScaleFactor; ///< scale factor, it is like simplified transform from local to global space. If you need to get some distance approx in local space, divide it on ScaleFactor
	VolumeObject*	Environment;
	VolumeObject*	HiddenVolume; ///< Hidden part of this volume, kept in VTree as well
    /**
    \brief Allows to allocate / free global indices for mesh represented by `MeshInVCell`.
    */
	MeshHelper		IdxAllocator;
	VolumeObject*	TempRef;
	uni_hash<float,DWORD> CavityMap; ///< cavity for all vertices
	bool CellsChanged;
	bool HasLeakyPos;
	bool CompletelyRebuilt; ///< this is for undo, it indicates that structure of volume changed drastically, almost no correstondence between old and new
	bool HasTransparency; ///< for render - nood to sort triangles or not
	bool RenderJustFacture;
	static bool SomethingNewSelected;
	///Joints of all merged objects
	cList<SnapJoint> Joints;
	cList<SnapJoint> BackupJoints;

	///Add joint to volume, GlobalTransform is transform matrix for model in world space
	void AddJoint(const SnapJoint& J,const Matrix4D& GlobalTransform);
	///Add all joints registered in VoxelSculptTool
	void AddAllJoints();

	DWORD Color;
	DWORD ApproxColor; ///< bot baking of approximate shader color
	DWORD ApproxSpec;
	int ApproxMet;
	ShaderEstimator* Est; ///< estimate hader approximately
	PbrEstimator* PbrEst;
	VoxShaderParams Shader;

	DWORD EstimateShaderColor(Vector3D pos);
	void SetTransform(Matrix4D M,bool symm);
	void TransformPt(Vector3D& P);
	void TransformScalar(float& P);
	void TransformVec(Vector3D& P);
	void TransformNrm(Vector3D& P);
	void TransformPtInv(Vector3D& P);
	void TransformVecInv(Vector3D& P);
	void TransformNrmInv(Vector3D& P);
	void TransformScalarInv(float& P);

	bool CheckIfUseCUDA(float Radius);

	void GenerateCavity();
	void GenerateCavity2();
	void DiscardCavity();
	float GetCavity(int gid);
	bool UsesLayer(int L);
	void FlipNormals();

	void WeldEdgeVertices(cList<VolumeCell*>& List);
	void WeldEdgeVertices(cList<PickedCell>& List);
	void WeldEdgeVertices(CellPickPool& Pool);
	void SeekInTree(const std::function<bool(const AABoundBox& ab)>& check_local_AB, const std::function<void(const tri_DWORD& T, VolumeCell* pvc)>& result);
	void SeekInTree(const AABoundBox& ab, const std::function<void(const tri_DWORD& T, VolumeCell* pvc)>& result);

	Vector3D LastWorkPoint;
	int SubCellSize;
	int DefCellSize;
	int DefCellShift;
	int NumBackups;
	bool SurfaceChanged;
	bool NeedOcTreeRefine;
	bool SimpleStampMode;
	bool HideMode;
	bool InSurfaceRepresentation;
	uni_hash<DWORD, tri_DWORD, 62144, 4096> DirtyMeshes;
	uni_hash<DWORD, tri_DWORD, 62144, 4096> DirtyCells;
	uni_hash<DWORD, tri_DWORD, 62144, 4096> DirtyMCells;
	cList<MCMeshInCell*> RenderOrder;
	Vector3D OrderDir;
	uni_hash<MCMeshInCell,tri_DWORD> Meshes;
    /**
    \brief Array of `VolumeCell`.
    \details `VolumeCell*` corresponds to every `tri_DWORD`.
    */
	uni_hash<VolumeCell*,tri_DWORD,126213, 4096> Cells;
	uni_hash<VolumetricLayer*, quad_DWORD, 126213, 1024> TempVol;
	VolumeCell* GetCell(int x,int y,int z,bool Create,bool CreateBackup=false,bool Multithreaded=true);
	VolumeCell* GetCell(const tri_DWORD& t, bool Create, bool CreateBackup = false, bool Multithreaded = true);
	VolumeCell* GetBackup(int x,int y,int z);
	VolumeCell* CreateBackup(int x,int y,int z);
	VolumeCell* MoveToBackup(int x,int y,int z);
	uni_hash<tri_DWORD,tri_DWORD> CellsNearCells;
	void DetachModifiers();
	void ClearBackups();
	void CreateCellsNearCells();
	void Clear(bool KeepCache = false);
	void ClearWithUndo();
	static void ClearLeakyPos();
	void RestoreColors();
	void TotalSmooth(int Times=1);
	void DeleteCell(int x,int y,int z);
	void CalcCellsAABB();	
	AABoundBox CalcCellsAABBTransformed(bool by_tree = true);	
	void EstimateObjectColor();
	void CreateEstimateStructures();
	void ClearEstimateStructures();
	static void ClearAllEstimateStructures();
	Vector4D GetObjectColor(Vector3D pos,int* Specular,int* spop,int* met,Vector3D* Normal,SpScanResult* srs=NULL,float Cavity=0,float PixSize=0);
	static void EstimateAllObjectsColor();
	void EnsureHiddenVolumeExists();

	//Create shape in volume using getter and StartPoint recursively. All points are in local space
	void CreateProceduralVoxelShape(Vector3D StartPoint, int Subtract, std::function<float(const Vector3D&)> getter, bool color = false);

	Vector3D GetAverageVoxelNormalInSphere(Vector3D Center, float Radius);
	Vector3D GetAverageVoxelNormalAndPosInSphere(Vector3D& Center, float Radius, float nrmSampling = 1.0, float posSampling = 1.0, bool FromBackup=true, const Vector3D& Preferred = Vector3D::Zero);
	void IterateVertsInSphere(Vector3D& Center, float Radius, const std::function<void(MCVertex&, float)>& fn);
	void UpdateVixelNormalsInLocalTrajectory(PointsStory& pts);
	void UpdateVixelNormalsAndAveragePositionsInLocalTrajectory(PointsStory& pts);
	void UpdateVixelNormalsAndAveragePositionsInLocalTrajectory(cList<TrElement>& pts, float nrmSampling, float posSampling);

	

	/**
	 * \brief Creates the arbitrary volxels shape
	 * \param fn the callback that defines the shape. Gets position of the point returns the value 0..1 to be set as voxel value
	 * \param Start the array of start points to grow the changes
	 * \param Subtract Subtract = 0: add, 1:subtract, 255: replace
	 * \param UseTemp set true if you want modify the cell afterward, all passed values will be kept in temp location and placed into the cell after the whole operation will be completed.
	 * \param OverHide All changes will be passed to the hidden volume
	 */

	void CreateFuncShape(std::function<float(Vector3D)> fn, const cList<Vector3D>& Start, int Subtract, bool UseTemp = false, bool OverHide = false, bool UseColor = false, bool onlyChanges = true);
	/**
	 * \brief Creates the arbitrary volxels shape
	 * \param fn the callback that defines the shape. Gets position of the point returns the value 0..1 to be set as voxel value
	 * \param Start the array of start points to grow the changes
	 * \param fc the callback that defines the color. Gets position of the point returns the color value dword(r g b a) as voxel color
	 * \param Colors the array of color points to grow the changes
	 * \param Subtract Subtract = 0: add, 1:subtract, 255: replace
	 * \param UseTemp set true if you want modify the cell afterward, all passed values will be kept in temp location and placed into the cell after the whole operation will be completed.
	 * \param OverHide All changes will be passed to the hidden volume
	 */
	void CreateFuncShape(std::function<float(Vector3D)> fn, const cList<Vector3D>& Start, std::function<dword(Vector3D)> fc, const cList<dword>& Colors, int Subtract, bool UseTemp, bool OverHide, bool UseColor);
	void CreateFuncShape(std::function<void(VoxExpandContext&)> fn, const cList<Vector3D>& Start, bool UseTemp = false, bool OverHide = false, bool fillBorders = true, bool TileColor = false);
	void CreateFuncShape(std::function<float(Vector3D)> fn,Vector3D Pos,const AABoundBox& Where,int Subtract,bool Additive=false,bool ComplexCheck=false,bool UseTemp=false, bool OverHide = false, bool OnlyChanges=false);	
	void CreateFuncShape(std::function<float(Vector3D)> fn,cList<tri_DWORD>& CellsList,int Subtract,bool Additive=false,bool ComplexCheck=false,bool UseTemp=false);
	void CreateFuncShapeCUDA(fnGetValueInVolume* fn,Vector3D Pos,const AABoundBox& Where,int Subtract,bool Additive=false,bool ComplexCheck=false,bool UseTemp=false,int Extrusion=0);	
	void CreateFuncShapeWeighted(fnGetValueInVolumeW* fn,Vector3D Pos,const AABoundBox& Where,bool Subtract,bool Additive=false);	
	void ApplySurfChange(fnGetSurfDisp* fn,Vector3D Pos,const AABoundBox& Where,fnGetSurfDisp2* Reader=NULL,float SmDeg=0);	
	void ApplySurfChange(fnGetSurfDisp4* fn,Vector3D Pos,const AABoundBox& Where,fnGetSurfDisp4* Reader=NULL,float SmDeg=0);	
	void CreateSphere(Vector3D Pos,float Radius,bool Subtract,bool Additive=false);	
	void CreateSphereSegment(Vector3D Start,Vector3D End,float RadiusS,float RadiusE,int Subtract,bool Additive=false);
	void CopySphereSegment(Vector3D Start,Vector3D End,float RadiusS,float RadiusE);
	VolumeCell* TransferCells(int x,int y,int z);
	void TransferSphereSegment(VolumeObject* Dest,Vector3D Start,Vector3D End,float RadiusS,float RadiusE);
	void TransferSphereSegmentSymm(bool Hide,Vector3D Start,Vector3D End,float RadiusS,float RadiusE);
	void CreateSphereSegmentSymm(Vector3D Start,Vector3D End,float RadiusS,float RadiusE,int Subtract,bool Additive=false);	
	void CopySphereSegmentSymm(Vector3D Start,Vector3D End,float RadiusS,float RadiusE,bool Subtract);
	void CreateSegment(Vector3D Start,Vector3D NS,float AspectS,Vector3D End,Vector3D NE,float AspectE,float R1,float R2,float ExtraLayerWidth,bool Subtract);
	void CreateLimSegment(Vector3D Start,Vector3D NS,float AspectS,Vector3D End,Vector3D NE,float AspectE,float R1,float R2,comms::cPlane PL,float ExtraLayerWidth,bool Subtract);
	void CreateSegmentSymm(Vector3D Start,Vector3D NS,float AspectS,Vector3D End,Vector3D NE,float AspectE,float R1,float R2,float ExtraLayerWidth,bool Subtract,bool DoubleSided=false,bool PlaneLimit=false);
	void CreateLimSegmentSymm(Vector3D Start,Vector3D NS,float AspectS,Vector3D End,Vector3D NE,float AspectE,float R1,float R2,comms::cPlane PL,float ExtraLayerWidth,bool Subtract,bool DoubleSided=false);
	void PerformSmoothing(Vector3D Pos,float Radius,float AddValue=0,int AddMode=0);
	void PerformSmoothingCUDA(Vector3D Pos,float Radius,float AddValue=0,int AddMode=0);
	void PerformSmoothingSymm(Vector3D Pos,float Radius,float AddValue=0,int AddMode=0);
	void PerformPinchVox(Vector3D Pos1,float Radius1,Vector3D N1,Vector3D Pos2,float Radius2,Vector3D N2,float Degree,Vector3D Shift);
	void PerformPinchVoxSymm(Vector3D Pos1,float Radius1,Vector3D N1,Vector3D Pos2,float Radius2,Vector3D N2,float Degree,Vector3D Shift);	
	void GrowSurface(Vector3D Start,Vector3D NStart,float StartD,Vector3D End,Vector3D NEnd,float EndD,float R1,float R2,bool Subtract,bool UsePen,bool UseTemp);
	void GrowSurfaceSymm(Vector3D Start,Vector3D NStart,float StartD,Vector3D End,Vector3D NEnd,float EndD,float R1,float R2,bool Subtract,bool UsePen,bool UseTemp);
	
	void ExtrudeVoxelsSymm(cList<TrElement>& List, bool Subtract, float Relax);
	void ClayVoxelsSymm(cList<TrElement>& List, bool Subtract, float Relax);
	void ModifyVoxelsAlongTrajectorySymm(cList<TrElement>& List, bool Subtract, std::function<float(const Vector3D&, const TrElement&, const TrElement&)> fn);
	void ModifyVoxelsAlongTrajectory(cList<TrElement>& List, bool Subtract, std::function<float(const Vector3D&, const TrElement&, const TrElement&)> fn);
	void ModifyVoxelsSpotsAlongTrajectory(cList<TrElement>& List, bool Subtract, std::function<float(const Vector3D&, const TrElement&)> fn);
	
	void ApplyPlane(Vector3D Start,Vector3D N,float Radius,float disp);
	void ApplyPlaneSymm(Vector3D Start,Vector3D N,float Radius,float disp);
	void DrawPressStroke(Vector3D Start,Vector3D End,Vector3D NStart,Vector3D NEnd,float R1,float R2,float Pressure,bool Subtract);
	VolumeCell* AddCellTriangulation(int cx,int cy,int cz);
	VolumeCell* AddCellTriangulation2(int cx,int cy,int cz);
	void AddGlobalCellQuads(int cx,int cy,int cz,VolumeCell* vc,QuadContext* TC);
	static void ExportGlobalQuads(comms::cMeshContainer* res);
	void AddGlobalCellTriangulation(int cx,int cy,int cz,VolumeCell* vc,TriangulationContext* TC,const Matrix4D& M);
	void AddGlobalCellTriangulation2(int cx,int cy,int cz,VolumeCell* vc,TriangulationContext* TC,const Matrix4D& M,cList<int>* CellPos=NULL);
	void AddGlobalCellTriangulation3(int cx,int cy,int cz,VolumeCell* vc,TriangulationContext* TC,const Matrix4D& M);
	void AddGlobalCellTriangulationG(int cx, int cy, int cz, VolumeCell* vc, TriangulationContext* TC, const Matrix4D& M, cList<int>* CellPos = NULL);
	VolumeCell* AddIndexedCellTriangulation(int cx,int cy,int cz);
	VolumeCell* AddIndexedCellTriangulation2(int cx,int cy,int cz);
	void PerformGlobalTriangulation(TriangulationContext* TC,cList<int>* CellPos=NULL);
	VolumeCell* CreateFuncShapeInCell(int cx,int cy,int cz);
	VolumeCell* CreateFuncShapeInCellW(int cx,int cy,int cz);
	VolumeCell* CreateFuncShapeInCellUsingTemp(int x,int y,int z);
	VolumeCell* MakeSmoothingInCell(int cx,int cy,int cz);	
	VolumeCell* MakeSmoothingInCell3(int cx,int cy,int cz);	
	VolumeCell* MakeSmoothingInCell2(int cx,int cy,int cz);
	VolumeCell* MakePinchInCell(int cx,int cy,int cz);
	VolumeCell* GrowSurfaceInCell(int cx,int cy,int cz);
	VolumeCell* GrowDensityInCell2(int cx,int cy,int cz);
	VolumeCell* GrowDensityInCell(int cx,int cy,int cz);
	VolumeCell* CutHullInCell(int cx,int cy,int cz);
	void ClearAllTemp();
	static void ClearAllTempForAll();
	void MarkDirtyCell(int cx,int cy,int cz,bool onlymesh=false,bool MultiThread=false);
	float GetInterpValue(Vector3D Pos, bool Backup = false, bool Mutltithread = false, StackArray<DWORD, 128>* colors = nullptr);
	float GetInterpValueThrough(Vector3D Pos,bool Backup=false);
	float GetVolumetricValue(Vector3D Pos);
	float GetCutByParents(Vector3D Pos, float* max_density = nullptr, VolumeObject* except = nullptr);
	float GetSummaryCut(Vector3D Pos, float* max_density = nullptr, VolumeObject* except = nullptr);

	float GetCutRecursive(Vector3D Pos, VolumeObject* except = nullptr);
	static float GetCut(Vector3D Pos, float* max_density, VolumeObject* except);

	void GetInterpLSumm(LSummator& dst, const Vector3D& pos, LsContext& con, LSummator* TempStorage);

	Vector3D GetFastNormal(const Vector3D& p, bool normalize = true);
	Vector3D GetInterpNormalThrough(Vector3D Pos,float dst);
	DWORD GetInterpColorThrough(Vector3D Pos,int* Specular=NULL,int* me=NULL,Vector3D* Normal=NULL,SpScanResult* srs=NULL);
	void GetInterpColorThroughLayered(Vector3D Pos,StackArray<BakedLayerInfo>& Info,Vector3D* N1,SpScanResult* srs=NULL,float PixSize=0);
	float GetOcclusionThrough(Vector3D Pos,float dst);
	float GetCavity(Vector3D Pos,float dst);
	Vector3D GetInterpNormalSmThrough(Vector3D Pos,float dst);
	float GetInterpEdgeValue(Vector3D Pos,VOCellCash* Cash);
	float GetInterpValueSm(Vector3D Pos);
	float GetInterpValueSmNThrough(Vector3D Pos,Vector3D& N);
	float GetInterpValueSmThrough(Vector3D Pos);
	float GetCInterpValue(Vector3D Pos,bool Backup,VOCellCash* Cash);
	VoxType GetPreciseValue(int x,int y,int z,VOCellCash* Cash,bool Backup=false);
	VoxType& GetPreciseValueRef(int x,int y,int z,VOCellCash* Cash);
	void SetPreciseValue(int x,int y,int z,VoxType V,VOCellCash* Cash);
	Vector3D GetInterpNormal(Vector3D Pos,bool Backup=false);
	Vector3D GetInterpPreciseNormal(Vector3D Pos,float Dist);
	Vector3D GetInterpEdgeNormal(Vector3D Pos,bool Backup=false);
	Vector3D GetInterpNormal2(Vector3D Pos,bool Backup=false);
	StaticMesh* CreateMesh(int cx,int cy,int cz,Rct& R,AABoundBox& ab,cList<StaticMesh*>* Cover=NULL);
	void UpdateMeshRect(int cx,int cy,int cz,MCMeshInCell* mc);
	void UpdateFilling();
	void CreateWholeMesh();
	void UpdateMesh(bool NoCuda=false);
	static void Render(bool IncludingPMS = false, bool IncludingRtp = false, bool ShadowOnly = false);
	void DrawPickPlane(bool invonly=false);
	void SnapMcToThisObject(comms::cMeshContainer* mc);
	bool ScanRay(Vector3D& Orig,Vector3D Dir,float Length);
	bool OcScanRay(Vector3D& Orig,Vector3D Dir,float Length,bool Quick=false);
	static bool OcScanRayAll(Vector3D& Orig, Vector3D Dir, float Length, bool Quick = false, float MinDist = FLT_MAX, VolumeObject** resVO = NULL, bool ByAbs = false, VoxTreeBranch** resTB = NULL, PutPointResult* res = NULL);
	bool ScanCells(Vector3D& Orig,Vector3D Dir,float Length);
	bool ScanCellsGrad(Vector3D& Orig,Vector3D Dir,float Length);
	bool ScanCellsGradSmart(Vector3D& Orig,Vector3D Dir,float Length,bool sm);
	bool ScanCellsGradSm(Vector3D& Orig,Vector3D Dir,float Length);
	bool ScanCellsPoly(Vector3D& Orig,Vector3D& Nrm,Vector3D Dir,float Length,bool pickfront=true,bool pickback=true,VolumeCellAttrib** resVA=NULL,int* ResTri=NULL);
	bool ScanCellsSaw(Vector3D& Orig,Vector3D& Axis,Vector3D& ResDir,float Length,VolumeCellAttrib** resVA,int* ResTri);
	void FindAllIntersections(const Vector3D& start, const Vector3D& dir, bool backup, cList<RayPickPoint>& list);
	bool Pick(Vector3D& Res, PickInfo& pic, bool OnlyPosition = false);
	Vector3D SnapToVolume(const Vector3D& pos, const Vector3D& dir);
	Vector3D CreatePickPool(Vector3D Pos,float Radius,PickedPool& PickList, bool SkipUndo = false);
	void ApplyToPickPool(Vector3D Pos,float Radius,fnGetSurfDisp4* fn);
	void ApplyToPickPoolTM(fnGetSurfDisp4* fn);
	void ApplyToPickPool(Vector3D Pos,float Radius,fnGetSurfDispUniv* fn);
	void ApplyToPickPool(Vector3D Pos,float Radius,fnGetSurfDisp* fn, Vector3D dir = Vector3D::Zero);
	void ApplyToPickPool(Vector3D Pos,float Radius,fnGetSurfDisp4* fn,fnGetSurfDisp2* Reader,float SmDeg);
	void Perform_MT_Operation(cList<tri_DWORD>& List,fnCellOperation Op,int maxp=1);
	void MergeModel(comms::cMeshContainer& mc,int Subtract,bool FirstLast=false,bool InvFaces=false,bool ToChild=false,int RespectNeg=0,int SubObj=-1);	
	void MergeModel(comms::cMeshContainer& mc,Matrix4D& M,bool Subtract,bool FirstLast=false,bool ToChild=false,int RespectNeg=0,int SubObj=-1);
	void MergeModelShell(comms::cMeshContainer& mc,Matrix4D& M,int Subtract,float InThickness,float OutThickness=0,bool ToChild=false,int RespectNeg=0,int SubObj=-1);
	void MergeModelSymm(comms::cMeshContainer& mc,Matrix4D& M,int Subtract,bool FirstLast=false,bool ToChild=false,int RespectNeg=0,int SubObj=-1);
	void MergeModelSymmSoft(comms::cMeshContainer& mc, Matrix4D& M, int Subtract, bool FirstLast = false, bool ToChild = false, int RespectNeg = 0, int SubObj = -1);
	void MergeModelShellSymm(comms::cMeshContainer& mc,Matrix4D& M,bool Subtract,float InThickness,float OutThickness=0,bool ToChild=false,int RespectNeg=0,int SubObj=-1);
	void MergeModelsSymm(cList<MergeQueueElement>& List,int Subtract,bool FirstLast,bool ToChild=false,int RespectNeg=0,int SubObj=-1);
	void StoreLayerToFile(float y,const char* Name);
	void Store(BinStream* BS,cList<VolumeObject*>* VOList=NULL,bool ForceSurf=false,bool StoreGid=false);
	void Restore(BinStream* BS,bool TryToFind=false,const char* CacheName=NULL);
	void StoreGlobalIds(VolumeObject* VO,BinStream& BS);
	void RestoreGlobalIds(VolumeObject* VO,BinStream& BS);
	void MergePMS(PolyMesh* PMS,float Scale);
	void ApplyHoleRect(VolumeObject* Dest=NULL,float SplitBorder=0,bool EraseOld=true,bool Additive=false);
	void ApplyFilledRect(Vector3D Start,Vector3D N,const Matrix4D& Symm, bool neg = false);
	void ApplyFilledRectSymm(Vector3D Start,Vector3D N, bool neg = false);
	void EnsureNativeIfInVoxels();
	void ApplyMeshChange(bool Forced=false);
	void ApplyMeshChangeAB(bool Forced=false);
	int  DetectPureGeometry();
	void VoxelizePureGeometry(bool Manually,bool AsShell,bool tovox=true,int suggestedpoly=0);
	int  GetPolycount();
	bool DetectRealVoxels();
	float GetAverageEdgeLength(bool inGlobalSpace);
	AABoundBox GetDimensionsInBasis(Vector3D x = Vector3D::AxisX, Vector3D y = Vector3D::AxisY, Vector3D z = Vector3D::AxisZ);
	float MergeWithGivenPolycount(int PolyCount,VolumeObject* dest,bool undo,float shelldepth=0);
	static float MergeWithGivenPolycount(int PolyCount, cList<VoxTreeBranch*>& Src, VolumeObject* dest, bool undo);
	float MergeAdaptively(int PolyCount,VolumeObject* dest);
	void UpdateLayersFromVolumetricColor(VolumeCell* vc, const Matrix4D& tm);
	void ApplySimplifiedMeshChange(int Subtract);
	void ApplyMeshChangeOnTheFly();
	void ProcessMeshChange();
	void ApplyMeshChangeSimple();
	void ApplyMeshChangeRough();
	void ApplySurfaceDistortion(Vector3D P,float R,float Dist,int Method);
	void ShrinkSurface(Vector3D Pos1,float Radius1,Vector3D Pos2,float Radius2,float Dist);
	void ApplySurfaceDistortionSymm(Vector3D P,float R,float Dist,int Method=0);
	void ShrinkSurfaceSymm(Vector3D Pos1,float Radius1,Vector3D Pos2,float Radius2,float Dist);		
	void SetSurfClay(Vector3D Pos,float Radius,float D);
	void SetSurfPlane2(Vector3D Pos,float Radius,Vector3D Dir,float Softness);
	void SetSurfPlaneSymm(Vector3D Pos,float Radius,float D=0,Vector3D Dir=Vector3D::Zero,float SmDegree=0);
	void StrongSmooth(Vector3D Pos,float Radius,float SmDegree,int SmType);
	void MoveSurfaceSymm(Vector3D Start,float Radius,Vector3D Dist,bool Additive);
	void WrapCell(int cx,int cy,int cz);
	void WrapCell2(int cx,int cy,int cz,VolumeObject* AdditionalSource);
	void GrowDencity();
	void SetEmplty();
	void Symmetry();
	void CleanSurface();
	void LegacyFix();
	void Decompose(int MinCluster,int DelSize); ///< Separate loose parts
	void DeleteHidden();
	void Decimate();
	bool DecimateEx(float Degree,bool Undo,float* rk);
	void Shell(); ///< Global operators
	void Bevel();
	void RemoveSelfIntersections();
	void CreateFone(uni_hash<_empty, bi_DWORD>& fone);
	///if maxcontour == 0 it just returns (HolesCount,MaxHole)
	cVec2i CloseHolesFastAndGood(bool weld, int maxcontour = 100000);
	void CloseSurfHoles(bool interp = true, int type = 0, float Accuracy = 0.22,int MaxContourLength=10000000);
	void EstimateHoles(int& MaxHole,int& MinHole,int& NHoles);
	void RenderAO(bool RenderPMS=false);
	void DelUnused();
	void HideInRadius(Vector3D Pos,float Radius, bool Hide);
	void HideInRadiusSymm(Vector3D Pos,float Radius, bool Hide);
	void MarkFreezeInSurfMode(Vector3D Pos,float Radius,Vector3D Pos1,float Radius1,bool Inv,float Degree,float Degree1,bool Additive);
	void MarkFreezeInSurfModeSymm(Vector3D Pos,float Radius,Vector3D Pos1,float Radius1,bool Inv,float Degree,float Degree1,bool Additive);
	void SmoothFreezeInSurfMode(Vector3D Pos,float Radius,float Degree);
	void SmoothPoseInSurfMode(Vector3D Pos, float Radius, float Degree);
	void ExpandFreezeInSurfMode(Vector3D Pos,float Radius,bool inv);
	void SmoothColorInSurfMode(Vector3D Pos,float Radius,float Degree,int count=1);
	void SmoothColorInVoxelMode(Vector3D Pos, float Radius, float Degree, int count = 1);
	void SmoothCavityInSurfMode(int count, float SharpDegree, float SmoothDegree);
	void SmoothFreezeInSurfModeSymm(Vector3D Pos,float Radius,float Degree);
	static void SmoothFreezeInPaintRoom(Vector3D Pos,float Radius,float Degree);
	void InvertSurfFreeze();
	static void InvertPoseSelection();
	static bool ApplyPoseSelection();
	void UpdateDirtyPoseSelection();
	void ConvertPoseSelectionToFreeze();
	void UnfreezeSurf();
	VoxType* AllocVox();
	VoxType* AllocVox(VoxType Filler);
	void FreeVox(VoxType* vc);
	VolumeCell* AllocCell();
	void FreeCell(VolumeCell* vc);
	Vector3D CreateSegSelection(Vector3D P1,Vector3D P2,Vector3D EyeDir,PickedPool& PP,Matrix4D& LSP,int Mode,int SubMode);
	Vector3D CreateRectSelection(Vector3D EyeDir,PickedPool& PP,Matrix4D& LSP,int Mode,int SubMode,bool FreezeOnly,float WeightMod=1.0);
	Vector3D CreateSegSelectionSymm(Vector3D P1,Vector3D P2,Vector3D EyeDir,PickedPool& PP,Matrix4D& LSP,int Mode,int SubMode);
	Vector3D CreateRectSelectionSymm(Vector3D EyeDir, PickedPool& PP, Matrix4D& LSP, int Mode, int SubMode, bool FreezeOnly, float WeightMod = 1.0);
	Matrix4D GetMainAxis(bool UseFreeze,bool InvFreeze,bool UseSymm,Vector3D RefPoint);
	Matrix4D GetSelBasis(bool UseFreeze,bool InvFreeze,bool UseSymm,Vector3D RefPoint);
	void ExtrudeSurfInRect(Vector3D EyeDir,float Dist,int AvgNormal);
	void ExtrudeSurfInRectSymm(Vector3D EyeDir,float Dist);
	void ClearSegSelection(PickedPool& PP,bool Remesh=false,bool Undo=false);
	void ApplyPenSelection(Vector3D P, float R,bool Mode,float Transparency);
	void ApplyPenSelectionSymm(Vector3D P, float R,bool Mode,float Transparency);
	void PrintMemUsageReport();
	void CopyTo(VolumeObject* Dest,bool Undo=true);
	void DecomposeTo(VolumeObject* Dest,uni_hash<int,DWORD>& conid, bool Undo = true,int keepval = -1);
	void MergeToOtherVO(VolumeObject* VO,int Sub=false);
	void MergeToThisVO(Matrix4D ExtraTransform,bool ClearThis,bool NoUndo=false);
	void MergeVOSset(cList<VORenderQueue>& RQ,bool ClearThis,bool NoUndo=false);
	void PlainMergeVOSset(cList<VORenderQueue>& RQ, bool ClearThis, bool NoUndo = false);
	void ExtrudeVO(float Value,int Sub=0,bool Clr=false,bool forcevox=false);
	void CreateShell(float Value);
	void MakeHull(int L);
	void MergeHullToOtherVO(VolumeObject* VO,float In,float Out,bool ReScale);
	///Remove parts, connected to nearest point
	void RemoveConnectedParts(Vector3D pt, AABoundBox& remBB, float MaxRadius);
	void DetectConnectedParts(Vector3D pt,cList<Vector3D>* Points,float Radius);
    /**
    \brief Throw to `cMeshContainer`.\n
    For example
    \code
    comms::cMeshContainer  mc;
    this->ToRawMesh( true, true, &mc, Matrix4D::Identity, false );
    \endcode
    \todo Note unobvious params.
    */
	bool ToRawMesh(bool Weld,bool OnlyThis,comms::cMeshContainer* mesh,Matrix4D SingleM,bool Optimize,float OptDegree=0,bool CreateOnlyOptimizedMesh=false,bool OnlySel=false, int FixedPolycount = 0, bool SkipFactures = false);
	bool ToSTL(bool OnlyThis, BinStream& BS, Matrix4D SingleM = Matrix4D::Identity, bool OnlySel = false);
	bool ToReducedRawMesh(bool Weld,int DesiredPolyOutput,bool OnlyThis,comms::cMeshContainer* mesh,Matrix4D SingleM=Matrix4D::Identity);
	void GetVoTNB(Vector3D& T,Vector3D& N,Vector3D& B,bool R);
	void RestoreFromBackup();
	void Flip(bool x,bool y,bool z);
	void MakeUniform(bool global);
	void ExportRawVoxels(const char* File,int bits,bool CreateHeader, bool color, bool gloss, bool layers);
	void ImportRawVoxels(const char* File,int offset,int bits,int Lx,int Ly,int Lz,float Scale);
	bool EstimateInitialParameters(const char* File,int& offset,int& bits,int& Lx,int& Ly,int& Lz);
	static void ExportRawVoxelsWithDialog();
	static void ImportRawVoxelsWithDialog();
	VolumeObject* SplitInTwo(bool InsertInTree,bool EraseOld,bool subtree=false,bool changetool=true);
	void HideVoxRect(bool Hide);
	void UnhideAllVoxels();
	void SeparateHidden();
	void ToCache();
	void FromCache();
	void FromCacheEx();
	VolumeCell* ApplySketchToCell(int x,int y,int z);
	void CreateSketch(int num_steps=2,float Softness=0);
	comms::cMeshContainer* CreateClone(Vector3D* Center,bool Cut);
	void Barelief(Vector3D Org, Vector3D Dir, float Coef, bool FreeEdges = false, float Tapering = 0, bool KeepScale = false, bool Undo = true, float ExDensity = 1.0, bool KeepBottom = false);
	void LegacyBarelief(Vector3D Org, Vector3D Dir, float Coef, bool FreeEdges = false, float Tapering = 0, bool KeepScale = false, bool Undo = true, float ExDensity = 1.0, bool KeepBottom = false);
	void RemoveUndercuts(Vector3D Start, Vector3D Dir,float Tapering,bool KeepBottom=false);
	void DirectionalNormalsSmoothing(Vector3D LocalDir, float divirvence);
	void CutUnderPlane(Vector3D Start,Vector3D Dir);
	void RemoveInvisibles();
	void ToSurfMode(bool ask=false);
	void ToVoxMode();
	void SurfSmoothAll();
	void SmoothOpenEdgesDialog();
	void SmoothOpenEdges(int times);
	void SurfIdeal();
	void CloseInnerHoles();
	void RemoveIndexedStructure();
	void CreateIndexedStructure(); ///< fills GlobalVertIndices for every cell, assigns global index for each vertex
	void CreateIndexedStructure2(); ///< fills GlobalVertIndices for every cell, assigns global index for each vertex, the difference is that this function makes job basing on coordinates of vertices
	void CreateAdjacent();
	void MergeRegularMesh(comms::cMeshContainer* mc, const Matrix4D& M, int SubObj, bool upd = true);
	void MergeRegularMesh(BasicMesh* mc,bool Inv);
	void CreateGlobalVoxAABB(const AABoundBox& AB,bool Subtrct);
	void SubdivBkCellsIfNeed();
	void SubdivAllCells();
	void FixVCLayersErrors();
	void FixVCLayersErrors(VolumeCell* vc);
	void PerformVolumeCSG(fnScalarField* Fiels,fnPointsGenerator* gen);
	void SurfaceRectCut(Matrix4D& T, int symidx = -1);
	void SurfaceRectCloseHole(Matrix4D& T);
	void SurfaceRectMakeHole(Matrix4D& T);
	void BooleanMerge(BasicMesh* bm,int sub);
	void BooleanMerge(comms::cMeshContainer* mc,int sub,const Matrix4D& m,int SubObj,bool SkipWeld=false,bool SkipSplit=false);
	void SurfaceRectCut2(fnScalarField* Field, fnProjFunction* ProjField);
	void SurfaceRectCloseHole2(fnScalarField* Field);
	void SurfaceRectMakeHole2(fnScalarField* Field);
	void CheckLinearFit();
	void RemoveUnusedVerts(VolumeCell* vc);
	void RemoveUnusedVerts();
	static void RemoveUnusedVertsForAllVolumes();
	void ReorderCells(bool Undo=true,bool Subcells=true);
	void CheckGlobals();
	void ChecAttr();
	void OptimizeTables();
	void CheckDupIds();
	void OptimizeIndicesUsage();
	Vector3D GetCavityLayer(VolumeCellAttrib* vca,int vidx);
	float GetAOLayer(VolumeCellAttrib* vca,int vidx);
	void Reproject(const Vector3D& Center, float Radius, const Vector3D& Direction, const Vector3D& T, const Vector3D& B, int method, int normalsource, float deepdeg, bool reprojectcolor);
	void Reproject(float InDistance, float OutDistance, int method, bool reprojectcolor);
	void CalculateAllNormals();
	float CalcSquare();

	static void EnsurePaintLayer();
	void PaintInVolume(PointsStory& points, const std::function<bool(const Vector3D&, VolumePaintContext&, int)>& op);
	static bool AutoPaintInVolume(const char* operation);
	static bool AutoRectInVolume(const char* operation);
	static void RegisterVolumePainter(const char* id, std::function<bool(const Vector3D&, VolumePaintContext&, int)> fn, std::function<bool(const Vector3D&, VolumePixelContext&, int)> rect);
	static void VoxelPaintInRectSelArea(cList<OneSelPoint>& points, const std::function<bool(const Vector3D&, VolumePixelContext&, int)>& op);

	void SplitByCurve(OneCurveObject* cu, float Thickness = 0, int method = 0);
	void SplitRich(OneCurveObject* cu);
	void MakeBevelOverCurve(OneCurveObject* cu);
	void FunctionalSplit(cList<Vector4D>& start, std::function<float(const Vector3D&)> fn, cList<int>* resultEdges = nullptr);
	void SplitByTubes(const cList<cList<Vector4D>>& tubes, const cList<float>& radiusmods);

	Vector3D GetClosestCell(const Vector3D& pt, bool Global);
	void SurfSubdiv(SubdCalcGraph& calcGraph, bool layers = true, bool scale = true, bool linear = false);
	void StepUp(bool scale2x=true, std::function<void()> subd_postprocess = nullptr);
	void StepDown(bool skipChanges = false);
	void ClearSubdLevels();
	bool TestMultiresolution(const char* message = nullptr);
	bool CheckIfMultiresolutionUsed();
	bool TopologyLocked();
	void CreateOptimalMesh(comms::cMeshContainer& result);
	void CollapseBooleans();
private:
    /**
    \brief All methods below we are use for run modal windows from the scripts.
    \param p  1 - first button (OK), 2 - second button (Cancel) and so on depending on opened window.
    \see SurfSmoothAll()
    */
    static void doSurfSmoothAll( int p );
};

class APICALL SmoothParams :public BaseClass {
public:
	SmoothParams() {
		SmoothingDegree = 1.0;
		Tangent = false;
		Relaxation = false;
		KeepSharpEdges = true;
		KeepOpenEdges = false;
	}
	float SmoothingDegree;
	bool Tangent;
	bool Relaxation;
	bool KeepSharpEdges;
	bool KeepOpenEdges;
	bool InvertFreeze;
	SERIALIZE_LATER();
};
