#pragma once


struct APICALL VolumetricLayer {
	short LayerID;
	short DataType;//0-color, 1-gloggs/metall/opacity, 2-facture
	DWORD Values[9 * 9 * 9];
	DWORD GetInterpolatedValue(const Vector3D& v);
	DWORD GetDirectValue(const Vector3D& v);
	Vector4D GetInterpolatedValueV4(const Vector3D& v);
	void* operator new (size_t);
	void operator delete(void* ptr, size_t size);
};
/**
\brief Contains voxel values.
\details
Each volume / surface object consists of cells. In case of voxels all cells has same width
in space - 8 voxels, array of voxels is 9x9x9 - last, 9's is from right neighbour cell.\n
In voxel mode you are operating with voxels, surface will be generated by voxels using marshing cubes.\n
In case of surface there is no voxel data (polygons / layers / colors) are kept in `VolumeCellAttrib`.
*/
class APICALL VolumeCell{
public:
	VolumeCell(VolumeObject* Ow);
	~VolumeCell();
	void Destroy();	
	void Destroy2();
    /**
    \brief Represents cell's polygonal surface.
    \details
    If it is `nullptr`, there are no faces in the cell.
    */
	VolumeCellAttrib* Attr;
	VolumeObject* Owner; ///< owner - who refers this cell
    /**
    \brief Cells before this change.
    \details
    Undo will get to this state when applied.
    */
	int BackupDropTick;
	VolumeCell* Backup;
	VoxType* Temp; ///< used as temp storage for voxels for some tools 
    /**
    \brief Pointer to voxels array 9x9x9.
    \details
    Voxel values itself, <=32767 - empty space, >=32768 - filled space.\n
    For details, it may be zero if all voxels are the same. In this case `SameValue` contains
    this same value. Surface is determined by the value 32767 using marching cubes.
    */
	VoxType* Values;
	cList<VolumetricLayer*> Layers;
    /**
    \details
    If cell is completely filled or empty and `Values == nullptr` the value is used as cell filler.
    */
	VoxType SameValue;
	float boolean_hash;
	WORD RenderStamp; ///< if differs from other cells something happened and cell's mesh should be rebuilt	
	bool HaveEmpty:1; ///< has some emty space in cell - only for voxel mode
	bool HaveFilled:1; ///< has filled spave, some alues are above 32767		
	bool IsDirty:1; ///< mesh should be updated
	bool IsExplicit:1; ///< cell is unpacked even if trivial, used temporary for operations, cell should be compactified after all dids
	bool ToErase:1; ///< cell should be erased
	bool ToFill:1;
	bool Hidden:1; ///< cell hidden from render	
	bool Locked:1; ///< cell is locked for changes, rather  used for temporary purposes
	BYTE Nx;	///< usually = 9, Cell is (Nx * Nx * Nx)

	void AllocAttributes();
	void FreeAttributes();
	void TryToFreeAttributes();

	void Compact(bool FreeCell=true,bool Multithread=false);
	void Compact8();
    ///< \param WhatTodo  1 - allocate, 2 - fill, 3 - all
	void Explicit(int WhatTodo=3,bool Multithreaded=false);
	void CalcAB(CompactArray<MCVertex>& VS);
	void CalcABC();
	void UpdateRect(int RStamp);
	void FreeVolLayers();
	VolumetricLayer* GetVolumetricLayer(int LayerID, int type, bool create);
};