#pragma once

#ifndef _COREAPI
#include "PopupWindows.h"
#include "ItemFolders.h"
#endif

#define spcFreeze 1

struct MCVertex {
	Vector3D Pos;
	Vector3D Normal;
	word Status;
	word Freeze;
	static int FreezeSafe;
	inline void freeze(int f) {
		if (FreezeSafe == 0) {
			if (f == spcFreeze)f = 0;
			if (Freeze != spcFreeze)Freeze = f;
		}
		else {
			if (f != Freeze) {
				if (f >= spcFreeze)f = spcFreeze;
				else f = 0;
				Freeze = f;
			}
		}
	}
};

struct DirField{
	Vector3D Pos, T, B;
	float u, v;
};
class APICALL MiniMesh{
public:
	cList<DirField> Field;
	cList<int> Triangles;
	void CalcUV();
	void Save(const char* name);
	void Load(const char* name);
	void Clear();
};
class OneFacture;
struct APICALL MeshItem{
	~MeshItem();
	int TexID;
	int L;
	OneFacture* F;
	simple_hash<int,bi_DWORD,1024> vhash;
	int GetLocalIndex(int GlobalIndex, int Subset);
	cList<int> Triangles;
	cList<comms::VertexTBNC> Verts;
};
class APICALL MeshCollector{
public:
	cList<MeshItem*> Items;
	MeshCollector();
	~MeshCollector();
	MeshItem* GetMesh(int TexID,int Lr);
};
struct APICALL nBasis{
	nBasis(){}
	nBasis(const Vector3D& N);
	Vector3D n, t, b;
};
struct ShortVector{
	byte Direction;
	short Value;
	Vector3D get(const nBasis& b);
	Vector3D get_normalized(const nBasis& b);
	void set(const nBasis& b,const Vector3D& T);
};

/// For facture.
struct APICALL TexturedVertex{
	/// Reference to texture ID.
    /// native
	WORD TexID;
	ShortVector Tangent;
	ShortVector Binormal;
	byte Opacity;
	WORD Subset;
    /**
    \brief Type of mapping.
    \details
    - 0 - custom
    - 1-6 - cubemap
    */
	byte Mapping;
	float u, v;

	struct BakedPixels {
		Vector4D Color;
		Vector3D N;
		float gloss;
		float metall;
		float gm_opacity;
	};

	void GetCubemapTangents(Vector3D& T, Vector3D& B, OneFacture* F);
	void CalcSubset(const Vector3D& Pos, const Vector3D& N, OneFacture* F);
    /**
    \brief Map point in correspondence to the current facture settings.
    \details Use when drawing.
    \param Pos Position.
    \param N Normal.
    \param F Reference to facture.
    */
	bool map_vertex(const Vector3D& Pos, const Vector3D& N, OneFacture* F, bool anyway);
    /// Assign cubemap mapping.
	bool MapVertex(const Vector3D& Pos, const Vector3D& N, const Matrix4D& LocalToWorldM, OneFacture* F, float& ColorWeight, float& FactureWeight);
    /// Assign directional mapping.
	bool Directional(const Vector3D& Pos, const Vector3D& Pos0, const Vector3D& N, const Vector3D& Dir, float startU, OneFacture* F);
    /// In correspondence with Mapping field.
	cVec2 Extrapolate(const nBasis& b, const Vector3D& Pos, const Vector3D& Pos0);
	static void AddMesh(VolumeCellAttrib* vca, MeshCollector& mcl, const Matrix4D& Transform=Matrix4D::Identity);
	static void Mix(TexturedVertex* res, TexturedVertex** tvs, MCVertex** vs, float* weights, int nelm);
	static void SplitSubsetsIfNeed(VolumeObject* VO, BigDynArray<tri_DWORD>& List);
	static std::function<bool(TexturedVertex* T, const Vector3D& Pos, const Vector3D& N, const Matrix4D& LocalToWorldM, OneFacture* F, float& ColorWeight, float& FactureWeight)> CustomMapper;
	void Bake(const Vector3D& pos, const Vector3D& pos0, const Vector3D& N, float pixelSize, BakedPixels& out);
};
struct APICALL LayeredTexturedVertex :public TexturedVertex{
	int LayerID;
};

class APICALL TexturedVerticesContainer{
public:
	uni_hash<LayeredTexturedVertex, int> Verts;
	uni_hash<int, int> vnv;
	bool IsEmpty;
	LayeredTexturedVertex* GetVertex(int Vertex);
	LayeredTexturedVertex* GetVertex(int Vertex, int Layer);
	void AddTriangle(int v1, int v2, int v3);
};

class TexturePattern;
/// Facture.
class APICALL OneFacture :public BaseClass{
public:
	OneFacture();
	~OneFacture();

	static BigDynArray<TexturePattern*> tp;

	int GUID;
	int OrderIndex;
	HashSummator HashVal;
	cStr fPath;
	cStr fFolderName;
	cStr fColorTexture;
	cStr fGlossTexture;
	cStr fRoughnessTexture;
	cStr fMetall;
	cStr fNormalmap;
	float Aspect;
	cStr FactureName;

	int tPreviewTexture;
	int tColorTexture;
	int tGlossTexture;
	int tRoughnessTexture;
	int tMetall;
	int tNormalmap;
	bool ApplyFactureImmediately;
	bool FlipT;
	bool FlipB;
	bool SwapTB;
	bool Temporary;
	float fScale;
	float fRotation;
	float fUShift;
	float fVShift;
	float fBumpness;
	float fRoughnessMod;
	float fGlossMod;
	float fMetallMod;
	bool UseOnlyAsSplash;

	bool fUseJitters;
	float fRotationAmplitude;
	float fScalingAmplitude;
	float fUJitter;
	float fVJitter;

	short CurrJitterValue;
	float fCurrRotation;
	float fCurrScaling;
	float fCurrDU;
	float fCurrDV;

	void FindTexture(cStr& tex);

	bool fUseConditions;
	bool fOnCavity;
	float fDegreeOnCavity;
	bool fOnConcave;
	float fDegreeOnConcavity;
	bool fOnTop;
	float fDegreeOnTop;
	bool fOnBottom;
	float fDegreeOnBottom;
	bool fOnSides;
	float fDegreeOnSides;

	int LastPreviewUpdTime;
	int LastParamChangeTime;

	void Activate();
	void Deactivate();
	void Invalidate();
	void ActualizePreview();
	
	HashSummator CalcHash();

    /**
    \details
    - 0 - uniform random cubemapping
    - 1 - cyllinder around `y`
    */
	int fDefaultMapping;
	static bool DizableGizmo;
	SERIALIZE_LATER();
	virtual bool ProcessInEditor(BaseClass* Parent) override;
	virtual bool OnChangeMember(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName);
	static void ApplyToVolume(VolumeObject* vo, int FactureType);
	static void ApplyToChangedCells(VolumeObject* vo, int FactureType);
	void RefreshCellsWithThisFacture();
	static TexturePattern* tex(int texID);
	void MakeGreyInAverage();
	void NormalizeBrightness();
	void AutoNormalMap();
	void ToDistro();
	void Store();
};


/// Folder of factures.
class APICALL FacturesFolder :public ItemsFolder{
	static cList<OneFacture*>	gFacturesList;
    /// In current folder.
	static cList<OneFacture*>	Locals;
public:
	static void					AddToList(OneFacture* F);
	static void					RemoveFromList(OneFacture* F);
	
	static  int					CurFacture;
	void						LoadAll();
	void						SaveAll();
	static OneFacture*			Find(int guid);
	static void					AddToLocals(OneFacture* F);
	static void					ClearLocals();
	static void					RemoveFromLocals(int idx);
	static OneFacture*			GetLocal(int idx);
	static int					LocalsCount();
	static OneFacture*			get(int gidx);
	static int					getCur();
	static int					GetGlobalsCount();

	virtual const char*         GetRootPath();
	virtual const char*         GetSearchExtension(int idx);
	virtual void                InitItems();
	virtual void                AddItem(const char* path);
	virtual const char*         GetItemName(int idx);
	virtual void                RemoveItem(int idx);
	virtual const char*         GetItemExtraName(int idx, int exidx);
	static int					FindOrAddFacture(const char* color, const char* gloss, const char* roughness, const char* metall, const char* normal);
};
class APICALL FactureProperty :public PopupWindow {
public:
	virtual BaseClass* GetClass();
	virtual const char* GetWindowID() { return "FactureProperty"; }

};
FacturesFolder& FFolder();