#pragma once

class Vector3DH {
public:
	Vector3DH() {
		dir = 0;
	}
	Vector3DH(const Vector3D& V, float cSize = 32.0) {
		x = short(floorf(V.x * cSize + 0.5f));
		y = short(floorf(V.y * cSize + 0.5f));
		z = short(floorf(V.z * cSize + 0.5f));
		dir = 0;
	}
	union {
		struct {
			short x, y, z, dir;
		};
		DWORD DW;
	};
	operator DWORD() {
		return dir + (y << 14) + (z << 24) + (x << 4);
	}
	bool   operator == (const Vector3DH& c) const {
		return c.x == x && c.y == y && c.z == z && c.dir == dir;
	}
};

struct VLink {
	Vector3D OPos;
	Vector3D NPos;
	Vector3D NNorm;
	Vector3D ONorm;
	union {
		Vector3D* TempDisp;
		Vector4D* TempDisp4;
	};
	Vector3D Init;
	DWORD Flags;
};

struct PickedVertexLink {
	VolumeCell* pCell;
	int VertexIndexInCell;
	int VertexIndexInPool;
};

typedef float fnGetValueInVolume(Vector3D Pos);
typedef cVec2 fnGetValueInVolumeW(Vector3D Pos);
typedef void fnGetSurfDisp(const Vector3D& Old, Vector3D& New, word Freeze, const Vector3D& ONorm);
typedef void fnGetSurfDisp2(const Vector3D& Old, Vector3D& New, Vector3D& NNew);
typedef void fnGetSurfDisp3(const Vector3D& Old, Vector3D& New, DWORD F);
typedef void fnGetSurfDisp4(VLink& VL, word Freeze);
typedef void fnGetSurfDispUniv(MCVertex* Cur, MCVertex* Prev, MCVertex* Init);

//operations over picked set of vertices

class APICALL PickedPool{
public:
	struct context {
		VolumeObject* vo;
		VolumeCell* vc;
		int curcx;
		int curcy;
		int curcz;
	};
	int SmoothDir;
	uni_hash<DWORD,Vector3DH,43261,2048> Hash;
	void ClearTemp();
	cList<VLink> Verts;
	cList<int> Ids;
	uni_hash<DWORD,tri_DWORD,33461,512> UsedCells;
	cList<PickedVertexLink> Links;

	void CheckNormals();

	void SetContext(context& co, VolumeObject* VO,VolumeCell* VC,int cx,int cy,int cz);
	int AddVertex(context& co, int IndexInCell,VLink& mv,bool AddLink=true);
	VLink* GetVertex(context& co, int IndexInCell);
	int AddVertex2(context& co, int IndexInCell,VLink& mv,bool AddLink=true);
	VLink* GetVertex2(context& co, int IndexInCell);
	void CalcNormals();
	void Upload(VolumeObject* vo);
	void Apply(fnGetSurfDisp* fn2,VolumeObject* vo);
	void Apply(fnGetSurfDisp2* fn2,VolumeObject* vo);
	void Apply(fnGetSurfDisp3* fn2,VolumeObject* vo);
	void Apply(fnGetSurfDisp4* fn2,VolumeObject* vo);
	void Apply(std::function<void(const Vector3D&, Vector3D&, DWORD)> fn2, VolumeObject* vo);
	void Apply(std::function<void(VLink& v)> fn, VolumeObject* vo);

	void Smooth(Vector3D Center,float Radius,float Degree);
	void SuperSmooth(VolumeObject* vo, Vector3D Center,float Radius,float Degree);
	void Smooth2(Vector3D Center,float Radius,float Degree);
	void SmoothSelection(Vector3D Center,float Radius,float Degree,VolumeObject* vo);
	void SmoothSelectionSymm(Vector3D Center,float Radius,float Degree,VolumeObject* vo);
	void SmoothWhole(VolumeObject* vo, int n);
	void CreateFromBitset(VolumeObject* vo,VolumeBitSet& bs,bool toUndo,bool OnlyWithFlag);
	void CreateFromVO(VolumeObject* vo, bool toUndo,bool OnlyWithFlag);
	void SmoothExisting(int times,float deg);
};