#pragma once

//operating over the set of pickes cells. Usually used for surface operation

struct PickedCell{
	PickedCell(){};
	PickedCell(VolumeCell* v, int x, int y, int z){
		cx = x; cy = y; cz = z; vc = v;
	}
	VolumeCell* vc;
	int cx, cy, cz;
};
class HalfEdgeMeshVox;
class VectorBuffer{
	static cList<Vector4D*> buf;
	static cList<byte*> bufB;
	static int NChunks;
public:
	static void EnsureSize(int size){
		int nc = (size + 65535) >> 16;
		for (int k = NChunks; k < nc; k++){
			Vector4D* v4 = new Vector4D[65536];
			memset(v4, 0, sizeof(Vector4D) * 65536);
			buf.Add(v4);
			byte* v1 = new byte[65536];
			memset(v1, 0, 65536);
			bufB.Add(v1);
		}
		if (nc > NChunks)NChunks = nc;
	}
	static __inline Vector4D& v4(int pos){
		assert(pos >= 0 && pos < NChunks * 65536);
		return buf[pos >> 16][pos & 65535];
	}
	static __inline Vector3D& v3(int pos){
		assert(pos >= 0 && pos < NChunks * 65536);
		return buf[pos >> 16][pos & 65535].ToVec3();
	}
	static __inline byte& Byte(int pos){
		assert(pos >= 0 && pos < NChunks * 65536);
		return bufB[pos >> 16][pos & 65535];
	}
};
class APICALL CellPickPool{
public:
	VolumeObject*			vo;
	Vector3D				pos;
	float					r;
	cList<PickedCell>	Pool;
	int						Nv;
	Vector3D				N0;
	uni_hash<MCVertex*,cube_EDGE,31773,1024> es;

	CellPickPool();
	void Create(Vector3D Pos,float R,VolumeObject* vo,fnGetSurfDisp4* fn4=NULL,fnGetSurfDisp2* fn2=NULL,bool PreCalcNormals=false,int tIdx=0,int nIds=1, Vector3D dir = Vector3D::Zero);
	void CreateTM(VolumeObject* vo);
	void CreateFromRectSelection(VolumeObject* vo,const Matrix4D& m);
	void CreateTMGlobal(VolumeObject* vo,const Matrix4D& m_);
	void CreateTMOffset(VolumeObject* vo,float ExR, bool backup = false);
	void CreateOffset(VolumeObject* _vo,float R, Vector3D P, float exr);
	void AddCell(VolumeObject* vo,const tri_DWORD& T,VolumeCell* vc);
	void CreateMT(Vector3D Pos,float R,VolumeObject* vo,fnGetSurfDisp4* fn4=NULL,fnGetSurfDisp2* fn2=NULL,bool PreCalcNormals=false);
	void Apply(fnGetSurfDisp4* fn4);
	void Apply2(fnGetSurfDisp4* fn4,int i,int n);
	void PreCalcSurfNormals(bool ZeroNormals = false, bool MagnifyNormals = false);
	void ApplyUniv(fnGetSurfDispUniv* uni);
	void ApplyUniv2(fnGetSurfDispUniv* uni,int i,int n);
	void Apply(fnGetSurfDisp* fn);
	void Apply2(fnGetSurfDisp* fn4,int i,int n);
	void Apply(fnGetSurfDisp2* fn2);
	void Deform(std::function<void(MCVertex* cur, MCVertex* backup)> fn);
	void CalcSurfNormals();
	void FastNormals();
	void FastGidWeld();
	void Smooth();
	void PostCalcSurfNormals();
	void ApplySmooth(float deg,float TangentTegree,UnlimitedBitset* Selected);
	void DrawDbg(DWORD Color);
	void DbgNormals();
	static void DrawDbgCell(VolumeCell* vc,const Matrix4D& m,DWORD Color,bool aabb,bool points);
	void DrawDbgFlag(DWORD Color, UnlimitedBitset& bs);
	void ToHalfEdges(HalfEdgeMeshVox* he);
	void FromHalfEdges(HalfEdgeMeshVox* he);
	void SubdivCellsIfNeed(int minv = 0);
	void RefineMesh();
	void Clear();
	bool CheckIfDense();
	void DebugMarkInitialEdges();
	void DebugSeekSmallContours();
	void TestUniqueGlobalIds();
};