#pragma once
#ifndef C_EX_ACTION
#define C_EX_ACTION

class APICALL cExAction {
public:
	std::string _name;
	std::string _hint;
	std::string _extension;
	std::string _message;
	cExAction(const char* name, const char* extension, const char* message, const char* hint = "") {
		_name = name;
		_hint = hint;
		_extension = extension;
		_message = message;
	}
};

class APICALL LinkedObjectBaseType {
public:
	static comms::cList<LinkedObjectBaseType*> LinkedObjectBaseTypes;
	static void registerObjectType(LinkedObjectBaseType* objectType);

	LinkedObjectBaseType() {};

	virtual void OnModifyTreeItem(const char* Name, BaseWidget* BW) {};
	std::vector<cExAction> actions;
	void addAction(const char* extension, const char* name, const char* message = "", const char* hint = "");
	void clearActions();
	std::string objectType; // extension for file
	int IconTexture;
	void setIconTexture(int textureID) { IconTexture = textureID; };
	void setObjectType(const char* object_type) { objectType = object_type; };
};


class APICALL LinkedObject: public BaseClass {
private:
	LinkedObjectBaseType* _linkedObjectType = nullptr;
public:
	LinkedObjectBaseType* getType();
	int idx;
	float Scaling;
	comms::cStr objectPath;
#ifndef PY_PARSER


	SERIALIZE() {
		REG_AUTO(Scaling);
		REG_AUTO(objectPath);
	}
#endif // ! PY_PARSER
};


void _cExAction_Exec(cExAction* ex_action);

#endif