import coat, os
from PIL import Image, ImageDraw, ImageFilter


scale=8
R=coat.ui.scale()*2
R0=R
R*=scale

image = Image.new("RGBA", (64*scale, 64*scale), (0, 0, 0, 0)) 
draw = ImageDraw.Draw(image)

def tup(x,y,w,h):
    return (x*scale,y*scale,(x+w)*scale-1,(y+h)*scale-1)

def newimage():
    draw.rectangle((0,0,64*scale-1,64*scale-1),fill=(0,0,0,0))

def save(name):
    os.makedirs(coat.io.documents("data/textures/Frames24"),exist_ok=True)
    im2 = image.resize((256,256),Image.LANCZOS)
    im4 = image.resize((128,128),Image.LANCZOS)
    im4.save(coat.io.documents("data/textures/Frames24/"+name+".tga"))
    image.save(coat.io.documents("data/textures/Frames24/"+name+"_4x.tga"))
    coat.utils.signal(name+".tga")

def roundedBox(bound,fill, radius = R, edges = (1,1,1,1)):
    x1,y1,x2,y2 = bound
    r=radius
    if r > (x2-x1)/2: r = (x2-x1)/2
    if r > (y2-y1)/2: r = (y2-y1)/2
    draw.rectangle((x1+r,y1,x2-r,y2),fill=fill)
    draw.rectangle((x1,y1+r,x2,y2-r),fill=fill)
    draw.ellipse((x1,y1,x1+2*r,y1+2*r),fill=fill)
    draw.ellipse((x2-2*r,y1,x2,y1+2*r),fill=fill)
    draw.ellipse((x1,y2-2*r,x1+2*r,y2),fill=fill)
    draw.ellipse((x2-2*R,y2-2*r,x2,y2),fill=fill)
    if edges[0] == 0: draw.rectangle((x1,y1,x1+r,y1+r),fill=fill)
    if edges[1] == 0: draw.rectangle((x2-r,y1,x2,y1+r),fill=fill)
    if edges[2] == 0: draw.rectangle((x1,y2-r,x1+r,y2),fill=fill)
    if edges[3] == 0: draw.rectangle((x2-r,y2-r,x2,y2),fill=fill)

# draw 90deg arc, sector is 0..3, center is (x,y)
def arc(center,fill,sector) :
    rect = (center[0]-R,center[1]-R,center[0]+R,center[1]+R)
    draw.arc(rect,sector*90,sector*90+90,fill = fill)    

def line(x1,y1,x2,y2,fill):
    draw.line((x1,y1,x2,y2),fill=fill)

def shadow(bound,fill):
    global image,draw
    roundedBox(bound,fill)
    image = image.filter(ImageFilter.BoxBlur(24))
    draw = ImageDraw.Draw(image)

    

delta = 0.5
roundedBox(tup(8,8,64-16,64-16),(64,64,64,255))
roundedBox(tup(8 + delta,8 + delta,64-16-delta*2,64-16-delta*2),"grey")
save("button")
save("class_buttons")
save("input")
save("combo_inner_frame")

newimage()
roundedBox(tup(8,8,64-16,64-16),(64,64,64,255),edges=(0,1,0,1))
roundedBox(tup(8 + delta,8 + delta,64-16-delta*2,64-16-delta*2),"grey",edges=(0,1,0,1))
save("start_menu_active")

newimage()

rr = R
R = 1
roundedBox(tup(7.5,12,1,40),(128,128,128,128))
#roundedBox(tup(32+16+8,13,2,38),(128,128,128,80))
save("tabbutton_inactive")
R=rr

newimage()

shadow(tup(8,8,64-16,64-16),(0,0,0,64))
roundedBox(tup(8,8,64-16,64-16),(64,64,64,255))
roundedBox(tup(8 + delta,8 + delta,64-16-delta*2,64-16-delta*2),"grey")
save("menu")
save("combo_dropdown")

newimage()

filler = (128,128,128,255)
dy = 0
dy1 = 0
dx = -2
roundedBox(tup(8+dx,8+dy,64-16-2*dx,64-16),"white")
roundedBox(tup(8+dx,8+dy1+dy,64-16-2*dx,64-16-dy1),filler)
roundedBox(tup(-8,32,64+16,24+dy),filler)
roundedBox(tup(-28,0,36+dx,56+dy),(0,0,0,0))
roundedBox(tup(56-dx,0,36,56+dy),(0,0,0,0))

dark = (64,64,64,255)
ddy=dy*scale

arc((8*scale+R+dx*scale,8*scale+R+ddy),dark,2)
arc((8*scale+R+1+dx*scale,8*scale+R+ddy),dark,2)
arc((8*scale+R+1+dx*scale,8*scale+R+ddy+1),dark,2)

arc((56*scale-R-1-dx*scale,8*scale+R+ddy),dark,3)
arc((56*scale-R-1-1-dx*scale,8*scale+R+ddy),dark,3)
arc((56*scale-R-1-1-dx*scale,8*scale+R+ddy+1),dark,3)

arc((8*scale-R+dx*scale,56*scale-R-1+ddy),dark,0)
arc((8*scale-R+1+dx*scale,56*scale-R-1+ddy),dark,0)

arc((56*scale+R-1-dx*scale,56*scale-R-1+ddy),dark,1)
arc((56*scale+R-1-1-dx*scale,56*scale-R-1+ddy),dark,1)

line(8*scale+R+dx*scale,8*scale+ddy,56*scale-R-1-dx*scale,8*scale+ddy,dark)
line(8*scale+R+dx*scale,8*scale+ddy+1,56*scale-R-1-dx*scale,8*scale+ddy+1,dark)

line(8*scale+dx*scale,8*scale+R+ddy,8*scale+dx*scale,56*scale+ddy-R,dark)
line(8*scale+1+dx*scale,8*scale+R+ddy,8*scale+1+dx*scale,56*scale+ddy-R,dark)

line(56*scale-1-dx*scale,8*scale+R+ddy,56*scale-1-dx*scale,56*scale+ddy-R,dark)
line(56*scale-2-dx*scale,8*scale+R+ddy,56*scale-2-dx*scale,56*scale+ddy-R,dark)

save("tab")

