import os
import glob

# Path to the folder containing the .jpg files
themes_folder = "C:\\ProjectsData\\3d-coat-data-2020\\data\\StartMenu\\images\\themes\\"

# Glob pattern to match all .jpg files
pattern = os.path.join(themes_folder, "*.jpg")

# Prepare the template:
template = """<mitem>
  <Picture>StartMenu/images/themes/INDEXED.jpg</Picture>
  <Frame>false</Frame>
  <HighlightWithOpacity>true</HighlightWithOpacity>
  <Command>theme:StartMenu/files/themes/FILENAME.json</Command>
</mitem>
"""

# Fetch all JPG files
jpg_files = sorted(glob.glob(pattern))
print (jpg_files)

# Iterate over the JPG files, enumerate with a zero-based index
for i, jpg_file in enumerate(jpg_files):
    # Extract the filename without path
    filename = os.path.basename(jpg_file)
    # Extract just the base name (without extension)
    base_name, _ = os.path.splitext(filename)
    # each name is ??_name.jpg, I need the name only, 3rd char and after
    name = base_name[3:]
    print (base_name)
    print (name)


    # Create the new XML content by replacing FILENAME in the template
    xml_content = template.replace("FILENAME", name)
    xml_content = xml_content.replace("INDEXED", base_name)

    # Create the output file name (3-digit, zero-padded)
    output_filename = f"{i:03}.xml"

    # Write to current working directory
    with open(output_filename, "w", encoding="utf-8") as f:
        f.write(xml_content)

    print(f"Created {output_filename} for {filename}")
