// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform float Scale;
uniform vec3 Shift;
uniform float Angle;

in vec3 Pos;
in vec2 TexCoord;
in vec4 Color;
in vec4 Specular;

out vec4 oPos;
out vec3 oN;
out vec2 o_uv;


void main(){
	vec4 P = vec4(Pos,1.0);
	oPos = ( P * g_WorldViewProjectionMatrix );
	oN = Color.xyz * 2.0 - 1.0;
	float _cos = cos(Angle);
	float _sin = sin(Angle);
	vec2 pu = TexCoord;
	vec2 uu = vec2(pu.x*_cos + pu.y*_sin, -pu.x*_sin + pu.y*_cos);
	o_uv = vec2(uu.x, 1.0 - uu.y)*Scale + Shift.xy/256.0;
	o_uv.y *= -1;
	gl_Position = oPos;
}

// Pixel shader

in vec4 oPos;
in vec3 oN;
in vec2 o_uv;
out vec4 FragColor;

uniform sampler2D s_Sampler0;
uniform sampler2D PanoramaDiffuse;

uniform vec3   LDir;
uniform float  LDiffuse;
uniform float  LAmbient;
uniform vec4   LightColor;
uniform mat3 WPanMatrix;
uniform mat4 ScrToUV;
uniform float InvMask;

void main(){
	vec4 tex = texture(s_Sampler0, o_uv);
        tex.xyz = (InvMask*vec3(1.0,1.0,1.0)+(1.0-2.0*InvMask)*tex.xyz);

    	vec3 N1=oN*WPanMatrix;
    	float uu1=atan(N1.z,N1.x)/6.2831853;
    	float vv1=0.5+asin(N1.y)/3.1415926*47.0/48.0;		
    	vec4 diff=texture(PanoramaDiffuse,vec2(uu1,vv1));
    	diff.xyz*=5.0-diff.w*4.0;

	vec4 Color;
	Color.xyz  = tex.xyz * diff.xyz;
	Color.w  = 1.0;
	FragColor =  Color;
}
















