// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;

void main() {
	v_TexCoord0 = TexCoord0;

#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif
        v_TexCoord0.y=1.0-v_TexCoord0.y;
	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;

uniform sampler2D s_Sampler0;

out vec4 FragColor;
void main() {
	vec4 c = texture(s_Sampler0, v_TexCoord0);
	FragColor = v_Color * vec4(1.0,1.0,1.0,c.x);
}