// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

void main() {
	v_TexCoord0 = vec2(vec4(TexCoord0, 0.0, 1.0) * g_TextureMatrix0);
	v_TexCoord1 = vec2(vec4(TexCoord1, 0.0, 1.0) * g_TextureMatrix1);

#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif

	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;

uniform sampler2D s_Sampler0;

out vec4 FragColor;
void main() {
	vec4 c = texture(s_Sampler0, v_TexCoord0);
	FragColor.xyz = vec3(0.5,0.5,0.5);//c.g;//v_Color;
	FragColor.x = 1.0;
	FragColor.w = 0.2;//c.g*c.w;

}