// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;
uniform float ShiftT;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

void main() {
	v_TexCoord0 = vec2(vec4(TexCoord0, 0.0, 1.0) * g_TextureMatrix0);
	v_TexCoord1 = vec2(vec4(TexCoord1, 0.0, 1.0) * g_TextureMatrix1);

#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif
	v_TexCoord1.x = Pos.x/20.0+ShiftT;
	v_TexCoord1.y = Pos.y/20.0-ShiftT;
	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;

uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;
uniform sampler2D s_Sampler2;
uniform sampler2D s_Sampler3;
uniform float FreezeMod;
uniform vec3 MetCoefs;
out vec4 FragColor;
void main() {
	vec4 c = texture(s_Sampler0, v_TexCoord0);
	vec4 n = texture(s_Sampler1, v_TexCoord0);
	vec4 sp = texture(s_Sampler3, v_TexCoord0);
	vec4 f = texture(s_Sampler2, v_TexCoord1);
#ifdef FORDP
	float fr=1.0-n.z;
#else
	vec3 nr=n.xyz*2.0-vec3(1.0,1.0,1.0);
	float  fr=length(nr);
#endif
	c.xyz=pow(c.xyz,vec3(2.2));
	sp.xyz=pow(sp.xyz,vec3(2.2));
	float k=MetCoefs.x+MetCoefs.y*n.w;
	sp.xyz -= vec3(k);
	c.xyz += sp.xyz;
	c.xyz = pow(saturate(c.xyz),vec3(1.0/2.2));
#ifdef NOSWAPXZ
	c.xyz=mix(c.xyz,f.xyz,(1.0-fr)*FreezeMod);
#else
	c.zyx=mix(c.xyz,f.xyz,(1.0-fr)*FreezeMod);
#endif
	//c.w=1.0;
	FragColor = c;
}