// Vertex shader

uniform vec3 g_ViewerPos;
uniform mat4 g_WorldViewProjectionMatrix;

in vec3 Pos;
in vec4 Color;

out vec3 v_N;
out vec3 v_P;

void main( ) {
    vec4 P=vec4( Pos, 1.0);
    gl_Position = ( P * g_WorldViewProjectionMatrix );
    v_P = Pos;
    v_N = Color.xyz;
    v_N *= 2.0;
    v_N -= vec3(1.0,1.0,1.0); 
}

// Fragment shader

uniform mat4 ScrToUV;

uniform vec4 LightColor;
uniform float LAmbient;
uniform float LDiffuse;
uniform vec3 LDir;

uniform vec3 Center;
uniform vec3 MainAxis;
uniform vec3 RightAxis;
uniform vec3 FrontAxis;
uniform vec3 Scale;
uniform vec3 Shift;
uniform float Spiral;
uniform float InvMask;
uniform mat3x3 WPanMatrix;

uniform sampler2D s_Sampler0;
uniform sampler2D PanoramaDiffuse;

in vec3 v_N;
in vec3 v_P;


out vec4 FragColor;
void main( ) {
    vec3 d1=v_P-Center;
    vec3 dd=normalize(d1);
    float dy=dot(dd,MainAxis);
    float dx=dot(dd,RightAxis);
    float dz=dot(dd,FrontAxis);
    float uu0=atan(dx,dz)/6.2832;
    float uu=uu0*Scale.x+Shift.x;
    float dr=sqrt(dx*dx+dz*dz);
    float vv=(atan(dy,dr)/1.5708+0.5)*Scale.y+Shift.y+uu0*Spiral;
    vec4 tex = texture( s_Sampler0, vec2(uu,1.0-vv));
    tex.xyz = (InvMask*vec3(1.0,1.0,1.0)+(1.0-2.0*InvMask)*tex.xyz);

    vec3 N1=v_N*WPanMatrix;
    float uu1=atan(N1.z,N1.x)/6.2831853;
    float vv1=0.5+asin(N1.y)/3.1415926*47.0/48.0;		
    vec4 diff=texture(PanoramaDiffuse,vec2(uu1,vv1));
    diff.xyz*=5.0-diff.w*4.0;

    vec4 Color;
    Color.xyz  = tex.xyz*diff.xyz;
    Color.w  = 1.0;
    FragColor = Color;
}
