// Vertex shader
//#version 140
uniform mat4 g_ViewProjectionMatrix;
uniform vec3 g_ViewerPos;
uniform mat4 g_WorldMatrix;
uniform vec4 Sphere;
uniform mat3 PanMatrix;

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;

out vec2 uv;

void main() {
	vec3 pp = Pos * 1000.0;
	pp = pp * PanMatrix;
	vec4 P = vec4(pp+g_ViewerPos, 1.0);
	
	gl_Position = P * g_ViewProjectionMatrix;
	uv = TexCoord;
}

// Fragment shader
//#version 140
in vec2 uv;
in vec3 Pos;

out vec4 FragColor;

uniform float PanoramaShift;
uniform float PanoramaBlur;
uniform float LDiffuseC;
uniform sampler2D s_Sampler0;
uniform vec3 ExtraGamma;
#include "/Templates/contrast.glsl"

void main() {	
 
	vec4 C = textureLod (s_Sampler0,vec2(uv.x, uv.y), PanoramaBlur);
	float modf = getmodf(C.xyz);
	C.xyz *= modf;	
	C.xyz *= (5.0 - C.w*4.0) * LDiffuseC;
	C.w = 1.0;	
	FragColor = C;
}
