// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_ViewerPos;
uniform float NDisplacement; 

in vec3 Pos;
in vec3 Normal;
in vec4 Color;

out vec3 v_Normal;
out vec3 v_Pos;
out vec4 v_Pos2;
out float v_DS;


void main() {
	vec3 nn = normalize(Color.xyz-vec3(0.5,0.5,0.5));	
	vec4 P = vec4(Pos+nn*NDisplacement, 1.0);
	v_Pos2 = P * g_WorldViewProjectionMatrix;
	gl_Position = v_Pos2;
	P = vec4(Normal, 0.0);
	vec4 N = P * g_WorldMatrix;	
	v_Normal=normalize(N.xyz);
	v_Pos=Pos;
	v_DS=Color.w;
}

// Fragment shader

in vec3 v_Normal;
in vec3 v_Pos;
in vec4 v_Pos2;
in float v_DS;

uniform float    LDiffuse;
uniform float    LAmbient;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform vec4   Color;

uniform float g_ViewportWidth;
uniform float g_ViewportHeight;

out vec4 FragColor;
void main() {	
	vec3 N=normalize(v_Normal);
	float   D = LDiffuse*dot(N,LDir);	
	vec4 C1 = Color*D;
	C1.w =Color.w;
	if(v_DS>0.0){
		vec4 p=v_Pos2;
		p/=p.w;
		float x=(1.0+p.x)*0.25*g_ViewportWidth+0.125;
		float y=(1.0+p.y)*0.25*g_ViewportHeight+0.125;
		float s=x+y;
		s-=floor(s);
		if(s>0.5){
			discard;
			C1.w=0.0;
		}		
	}
	FragColor = C1;//cos(v_Pos.x*20.0)*0.5+0.5,cos(v_Pos.y*20.0)*0.5+0.5,cos(v_Pos.z*20.0)*0.5+0.5,1);
}