// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_ViewerPos;
uniform mat4 ShadowTM;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;
in vec4 Color2;

out vec3 v_Normal;
out vec3 v_Pos;
out vec4 v_Color;

void main() {
	vec4 P = vec4(Pos, 1.0);
	vec4 PC = P * g_WorldViewProjectionMatrix;
	gl_Position = PC;
	v_Normal=Normal;
	v_Pos=Pos;
	v_Color=vec4(0.5,0.5,0.5,1.0);
}

// Fragment shader

in vec3 v_Normal;
in vec3 v_Pos;
in vec4 v_Color;

uniform sampler2D ShadowSampler;
uniform sampler2D CustomSampler3;

uniform float LDiffuse;
uniform float LAmbient;
uniform vec3  LDir;
uniform vec3  LDirNormalized;
uniform vec3  g_LocalViewDir;
uniform vec3  LDir2;
uniform float ShadowMin;
uniform vec4  CurrColor;
uniform vec4  LightColor;
uniform float GridConst;

out vec4 FragColor;
void main() {
        if(mod(gl_FragCoord.x+gl_FragCoord.y,2.0)==GridConst)discard;
	float L=length(v_Normal);
	vec3 N=v_Normal/L;
	float dd=clamp(L-1.0,0.0,1.0);
	float D = LAmbient-LDiffuse*dot(N,LDir);
	vec4 C = v_Color;
	C*=D;
	vec4 c4=texture(CustomSampler3,vec2(dd,0));
	C=lerp(saturate(C),c4,dd*c4.w);
	C.w=v_Color.w;//*Opacity;
	FragColor = C*LightColor;
}