// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_ViewerPos;
uniform mat4 ShadowTM;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;
in vec4 Color2;

out vec4 v_Color;
out float fr;


void main() {
	vec4 P = vec4(Pos, 1.0);
	vec4 PC = P * g_WorldViewProjectionMatrix;
	gl_Position = PC;
	fr = 1.0 - saturate(length(Normal)-1.0);
	v_Color=Color;
}

// Fragment shader

in vec4 v_Color;
in float fr;

uniform float GridConst;

out vec4 FragColor;
void main() {
	float gc = mod(gl_FragCoord.x+gl_FragCoord.y,2.0);
        if(gc==GridConst)discard;
	float alp=saturate((v_Color.w-0.5)/0.5);
	float a= gc+alp;
	if(GridConst>2.0)a=1.0;
	FragColor = vec4((vec3(0.33)*(1.0-alp) + v_Color.xyz*alp)*fr,a);        
}