// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_LocalViewPos;
uniform vec4 Sphere;
uniform mat4 ShadowTM;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;
in vec4 Color2;

out vec4 oPos;
out vec3 oN;
out vec4 oC;
out vec4 oC2;
#ifdef SHADOWS
out vec3 oSPos;
#endif
out float oEmissive;
out vec3 oVDir;


void main() {
	
	vec4 P = vec4(Pos, 1.0);
	vec4 PC = P * g_WorldViewProjectionMatrix;
	oVDir = normalize(Pos.xyz - g_LocalViewPos);
	oPos = PC;
	oN = Normal;
	oC = Color;
	oC2= Color2;
#ifdef SHADOWS
	oSPos = (P * ShadowTM).xyz;
	oSPos.xy += vec2(1.0 / 4096.0, 1.0 / 4096.0);
	oSPos.y = 1.0 - oSPos.y;
#endif
	if(Color.w < 0.5){
		oEmissive = Color.w * 2.0;
		oC.w = 1.0;
	}else{
		oEmissive=0.0;
		oC.w = Color.w * 2.0 - 1.0;
	}
	gl_Position = oPos;
}



// Fragment shader
in	vec4 oPos;
in	vec3 oN;
in	vec4 oC;
in	vec4 oC2;
#ifdef SHADOWS
in vec3 oSPos;
#endif
in float oEmissive;
in vec3 oVDir;


uniform mat4 g_WorldViewProjectionMatrix;
uniform sampler2D ShadowSampler;
uniform sampler2D CustomSampler3;
uniform sampler2D Panorama;

uniform vec4 Color;
uniform vec4 CurrColor;
uniform vec3 LDir;
uniform vec3 LDirNormalized;
uniform vec3 VDir;
uniform float LDiffuseC;
uniform float LDiffuse22C;
uniform float LAmbient;
uniform float ShadowMin;
uniform vec4 LightColor;
uniform vec3 g_LocalViewDir;
uniform float Opacity;
uniform float GridConst;
uniform float PanoramaShift;
uniform float RefShade;
uniform mat3 PanMatrix;
uniform mat3 WPanMatrix;
uniform vec4 Freshnel;
uniform vec4 mip_ref;
out vec4 FragColor;
void main()  {
	//if(((sp.x+sp.y)%2.0)==GridConst)discard;
	float mpl = 1.0;
	float L = length(oN);
	vec3 N = -oN / L;
	vec3 N0 = N;
	vec3  refl = oVDir - 2.0 * N * dot(oVDir, N);
	vec3 vdir = oVDir;
	refl = normalize(refl * WPanMatrix);
	N    = normalize(N * WPanMatrix);
	vdir = normalize(vdir * WPanMatrix);	
	
	float dd = clamp(L-1.0,0.0,1.0);
	vec4 c1 = texture(CustomSampler3, vec2(dd,0.0));
	vec4 color;
	vec4 nrm;
	nrm = oC2;
	nrm.w *= 1.0 - dd;
	vec3 vcl = pow(oC.xyz, vec3(2.2));
	vec3 vcl2 = pow(oC2.zyx, vec3(2.2));
	vec3 clr = mix(Color.xyz, c1.xyz, dd * c1.w);
	vec3 objcolor = clr * vec3(LDiffuse22C);

	//lighling block - same for ppp/voxel shaders

	/*float fren = pow((1.0 + dot(vdir, refl))/2.0, 19.0);
	fren *= nrm.w;
	float gloss = 1.0 - clamp(nrm.w + fren / 6.0, 0.0, 1.0);
	gloss = 1.0 - sqrt(1.0 - gloss);
	gloss = 1.0 - sqrt(gloss);*/

	//gloss
	float gloss = (1.0 - nrm.w);
	gloss = 1.0 - sqrt(1.0 - gloss);
	gloss = 1.0 - sqrt(gloss);
	
	//fresnel
	float fren = pow((1.0 + dot(vdir, refl)) / 2.0, gloss * 6.0 + 3.0) * 0.5;  
	fren += pow((1.0 + dot(vdir, refl)) / 2.0, 12.0)*0.5 * (1 - gloss);        //second fresnel
	fren *= gloss * 0.98 + Freshnel.x;       //fresnel if gloss == 0
	
	
	gloss += fren * (1-gloss)*0.5;  	//horizon smoothing  
	
	
	float opp = 1.0 - gloss;
	float uu = atan(refl.z, refl.x) / 6.2831853;
	float vv = 0.5 + asin(refl.y) / 3.1415926 * (2048.0-pow(2.0, opp*7.0)) / 2048.0;	

	
	//reflection
	vec4 ref2 = textureLod(Panorama, vec2(uu, vv), opp * 7.0) * 0.7;	
	ref2 += textureLod(Panorama, vec2(uu, vv), opp * mip_ref.x) * 0.15;
	ref2 += textureLod(Panorama, vec2(uu, vv), opp * mip_ref.y) * 0.15;
	
	
	ref2.xyz *= 5.0 - ref2.w * 4.0;
	ref2.xyz = pow(ref2.xyz,vec3(2.2));
	ref2.xyz = pow(ref2.xyz,vec3(2.5 - gloss * 1.5)); // increase contrast for gloss == 50;

	uu = atan(N.z, N.x) / 6.2831853;
	vv = 0.5 + asin(N.y) / 3.1415926 * 23.0 /24.0;		
	vec4 diff = textureLod(Panorama, vec2(uu, vv), 6.5);
	diff.xyz *= 5.0 - diff.w * 4.0;
	diff.xyz = pow(diff.xyz, vec3(2.2));

#ifdef SHADOWS
	vec3 m = texture(ShadowSampler, oSPos.xy).xyz;	
	vec3 d = vec3(1.0, 1.0/ 255.0, 1.0/ 255.0/ 255.0);
	mpl = clamp(2.0 - (oSPos.z - dot(m, d)) * 600, ShadowMin, 1.0);
	diff = vec4(mpl) * clamp(dot(LDir,N0),0.0,1.0);
	ref2 *= mix(vec4(1.0),vec4(mpl) *  clamp(dot(LDir,N0),0.0,1.0)*20.0,RefShade);
#endif
	
	
#ifdef AOPASS
	
#else
	
#endif  
	diff.xyz *= vcl * pow(LightColor.xyz,vec3(2.2)) * objcolor;
	color.xyz = mix(diff.xyz,ref2.xyz * objcolor,vcl2+vec3(fren));
	vec3 emm = (vcl + vcl2) * oEmissive;
	color.xyz = pow(color.xyz,vec3(1/2.2))+emm;
	
	color.w = oC.w * Opacity;
	
	FragColor = color;        
}