// Vertex shader
#include "/Templates/scalc_vs.glsl"
// Fragment shader
#include "/Templates/scalc_variables.glsl"
#include "/Templates/scalc_voxel_lib.glsl"

uniform float radius;
uniform float operation_sign;
uniform float alpha_overlap;
uniform float operation_degree;

float SideSumm(vec3 pos, float v0) { 
	float summ = v0;
	float d = 1.0 / LinearTexturePinch;
	vec3 p0=vec3(float(pos.x), float(pos.y), float(pos.z));
	for(int i=0;i<NPoints;i++){
		calc_pen_basis(i);// -> vec3 point, float radius, vec3 normal, float depth, vec3 tangent, vec3 binomal		
		vec3 pp = (p0 - point) / radius;
		float L = length(pp);
		if(L<1.0){
			float u = clamp(dot(pp, tangent), -1.0, 1.0) * 0.5 + 0.5;
			float v = clamp(dot(pp, binormal), -1.0, 1.0) * 0.5 + 0.5;
			float w = saturate(texture(Alpha, vec2(u,v)).x * (1.0 - L * L * L * L) * 1.33 * operation_degree);
			tangent *= 2.0;
			binormal *= 2.0;
			vec3 tbp = (tangent + binormal) * 0.75;
			vec3 tbm = (tangent - binormal) * 0.75;
			float vv = getInterpolatedCellValue(p0 + tangent);
			vv += getInterpolatedCellValue(p0 - tangent);
			vv += getInterpolatedCellValue(p0 + binormal);
			vv += getInterpolatedCellValue(p0 - binormal);
			vv += getInterpolatedCellValue(p0 + tbp);
			vv += getInterpolatedCellValue(p0 - tbp);
			vv += getInterpolatedCellValue(p0 + tbm);
			vv += getInterpolatedCellValue(p0 - tbm);
			vv /= 8.0;
			float r = vv * w + v0 * (1.0 - w);
			if(operation_sign > 0) summ = max(r, summ);
			if(operation_sign < 0) summ = min(r, summ);
		}
	}
	return summ;
}
		

void main() {
	int gx = int(gl_FragCoord.x);
	int gy = int(gl_FragCoord.y);	
	int base = gx+gy*LinearTexturePinch;
	ivec2 tsz = textureSize(out_BackIndex,0);
	float h=float(tsz.y);
	for(int i=0;i<2;i++){
		int ofs = base*2+i;
		ivec3 pos = getPos(ofs);
		float v0=getCellValue(pos.x, pos.y, pos.z);
		int val = int(v0*65535.0);
		int nn=2+int(clamp(operation_degree * 3, 0, radius / 10));
		float summ = SideSumm(pos, v0);	
		
		val = int(summ * 65535.0);

		if(i == 0) FragColor.xy = intTov2(val);
		else FragColor.zw = intTov2(val);		
	}
}
