// Vertex shader
#include "/Templates/scalc_vs.glsl"
// Fragment shader
#include "/Templates/scalc_variables.glsl"
#include "/Templates/scalc_voxel_lib.glsl"
uniform sampler2D inp;

vec4 packFloatToVec4i(const float value) {
  const vec4 bitSh = vec4(256.0*256.0*256.0, 256.0*256.0, 256.0, 1.0);
  const vec4 bitMsk = vec4(0.0, 1.0/256.0, 1.0/256.0, 1.0/256.0);
  vec4 res = fract(value * bitSh);
  res -= res.xxyz * bitMsk;
  return res;
}

float unpackFloatFromVec4i(const vec4 value) {
  const vec4 bitSh = vec4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1.0);
  return(dot(value, bitSh));
}

void main() {
	int gx = int(gl_FragCoord.x);
	int gy = int(gl_FragCoord.y);	
	int base = gx+gy*LinearTexturePinch;
	vec4 v = getVec4(inp, base);
	float x = v42float(v);
	x *= 2.0;
	FragColor = packFloatToVec4i(float(base)/4000.0);
}
