// Vertex shader
#include "/Templates/scalc_vs.glsl"
// Fragment shader
#include "/Templates/scalc_variables.glsl"
#include "/Templates/scalc_voxel_lib.glsl"
//xxcfr;
uniform sampler2D Positions;//vec4  < Vector4D
uniform sampler2D NbIndex;//
uniform sampler2D NbDistance;
uniform sampler2D NbVertex;

uniform float Roughness;
uniform float Stretchness;
uniform int NVerts;
uniform float UseVolume;
uniform mat4 Transform;
uniform mat4 TransformInv;
uniform float Gravity;
uniform float Friction;

void main() {
	int gx = int(gl_FragCoord.x);
	int gy = int(gl_FragCoord.y);	
	int base = gx+gy*LinearTexturePinch;
	vec4 res = getVec4(Positions, base);
	vec3 pos0 = res.xyz;
	int Locked = int(res.w);
	float str = Stretchness * 4.0;
	if(Locked < 1 && base < NVerts) {
		int v0 = getInt(NbIndex, base);
		int nn = getInt(NbIndex, base + 1) - v0;
		if(nn > 0) {
			vec3 Pos0 = res.xyz;
			vec3 C = vec3(0.0, 0.0, 0.0);
			float L = 0;
			float SW = 0;
			float avdst = 1000000.0;
			if(Roughness < 1.0 && nn > 0) {
				avdst = 0;
				for (int k = 0; k < nn; k++) {
					avdst += getVec4(NbDistance, v0 + k).x;
				}
				avdst /= nn;
			}
			for (int k = 0; k < nn; k++) {
				int vpos = v0 + k;
				int v = getInt(NbVertex, vpos);
				float d = getVec4(NbDistance, vpos).x;
				L += d;
				vec3 d1 = pos0 - getVec4(Positions, v).xyz;
				vec3 dd = d1;
				dd = normalize(dd);
				dd *= d;
				if(d > avdst) {
					float w = Roughness;
					C += (dd - d1) * w;
					SW += w;
				}
				else {
					C += (dd - d1);
					SW++;
				}
			}
			L /= nn * 3;
			C /= SW*0.51 + str*SW;
			float CL = length(C);
			if (CL > L&& L > 0) {
				C = normalize(C);
				C *= L;
			}
			if (Locked > 0 && length(C) < L / 8.0) {
				C = vec3(0.0, 0.0, 0.0);
			}
			res.xyz += C;
		}
		if(UseVolume > 0){
			float g = Gravity/10.0;
			float g1 = g + 0.1;
			const float mid = 0.5;
			vec3 pos = res.xyz;
			
			pos = (TransformInv * vec4(pos, 1.0)).xyz;
			
			float v = clamp(getInterpolatedCellValue(pos) * 3.0 - 0.75, 0.0, 1.0);
			vec3 dir = -voxNormal(pos, 3.0);
			float dL = length(dir);
			if(dL == 0)dir = vec3(0, 1, 0);
			pos += v*g1*10.0*dir;
			vec3 vg = vec3(0, g, 0);
			pos -= vg;
			if(v > 0) {			
				if (Friction > 0) {
					vec3 p0 = (TransformInv * vec4(pos0, 1.0)).xyz;
					dir = normalize(dir);
					float cc = distance(p0, pos);
					if(cc < g * Friction * 10.0) {
						pos -= p0;
						pos = dir * dot(dir, pos);
						pos += p0;
					}
				}
			}		
			pos = (Transform * vec4(pos, 1.0)).xyz;
			res.xyz = pos;
		}
	}
	FragColor = res;
}
