/// unpack int as if from the linear array from rgba sampler
int getInt(in sampler2D s, int offset){
	ivec2 tsz = textureSize(s,0);
	float h=float(tsz.y);
	vec4 ofs = texture(s, vec2(float(offset % LinearTexturePinch)/LinearTexturePinch, float(offset/LinearTexturePinch)/h));
	return int(ofs.x*255.0) + (int(ofs.y*255.0) + (int(ofs.z*255.0) + int(ofs.w*255.0)*256)*256)*256;
}
/// unpack 16-bit word as if from the linear array from rgba8 sampler2D
int getWord(in sampler2D s, int offset){
	ivec2 tsz = textureSize(s,0);
	float h=float(tsz.y);
	int ofs = offset/2;
	int odd = offset % 2;
	vec4 vv = texture(s, vec2(float(ofs % LinearTexturePinch)/LinearTexturePinch, float(ofs/LinearTexturePinch)/h));
	return odd == 0 ? int(vv.x*255.0) + int(vv.y*256.0*255.0) : int(vv.z*255.0) + int(vv.w*256.0*255.0);
}
/// get vec4 from rgba32f/rgba8 sampler2D mapped linearly (to avoid max size limitations)
vec4 getVec4(sampler2D s, int offset) {
	ivec2 tsz = textureSize(s,0);
	float h=float(tsz.y);
	return texture(s, vec2(float(offset % LinearTexturePinch)/LinearTexturePinch, float(offset / LinearTexturePinch)/h));
}
/// get word (unsigned 16 bit) converted to float [0..1] from rgba8 sampler2D
float getfWord(in sampler2D s, int offset){
	ivec2 tsz = textureSize(s,0);
	float h=float(tsz.y);
	int ofs = offset/2;
	int odd = offset % 2;
	vec4 vv = texture(s, vec2(float(ofs % LinearTexturePinch)/LinearTexturePinch, float(ofs/LinearTexturePinch)/h));
	return odd == 0 ? vv.x*255.0/65535.0 + vv.y*256.0*255.0/65535.0 : vv.z*255.0/65535.0 + vv.w*256.0*255.0/65535.0;
}
/// convert integer, unsigned 16-bit value into the vec2 to be placed into rgba8 render target to be read as word-s on the CPU side
vec2 intTov2(int value){
	float v = float(value);
	float v1 = floor(v/256.0);
	float v2 = mod(v + 0.5, 256.0);
	return vec2(v2/255.0,v1/255.0);
}
/// get cell value by the integer coordinates
float getCellValue(int x, int y, int z){
	x -= in_cx*8;
	y -= in_cy*8;
	z -= in_cz*8;
	
	int cex = clamp(x/8, 0, in_Lx - 1);
	int cey = clamp(y/8, 0, in_Ly - 1);
	int cez = clamp(z/8, 0, in_Lz - 1);
	int c = cex+(cey + cez * in_Ly) * in_Lx;

	vec4 ofs = getVec4(in_CellOffset, c);
	if(ofs.w > 0.5)return (ofs.y*256.0 + ofs.x)/257.0;
	int ofst = int(ofs.x*255.0) + int(ofs.y*256.0*255.0) + int(ofs.z*65536.0*255.0);
	
	ofst *= 729;
	x = clamp(x - cex * 8, 0, 8);
	y = clamp(y - cey * 8, 0, 8);
	z = clamp(z - cez * 8, 0, 8);
	return getfWord(in_CellsValues, ofst + x+(y+z*9)*9);
}
/// returns the basis for the i-th brush spot : vec3 point, float radius, vec3 normal, float depth, vec3 tangent, vec3 binomal
#define calc_pen_basis(i) float iltp = 1.0 / LinearTexturePinch; float iltp3 = (float(i * 3)) / LinearTexturePinch; vec4 pr = texture(Points, vec2(iltp3, 0)); vec3 point = pr.xyz; float radius = pr.w; vec4 nd = texture(Points, vec2(iltp3 + iltp, 0)); vec3 normal = nd.xyz; float depth = nd.w; vec4 ts = texture(Points, vec2(iltp3 + iltp * 2.0, 0)); vec3 tangent = ts.xyz; vec3 binormal = cross(normal.xyz, tangent)*ts.w;

/// returns the [0..1] float weight value that corresponds to the current brush & trajectory settings
float AlphaDegreeSumm(ivec3 pos){
	float summ = 0;
	vec3 p0=vec3(float(pos.x), float(pos.y), float(pos.z) + 0.5);
	for(int i=0;i<NPoints;i++){
		calc_pen_basis(i);// -> vec3 point, float radius, vec3 normal, float depth, vec3 tangent, vec3 binomal
		vec3 pp = (p0 - point) / radius;
		float L = length(pp);
		if(L<1.0){
			float u = clamp(dot(pp, tangent), -1.0, 1.0) * 0.5 + 0.5;
			float v = clamp(dot(pp, binormal), -1.0, 1.0) * 0.5 + 0.5;
			float w = texture(Alpha, vec2(u,v)).x * (1.0 - L * L * L * L);
			summ += w * depth;
		}
	}
	return summ;
}

const int npos = 20;
const vec3 vpos[20] = vec3[20](
	vec3(-0.357, 0.000, 0.934), vec3(0.357, 0.000, 0.934), vec3(-0.577, -0.577, -0.577), vec3(-0.577, -0.577, 0.577), 
	vec3(-0.577, 0.577, -0.577), vec3(-0.577, 0.577, 0.577), vec3(0.577, -0.577, -0.577), vec3(0.577, -0.577, 0.577), 
	vec3(0.577, 0.577, -0.577), vec3(0.577, 0.577, 0.577), vec3(0.934, 0.357, 0.000), vec3(0.934, -0.357, 0.000), 
	vec3(-0.934, 0.357, 0.000), vec3(-0.934, -0.357, 0.000), vec3(-0.357, 0.000, -0.934), vec3(0.357, 0.000, -0.934), 
	vec3(0.000, 0.934, 0.357), vec3(0.000, 0.934, -0.357), vec3(0.000, -0.934, 0.357), vec3(0.000, -0.934, -0.357)
);
/// returns the smoothed value near the integer position 
float getSmoothedValue(ivec3 pos, int nn) {
	float summ = 0;
	for(int i=0; i < npos; i++) {
		vec3 v = vpos[i];
		int dx = int(v.x*nn);
		int dy = int(v.y*nn);
		int dz = int(v.z*nn);
		float w = getCellValue(pos.x + dx, pos.y + dy, pos.z + dz);
		summ += w;
	}
	summ /= npos;
	return summ;
}
/// the degugging code used to map any value into the array of words at render target
int _debug(int ofs) {
	int val = 0;
	int k = ofs % 3;
	int p = ofs / 3; 
	float xxx = float(p) / LinearTexturePinch;
	float yyy = float(p / LinearTexturePinch)/2.0;
	if(k == 0) val = int(texture(Points, vec2(xxx, yyy)).x*100);
	if(k == 1) val = int(texture(Points, vec2(xxx, yyy)).y*100);
	if(k == 2) val = int(texture(Points, vec2(xxx, yyy)).z*100);
	if(k == 3) val = int(texture(Points, vec2(xxx, yyy)).w*100);
	return val;
}
/// return the integer position from the linear offset
ivec3 getPos(int ofs){
	int cellidx = ofs/729;
	int cofs = ofs % 729;
	int x = cofs % 9;
	int y = (cofs / 9) % 9;
	int z = cofs / 81;
	vec3 cxyz = getVec4(out_BackIndex, cellidx).xyz;
	int xx = x + (int(cxyz.x * 255.0) + out_cx) * 8;
	int yy = y + (int(cxyz.y * 255.0) + out_cy) * 8;
	int zz = z + (int(cxyz.z * 255.0) + out_cz) * 8;
	return ivec3(xx, yy, zz);
}
// Encoding/decoding [0..1) floats into 8 bit/channel RGBA. Note that 1.0 will not be encoded properly.
vec4 float2v4( float v )
{
    vec4 kEncodeMul = vec4(1.0, 255.0, 65025.0, 160581375.0);
    float kEncodeBit = 1.0/255.0;
    vec4 enc = kEncodeMul * v;
    enc = fract (enc);
    enc -= enc.yzww * kEncodeBit;
    return enc;
}
float v42float( vec4 enc )
{
    vec4 kDecodeDot = vec4(1.0, 1/255.0, 1/65025.0, 1/160581375.0);
    return dot( enc, kDecodeDot );
}
/// get the interpolated value in the cell
float getInterpolatedCellValue(vec3 p){
	vec3 pos=p - in_cellstart;
	
	int x = int(floor(pos.x));
	int y = int(floor(pos.y));
	int z = int(floor(pos.z));

	float dx = fract(pos.x);
	float dy = fract(pos.y);
	float dz = fract(pos.z);

	int cex = clamp(x/8, 0, in_Lx - 1);
	int cey = clamp(y/8, 0, in_Ly - 1);
	int cez = clamp(z/8, 0, in_Lz - 1);
	int c = cex+(cey + cez * in_Ly) * in_Lx;

	vec4 ofs = getVec4(in_CellOffset, c);
	if(ofs.w > 0.5)return (ofs.y*256.0 + ofs.x)/257.0;
	int ofst = int(ofs.x*255.0) + int(ofs.y*256.0*255.0) + int(ofs.z*65536.0*255.0);
	
	ofst *= 729;
	x = clamp(x - cex * 8, 0, 8);
	y = clamp(y - cey * 8, 0, 8);
	z = clamp(z - cez * 8, 0, 8);
	int of0 = ofst + x+(y+z*9)*9;
	float f0 = getfWord(in_CellsValues, of0);
	float f1 = getfWord(in_CellsValues, of0 + 1);
	float f2 = getfWord(in_CellsValues, of0 + 9);
	float f3 = getfWord(in_CellsValues, of0 + 10);
	of0 += 81;
	float f4 = getfWord(in_CellsValues, of0);
	float f5 = getfWord(in_CellsValues, of0 + 1);
	float f6 = getfWord(in_CellsValues, of0 + 9);
	float f7 = getfWord(in_CellsValues, of0 + 10);

	f1 -= f0;
	f2 -= f0;
	f3 -= f0 + f1 + f2;
	f5 -= f4;
	f6 -= f4;
	f7 -= f4 + f5 + f6;
	float v1 = f0 + f1 * dx + f2 * dy + f3 * dx * dy;
	float v2 = f4 + f5 * dx + f6 * dy + f7 * dx * dy;
	return v1+(v2-v1)*dz;
}
/// get the value and the short-range normal, pay attention nornal does not change within the single 1x1x1 cell
vec4 getInterpolatedCellValueAndNormal(vec3 p){
	vec3 pos=p - in_cellstart;	
	int x = int(floor(pos.x));
	int y = int(floor(pos.y));
	int z = int(floor(pos.z));

	float dx = fract(pos.x);
	float dy = fract(pos.y);
	float dz = fract(pos.z);

	int cex = clamp(x/8, 0, in_Lx - 1);
	int cey = clamp(y/8, 0, in_Ly - 1);
	int cez = clamp(z/8, 0, in_Lz - 1);
	int c = cex+(cey + cez * in_Ly) * in_Lx;

	vec4 ofs = getVec4(in_CellOffset, c);
	if(ofs.w > 0.5)return vec4(0.0, 0.0, 0.0, (ofs.y*256.0 + ofs.x)/257.0);
	int ofst = int(ofs.x*255.0) + int(ofs.y*256.0*255.0) + int(ofs.z*65536.0*255.0);
	
	ofst *= 729;
	x = clamp(x - cex * 8, 0, 8);
	y = clamp(y - cey * 8, 0, 8);
	z = clamp(z - cez * 8, 0, 8);
	int of0 = ofst + x+(y+z*9)*9;
	float f0 = getfWord(in_CellsValues, of0);
	float f1 = getfWord(in_CellsValues, of0 + 1);
	float f2 = getfWord(in_CellsValues, of0 + 9);
	float f3 = getfWord(in_CellsValues, of0 + 10);
	of0 += 81;
	float f4 = getfWord(in_CellsValues, of0);
	float f5 = getfWord(in_CellsValues, of0 + 1);
	float f6 = getfWord(in_CellsValues, of0 + 9);
	float f7 = getfWord(in_CellsValues, of0 + 10);

	vec4 res = vec4(f1+f3+f5+f7-f0-f2-f4-f6, f2+f3+f6+f7-f0-f1-f4-f5, f4+f5+f6+f7-f0-f1-f2-f3, 0);
	float L = length(res);
	if(L > 0) res.xyz /= L;

	f1 -= f0;
	f2 -= f0;
	f3 -= f0 + f1 + f2;
	f5 -= f4;
	f6 -= f4;
	f7 -= f4 + f5 + f6;
	float v1 = f0 + f1 * dx + f2 * dy + f3 * dx * dy;
	float v2 = f4 + f5 * dx + f6 * dy + f7 * dx * dy;
	res.w =  v1+(v2-v1)*dz;
	return res;
}
/// Calculate voxel-based normal 
vec3 voxNormal(vec3 pos, float L){
	vec3 n = vec3(
		getInterpolatedCellValue(pos + vec3(L, 0, 0)) - getInterpolatedCellValue(pos + vec3(-L, 0, 0)),
		getInterpolatedCellValue(pos + vec3(0, L, 0)) - getInterpolatedCellValue(pos + vec3(0, -L, 0)),
		getInterpolatedCellValue(pos + vec3(0, 0, L)) - getInterpolatedCellValue(pos + vec3(0, 0, -L))
	);
	float Len = length(n);
	if(Len>0)n /= Len;
	return n;
}




















/// amount of lines should be 100*n + 71
