uniform float WFogDensity;
uniform float WFogShadows;
uniform float WFogPower;
uniform vec4 WFogColor;
uniform float WVolumeFogSamples;
uniform float WLightSilhouette;
uniform float WSilhouette;
uniform float WShadowMapSize;
uniform float WFogRand;

uniform float NGScale;
uniform float RRenderPass;
uniform float du;
uniform float dv;

uniform sampler2D tBRDF;
uniform sampler2D PanoramaDiffuse;
uniform float Metalness;
uniform float ExtraGloss;
uniform float BasePlasticReflection;
uniform float MaxPlasticReflection;
uniform float PaintOpacity;
uniform float LightContrast;
uniform float IsExternalLight;
uniform vec3 ExtraGamma;
uniform vec4 LightColor2g;
uniform vec4 SSScolor;
uniform float Translucence;
uniform float FreezeMod;
uniform float Inverse;
#define GlobalViewDir (-oVDir)
#ifdef BAS_RELIEF
uniform vec3 BasReliefDir;
uniform vec3 BasReliefBase;
uniform float TaperingAngle;
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_LocalViewPos;
uniform vec4 Sphere;
uniform mat4 ShadowTM;
uniform float OverallScale;
uniform float ShadowStep;
uniform float ShadowMapSide;
uniform float Extrusion;

#ifdef USE_DEPTH
uniform float du;
uniform float dv;
#endif

in vec3 Pos;
in vec3 Normal;
in vec4 Color;
in vec4 Color2;

out vec4 voPos;
out vec3 voN;
out vec4 voC;
out vec4 voC2;
out vec3 voWorldPos;
out vec4 voExtra;
out vec3 voVDir;
out vec3 voMPos;
out vec3 voRawPos;
out vec3 voRawNormal;

#define oPos voPos
#define oN voN
#define oC voC
#define oC2 voC2
#define oWorldPos voWorldPos
#define oExtra voExtra
#define oVDir voVDir
#define oMPos voMPos
#define oRawPos voRawPos
#define oRawNormal voRawNormal


uniform vec3 MousePos;
uniform float TimeSeconds;
uniform float CurrentIteration;
uniform vec3 LightDir;

void main() {
	
	vec4 P = vec4(Pos, 1.0);
#ifdef EXTRUSION_SUPPORTED
	P.xyz += Normal*Extrusion;
#endif //EXTRUSION_SUPPORTED

	
	

	float L=length(Normal);
	oN = Normal/L;
	oC = Color;
	oC2= Color2;
	
#ifdef PRINTING
	oMPos = (P*g_WorldMatrix).xyz/8.0/LayerThickness;
#else
	oMPos = Pos*0.005/(OverallScale+1e-10);
#endif	
	oVDir = normalize(Pos.xyz - g_LocalViewPos);
	
	if(Color.w < 0.5){
		oExtra.x = Color.w * 2.0;
		oC.w = 1.0;
	}else{
		oExtra.x = 0.0;
		oC.w = Color.w * 2.0 - 1.0;
	}
	oC2.y = L-1;
//#ifdef FragColor
//	oWorldPos = P.xyz;
//#endif
	vec4 NP = P;
	oRawPos = P.xyz;
	oRawNormal = -Normal.xyz;
#ifdef NODE_CODE
	vec3 tColor = oC.xyz;
	vec3 tSpecular = oC2.xyz;
	float Gloss = oC2.w;
	vec3 Emiss = oC2.xyz;
	vec3 sfColor = oC2.xyz;
	
	ioTime = vec4(TimeSeconds, TimeSeconds, TimeSeconds, TimeSeconds);                 // shader playback time (in seconds)
	ioMouse = vec4(MousePos.x, MousePos.y, MousePos.z, 0.0);            // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = vec4(oMPos.xyz*NGScale, 0.0);
	ioUV = ioFragCoord;
	ioNormal = vec4(-Normal, 0.0);

	ioFragCoord_DX = vec4(0);
	ioUV_DX = vec4(0);
	ioNormal_DX = vec4(0);
	ioPosition_DX = vec4(0);

	ioFragCoord_DY = vec4(0);
	ioUV_DY = vec4(0);
	ioNormal_DY = vec4(0);
	ioPosition_DY = vec4(0);

//	ioAlbedoColor = oC;
//	ioReflectionColor = Color2;
//	ioGloss = vec4One * Color2.x;
//	ioEmissive = Color2;
//	ioOpacity = vec4One * Color.w;
	
	ioDisplacement = 0;
	
	ioLightDir = vec4(LightDir.xyz, 0.0);
	ioCameraPosition = vec4(g_LocalViewPos.xyz, 0.0);
	ioIteration = vec4One * CurrentIteration;
	
	vec3 t; 	
	vec3 c1 = cross(-oN, vec3(0.0, 0.0, 1.0)); 
	vec3 c2 = cross(-oN, vec3(0.0, 1.0, 0.0)); 
	if (length(c1) > length(c2))
	  t = c1;	
	else
	  t = c2;	
	t = normalize(t);
	
/*	
	vec3 z = normalize(-oN);
	vec3 x = normalize(cross(t, z)); 
	vec3 y = normalize(cross(z, x));
	{
		ioPosition = P+vec4(x, 0.0)*0.001;
		ioFragCoord = ioPosition*0.005/(OverallScale+0.001);
		ioUV = ioFragCoord;
		NODE_CODE;
		ioPosition+=ioNormal*ioDisplacement;
	}
	vec3 iPosNormalBufX = ioPosition.xyz;
	{
		ioPosition = P+vec4(y, 0.0)*0.001;
		ioFragCoord = ioPosition*0.005/(OverallScale+0.001);
		ioUV = ioFragCoord;
		NODE_CODE;	
		ioPosition+=ioNormal*ioDisplacement;
	}
	vec3 iPosNormalBufY = ioPosition.xyz;*/
	{
		ioPosition = P*NGScale;
		ioFragCoord = ioPosition*0.005/(OverallScale+0.001);
		ioUV = ioFragCoord;
		NODE_CODE;	
		ioPosition+=ioNormal*ioDisplacement*NGScale;
		
		//vec3 iz = normalize(iPosNormalBufY-ioPosition.xyz);
		//vec3 ix = cross(normalize(iPosNormalBufX-ioPosition.xyz), iz); 
		//oN = normalize(-ix);//normalize(ioPosition.xyz-iPosNormalBuf.xyz);
	}
	
	NP = vec4(ioPosition.xyz/NGScale, P.w);
	
#endif	
	
	vec4 PC = NP;// * g_WorldViewProjectionMatrix;
//#ifndef FragColor
	oWorldPos = P.xyz;
//#endif
	oExtra.w = 1.0/PC.w;

	
	oPos = PC;	
	
#ifdef USE_DEPTH
	oExtra.yz =  (1.0 + oPos.xy / oPos.w ) / 2.0;
	//oExtra.z = (1.0 - oExtra.z);
	oExtra.yz += vec2(du/2,dv/2);
#else
	oExtra.yz = vec2(0.0);
#endif
	oC.xyz*=oC.w;
	gl_Position = oPos;
}


