
uniform float TextureWidth;//, float(pModelPointsScope->Lx));
uniform float TextureHeight;//, float(pModelPointsScope->Ly));
uniform vec4 QuadPosition;//, Vector4D(aGPUQX / (pModelPointsScope->Lx / GPUQuadSize), aGPUQY / (pModelPointsScope->Ly / GPUQuadSize), aGPUQX, aGPUQY);

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;
in vec3 Tangent;
in vec3 BiTangent;
in vec4 Indices;
in vec4 Weights;

//in vec3 Pos;
//in vec2 TexCoord;

out vec4 oPos;
out vec2 oTexCoord;
out vec4 oqPos;

out vec4 oIOPosition;
out vec4 oIONormal;

void main() {
	float GPUQuadSize = 512.0;
	
	oTexCoord.x = TexCoord.x;
	oTexCoord.y = TexCoord.y;
	oPos.x = (TexCoord.x-QuadPosition.x)*(TextureWidth/GPUQuadSize)*2.0-1.0;
	oPos.y = (TexCoord.y-QuadPosition.y)*(TextureHeight/GPUQuadSize)*2.0-1.0;
	oPos.z = 0.0;
	oPos.w = 1.0;

	oqPos.x = oPos.x*0.5+0.5;
	oqPos.y = (oPos.y*0.5+0.5);
	oqPos.z = 1.0;
	oqPos.w = 1.0;
	
	oIOPosition = vec4(Pos, 0);
	oIONormal = vec4(Normal, 0);
	
	gl_Position = oPos;
	
}
