//

#ifdef ARTISTIC
uniform vec4		SpecularFace;
uniform vec4		SpecularEdge;
uniform float 		SpecFresnelExp;
uniform float 		SpecTextured;
#endif

#ifdef VOLUME
uniform vec4 emitColor;
uniform vec4 transparentColor;
uniform float densityFloat;
uniform float anisotropy;
#endif

#ifdef PHYSICAL
uniform vec4		SpecularEdge;
uniform float 		RefractionIndexR;
uniform float 		RefractionIndexG;
uniform float 		RefractionIndexB;
uniform float 		ExtinctionCoefR;
uniform float 		ExtinctionCoefG;
uniform float 		ExtinctionCoefB;
uniform float 		SpecTextured;
#endif

#ifdef CLEAR_COAT
uniform vec4		ClearCoatFace;
uniform vec4		ClearCoatEdge;
uniform float 		CCFresnelExponent;
uniform float		ClearCoatRoughness;
uniform float 		CCGlossByGlossTxtR;
uniform float		CCByGlossTxtA;
uniform float 		CCPaintReplace;
#endif

#ifdef FUZZ
uniform float		Fuzz;
uniform float		FuzzOnTop;
uniform vec4		FuzzColor;
uniform float 		FuzzTint;
uniform float 		FuzzByGlossTxtB;
uniform float		FuzzPaintReplace;
#endif

#ifdef ANISOTROPIC
uniform float Anisotropic;
uniform float AnisotropicAngle;
uniform float AnisoByGlossB;
uniform float AnisoByMetR;
uniform float AnisoAngByMetB;
#endif

#ifdef MICROPROTRUSIONS
uniform float		Microprotrusions;
uniform vec4		MicroprotrusionsColor;
uniform float		MicroRidges;
uniform float		MicroRidgesAngle;
uniform float		MicroprotrusionsGloss;
uniform float 		MicroprotrusionsTint;
#endif

#ifdef REFRACTION
uniform vec4 RefractionColor;
uniform float RefractionTint;
uniform float RefractionRoughness;
uniform float RefractionRoughByTxt;
uniform float RefractionIOR;
#endif

uniform float EmissionGain = 1;
uniform float LightIntensity = 0;

float fresnelIE(float n, float k, float c) {
    float k2=k*k;
    float rs_num = n*n + k2 - 2*n*c + c*c;
    float rs_den = n*n + k2 + 2*n*c + c*c;
    float rs = rs_num/ rs_den ;
     
    float rp_num = (n*n + k2)*c*c - 2*n*c + 1;
    float rp_den = (n*n + k2)*c*c + 2*n*c + 1;
    float rp = rp_num/ rp_den ;
     
    return clamp(0.5*( rs+rp ), 0.0, 1.0);
}

vec3 refract(vec3 RayDir, vec3 Normal, float Eta) 
{ 
	float DRN = dot(Normal, RayDir);
	float k = 1.0f - Eta * Eta * (1.0f - (DRN*DRN));
	if(k < 0.0f) return vec3(0,0,0);
	return Eta * RayDir - (Eta * dot(Normal, RayDir) + sqrt(k)) * Normal;
}
