
// Vertex shader

in vec3 Pos;
in vec2 TexCoord;

out vec4 oPos;
out vec2 oTexCoord;

void main() {
	oTexCoord.x = TexCoord.x;
	oTexCoord.y = TexCoord.y;
	oPos.x = Pos.x;
	oPos.y = Pos.y;
	oPos.z = Pos.z;
	oPos.w = 1.0;

	gl_Position = oPos;
	
}


// Fragment shader

in vec4 oPos;
in vec2 oTexCoord;

out vec4 FragColor;
uniform sampler2D Panorama;

uniform float aPow;
uniform float BlurX;
uniform float BlurY;

void main() {
	float sizeMod = 2.0;
	vec4 SrcColor = vec4(0.0, 0.0, 0.0, 1.0);
	float fx = 0.0;
	float vSumm = 0.0;
	for(int ix = 0; ix < 8; ix++){
		fx += 6.28319/5.0;
		//float vSin = sin(fx+oTexCoord.y*123.0+oTexCoord.x*6123.0+(BlurX+aPow)*129.0);
		float ri = fx*0.78539;//+sin(oTexCoord.y*6127.87)*oTexCoord.x*65123.54*(BlurX+aPow)*fy;
		float rX = sin(ri);
		float rY = cos(ri);
		
		float fy = 0.0;
		for(int iy = 0; iy < 5; iy++){
			fy += 1.0;
			
			float u = oTexCoord.x+rX*fy*mix(BlurX*sizeMod, BlurX*sizeMod+0.1, 0.5-sin(oTexCoord.y*3.14159)*0.5);
			float v = 1.0-oTexCoord.y+rY*fy*BlurY*sizeMod;
			if(v > 1.0){
				v = 1.0-v;
				u += 0.5;
			}
			if(v < 1.0){
				v = abs(v);
				u += 0.5;
			}
			vec4 iSmpColor = texture(Panorama, vec2(u, min(1.0-BlurY,max(BlurY,v))));	
			SrcColor.xyz += iSmpColor.xyz*(5.0-iSmpColor.w*4.0)*fy*fy;
			vSumm += fy*fy;
		}
	}
	
	SrcColor.xyz /= vSumm;
	//SrcColor.xyz = pow(SrcColor.xyz, vec3(1.0/2.2));
	//SrcColor.xyz = mix(SrcColor.xyz, vec3((SrcColor.x+SrcColor.y+SrcColor.z)*0.3333), vec3(0.1));
	SrcColor.xyz *= aPow;
	float MaxCnl = max(max(SrcColor.x, SrcColor.y),SrcColor.z);
	float MaxDiv = max(MaxCnl,1.0);
	SrcColor.xyz /= MaxDiv;
	
	
	FragColor = vec4(SrcColor.xyz,1.0-saturate((MaxDiv-1.0)*0.25));	
	
}


