// Vertex shader
uniform mat4 WorldToLocal;
uniform mat4 ShadowTM;
uniform float aTxtWidth;
uniform float aTxtHeight;
uniform float aBias;
uniform vec4 RandomPos;


in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;
in vec3 Tangent;
in vec3 BiTangent;
in vec4 Indices;
in vec4 Weights;

out vec3 oPos;
out vec2 oTexCoord;
out vec4 wPos;
out vec4 wPos2;
out vec3 N;
out vec3 T;
out vec3 B;
out vec4 oIndices;
out vec4 oWeights;
out vec4 oColor1;
out vec4 oColor2;


void main() {

//#ifdef SURF_MODE
	vec4 P = vec4(TexCoord.x*2.0-1.0, 0.0-(TexCoord.y*2.0-1.0), 0.5, 1.0);
//#else	
	//vec4 P = vec4(TexCoord.x*2.0-1.0+RandomPos.x/aTxtWidth, 0.0-(TexCoord.y*2.0-1.0+RandomPos.y/aTxtHeight), 0.5, 1.0);
//#endif	
	wPos = vec4(Pos,0.0);
	
	N=Normal;
	T=Tangent.xyz;
	B=BiTangent.xyz;
	
	oTexCoord.x = TexCoord.x;
	oTexCoord.y = TexCoord.y;
	oPos = P.xyz;
	oIndices = Indices;
	oWeights = Weights;
	
	oColor1 = vec4(0, 0, 0, 0);
	oColor2 = vec4(0, 0, 0, 0);
#ifdef SURF_MODE
	oColor1 = vec4(Tangent, Weights.x);
	oColor2 = vec4(BiTangent, Weights.y);
	T = vec3(0, 0, 0);
	B = vec3(0, 0, 0);
#endif
	
	gl_Position = P;

#ifdef MICRO_VERTEX
	wPos += vec4(Normal*aBias,0.0);
#endif
	
#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
	wPos += vec4(Normal*aBias,0.0);
	vec3 normalB = Normal;
	float vd = distance(normalB, oIndices.xyz);
	if (vd > 0.6){
		float e = (vd - 0.6) / 2.0;
		normalB = normalB*(1.0 - e) + oIndices.xyz*e;
		normalize(normalB);
	}
	
	float NormTangDist =  Weights.w;
	#ifdef THICKNESS
		wPos2 = vec4(Pos - (normalB*max(Indices.w * (NormTangDist / 1.41421356)/2.0, aBias)), 0);
	#else
		wPos2 = vec4(Pos + (normalB*max(Indices.w * (NormTangDist / 1.41421356)/2.0, aBias)), 0);
	#endif
#endif	
	
}

// Pixel shader
uniform mat4 WorldToLocal;
uniform float NGScale;

in vec3 oPos;
in vec2 oTexCoord;
in vec4 wPos;
in vec4 wPos2;
in vec3 N;
in vec3 T;
in vec3 B;
in vec4 oIndices;
in vec4 oWeights;
in vec4 oColor1;
in vec4 oColor2;   
   
uniform sampler2D s_DepthMap;
uniform sampler2D s_Grab;
uniform sampler2D s_NormalMap;
uniform sampler2D s_ColorMap;
uniform sampler2D s_SpecularMap;
uniform sampler2D Panorama;

uniform float PanoramaShift;
uniform float FromUVOverlap;
uniform float RayID;
uniform vec4 aColorE;
uniform float aColorCnl;
uniform vec4 aSSSColorRE;
uniform vec4 aSSSColorRE2;
uniform vec4 aPM1;
uniform vec4 aPM2;
uniform vec4 aPM3;
uniform vec3 aPMi1;
uniform vec3 aPMi2;
uniform vec3 aPMi3;
uniform vec4 aWHE;
uniform vec4 aHalfWH;
uniform float aModelLength;
uniform float aBias;
uniform float aaStep;
uniform float SSSRadius;
uniform float SSScattering;
uniform float FirstLayerWeight;
uniform float Clarity;
uniform float aTxtWidth;
uniform float aTxtHeight;
uniform float aShadowMapPXWidth;
uniform float aShadowMapWidth;
uniform vec4 RandomPos;
uniform vec3 PosShift;
uniform float Exposition;
uniform vec3 ExtraGamma;

//uniform mat4 g_WorldMatrix;
//uniform mat4 g_WorldMatrixInverse;



#ifdef SURF_MODE
uniform sampler2D VoxPosXYMap;
uniform sampler2D VoxPosZMap;
uniform sampler2D VoxAlbedoMap;
#endif

#include "/Templates/contrast.glsl"

//#define FAST

out vec4 FragColor;
void main() {
	
	int iRayID = int(RayID);
	
#ifdef SURF_MODE
	

	int iFromUVOverlap = 0;
	int iUVOverlap = 0;
	
#else
	int iFromUVOverlap = int(FromUVOverlap);
	int iUVOverlap = int(oWeights.z)-iFromUVOverlap;
	
#if defined(AO) || defined(CURVATURE) || defined(THICKNESS) || defined(LOCAL_CURVATURE) || defined(LOCAL_CURVATURE_RGB)
	if(iUVOverlap > 2) discard;
#else
	if(iUVOverlap > 0) discard;
#endif	
	if(iUVOverlap < 0) discard;
	
#endif
	
	float iGloss = 0.0;
	float iMetal = 0.0;
	float iEmissive = 0.5;
#ifdef SURF_MODE
	vec4 nrm = texture(s_NormalMap,vec2(oTexCoord.x-0.5/aTxtWidth, 1.0-oTexCoord.y-0.5/aTxtHeight));  
	iEmissive = nrm.w;
	nrm.w = 0;
	vec4 normal=normalize(vec4(nrm.x*2-1, nrm.y*2-1, nrm.z*2-1, 0));
	
#else	
	vec4  nrm = texture(s_NormalMap,oTexCoord);   
	iGloss = nrm.w;
	nrm.w = 0;

#ifdef MICRO_VERTEX
	vec4 normal = vec4(N, 0.0);
#else
	vec3  N2=vec3(nrm.x*2-1,0.0,nrm.y*2-1);
	N2.y=sqrt(1-N2.x*N2.x-N2.z*N2.z);	
	vec3 nn=normalize(N);
	vec3 tt=normalize(T-nn*dot(T,nn));
	vec3 bb=normalize(B-nn*dot(B,nn)-tt*dot(B,tt));
	N2=nn*N2.y-tt*N2.x-bb*N2.z;

	vec3 N3 = normalize(N2);	

	vec4 normal = vec4(N3.x, N3.y, N3.z, 0.0);

	float vd = distance(normal.xyz, oIndices.xyz);
	if (vd > 0.6){
		float e = (vd - 0.6) / 2.0;
		normal.xyz = normal.xyz*(1.0 - e) + oIndices.xyz*e;
		normalize(normal);
	}
#endif
#endif
///////////////////////////////////////////////////////////////////////////////////////////////////	
///////////////////////////////////////////////////////////////////////////////////////////////////

	vec4 iCavity = vec4(0.5);
	vec4 svAlbedo = vec4(1.0);   
#ifdef SURF_MODE

	vec4  rXYPos = texture(VoxPosXYMap,vec2(oTexCoord.x-0.5/aTxtWidth, 1.0-oTexCoord.y-0.5/aTxtHeight));   
	iCavity = texture(VoxPosZMap,vec2(oTexCoord.x-0.5/aTxtWidth, 1.0-oTexCoord.y-0.5/aTxtHeight));   
//	float svGloss = rZPos.z;   
//	float svMetal = rZPos.w;   
	float svGloss = floor(rXYPos.w)*0.0039;
	float svMetal = fract(rXYPos.w);
	svAlbedo = texture(VoxAlbedoMap,vec2(oTexCoord.x-0.5/aTxtWidth, 1.0-oTexCoord.y-0.5/aTxtHeight)).zyxw;   
	iGloss = svGloss;
	iMetal = svMetal;

	
	float rX = (rXYPos.x)*aModelLength;
	float rY = (rXYPos.y)*aModelLength;
	float rZ = (rXYPos.z)*aModelLength;
	vec4 pxPos = vec4(rX, rY, rZ, 0.0)+normal*aBias*2;
	
#else
	#ifdef WORLD_NORMAL_MAP
		float NormTangDist = distance(normal.xyz, oIndices.xyz);
		float VertSize = oIndices.w;
		#ifdef THICKNESS
			vec4 pxPos = wPos - normal*max(VertSize * (NormTangDist / 1.41421356)/2.0, aBias);
		#else // !THICKNESS
			vec4 pxPos = wPos + normal*max(VertSize * (NormTangDist / 1.41421356)/2.0, aBias);
		#endif // !THICKNESS
	#else // !WORLD_NORMAL_MAP
		vec4 pxPos = wPos+(RandomPos*oIndices.w * oWeights.w / 2.0);
	#endif // !WORLD_NORMAL_MAP
#endif	
	pxPos += vec4(RandomPos.x*aBias/2, RandomPos.y*aBias/2, RandomPos.z*aBias/2, 0);	
	
	vec3 LocalPos = (vec4(pxPos.xyz- PosShift.xyz,1.0) * WorldToLocal).xyz;
	vec3 WorldPos = pxPos.xyz-PosShift.xyz;
	
	
#ifdef CURVATURE
	pxPos += normal*(aModelLength * SSSRadius / 150.0f)+vec4(RandomPos.x, RandomPos.y, RandomPos.z, 0)*(aModelLength * SSSRadius / 300.0);
#endif
	
	
	vec4 mPXPos = vec4(dot(pxPos.xyz, aPM1.xyz), dot(pxPos.xyz, aPM2.xyz), dot(pxPos.xyz, aPM3.xyz), 0.0);
	vec4 SMUV4 = (mPXPos/aModelLength)+vec4(0.5,0.5,0.5,0.0);
	vec2 SMUV = vec2(SMUV4.x, SMUV4.y);
	
#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
	vec4 pxPos2 = wPos2;
	#ifdef CURVATURE
		pxPos2 += normal*(aModelLength * SSSRadius / 150.0f)+vec4(RandomPos.x, RandomPos.y, RandomPos.z, 0)*(aModelLength * SSSRadius / 300.0);
	#endif // CURVATURE
	pxPos2 += vec4(RandomPos.x*aBias/2, RandomPos.y*aBias/2, RandomPos.z*aBias/2,0);	
	vec4 mPXPos2 = vec4(dot(pxPos2.xyz, aPM1.xyz), dot(pxPos2.xyz, aPM2.xyz), dot(pxPos2.xyz, aPM3.xyz),0);
	vec4 SMUV42 = (mPXPos2/aModelLength)+vec4(0.5,0.5,0.5,0);
	vec2 SMUV2 = vec2(SMUV42.x, SMUV42.y);
	float mPXDepht2 = (mPXPos2.z) / aModelLength + 0.5;
#endif // !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
	
	vec4 LightDirR = aPM3;
	vec4 LightDir = -aPM3;
	LightDir = normalize(LightDir);
	LightDirR = normalize(LightDirR);

#if defined(REFRACTION_SSS) || defined(SSS)
	float SNMDistR = saturate(dot(normal.xyz, LightDirR.xyz));
	float NMDistSR = abs(distance(normal.xyz,normalize(aPM3.xyz))/1.41421356-1.0);
	float SurfaceRoughness = saturate(1.0-Clarity);//*(1.0-NMDistSR);
	normal += normalize(RandomPos)*SurfaceRoughness*pow(SSScattering,0.2)*0.999;
	normal.w = 0.0;
	normal.xyz = normalize(normal.xyz);
#endif

	float NMDist = saturate(dot(normal.xyz, LightDir.xyz));
	float NMDistR = saturate(dot(normal.xyz, LightDirR.xyz));
	
	float mPXDepht = (mPXPos.z) / aModelLength + 0.5;
	
	float rndE = 1.0-(RandomPos.w*RandomPos.w);
	vec4 RandomPosE = RandomPos*rndE;


#if defined(REFRACTION_SSS) || defined(SSS)
	vec2 SMUVR = vec2(SMUV4.x, SMUV4.y);
	float rpy = pow(RandomPos.y, 3.0);
	SMUVR.x = saturate(SMUVR.x+sin(RandomPos.y*234.0)*RandomPos.y*max(0.0, SSScattering/2.0-0.1)*SSSRadius);
	SMUVR.y = saturate(SMUVR.y+cos(RandomPos.y*234.0)*RandomPos.y*max(0.0, SSScattering/2.0-0.1)*SSSRadius);

#ifdef FAST
	vec4 ShadowMapPXR = texture(s_DepthMap,SMUVR)*255.0;   
	
    float rR = ShadowMapPXR.r;
    float gR = ShadowMapPXR.g;
    float bR = ShadowMapPXR.b;
	float dPosR = ((rR+(gR+bR/255.0)/255.0)/255.0);

#else
	vec4 ShadowMapPXR = texture(s_DepthMap,SMUVR);   
	float dPosR = ShadowMapPXR.r;
#endif
#endif

#ifdef FAST
	vec4 ShadowMapPX = texture(s_DepthMap,SMUV)*255.0;   
	
    float r = ShadowMapPX.r;
    float g = ShadowMapPX.g;
    float b = ShadowMapPX.b;
	float dPos = ((r+(g+b/255.0)/255.0)/255.0);
#else
	vec4 ShadowMapPX = texture(s_DepthMap,SMUV);   
	float dPos = ShadowMapPX.r;

#endif	
	
	
#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)

#ifdef FAST
	vec4 ShadowMapPX2 = texture(s_DepthMap,SMUV2)*255.0;   
	
    float r2 = ShadowMapPX2.r;
    float g2 = ShadowMapPX2.g;
    float b2 = ShadowMapPX2.b;
	float dPos2 = ((r2+(g2+b2/255.0)/255.0)/255.0);
#else

	vec4 ShadowMapPX2 = texture(s_DepthMap,SMUV2);   
	float dPos2 = ShadowMapPX2.r;

#endif	
	
#endif	

	
	vec4 resultPixel = texture(s_Grab, vec2(oTexCoord.x, 1.0-oTexCoord.y));
	
	

	bool inRay = false;
#ifdef LOCAL_CURVATURE

	inRay = false;
	if (abs(dPos - mPXDepht) < aBias*2.0) inRay = true;

	if (inRay) {
	
		float iRadius = 1.0+SSSRadius*0.05*(RandomPos.w*RandomPos.w)*aShadowMapWidth;
		
		
		vec4 iLeft = texture(s_DepthMap,SMUV-vec2(aShadowMapPXWidth*iRadius,RandomPos.z*iRadius*aShadowMapPXWidth)).yzwx;   
		vec4 iTop = texture(s_DepthMap,SMUV-vec2(-RandomPos.z*iRadius*aShadowMapPXWidth,aShadowMapPXWidth*iRadius)).yzwx;   
		vec4 iRight = texture(s_DepthMap,SMUV+vec2(aShadowMapPXWidth*iRadius,RandomPos.z*iRadius*aShadowMapPXWidth)).yzwx;   
		vec4 iBottom  = texture(s_DepthMap,SMUV+vec2(-RandomPos.z*iRadius*aShadowMapPXWidth,aShadowMapPXWidth*iRadius)).yzwx;   

		float xDDist = abs(iLeft.w-ShadowMapPX.x)/abs(iRight.w-ShadowMapPX.x);
		float yDDist = abs(iTop.w-ShadowMapPX.x)/abs(iBottom.w-ShadowMapPX.x);
		
		for(int i = 0; i < 4; i++){
			if(xDDist < 0.1*(1.2-SSSRadius) || xDDist > 10.0/(1.2-SSSRadius) || yDDist < 0.1*(1.2-SSSRadius) || yDDist > 10.0/(1.2-SSSRadius)){
				iRadius *= 0.5;

				iLeft = texture(s_DepthMap,SMUV-vec2(aShadowMapPXWidth*iRadius,RandomPos.z*iRadius*aShadowMapPXWidth)).yzwx;   
				iTop = texture(s_DepthMap,SMUV-vec2(-RandomPos.z*iRadius*aShadowMapPXWidth,aShadowMapPXWidth*iRadius)).yzwx;   
				iRight = texture(s_DepthMap,SMUV+vec2(aShadowMapPXWidth*iRadius,RandomPos.z*iRadius*aShadowMapPXWidth)).yzwx;   
				iBottom  = texture(s_DepthMap,SMUV+vec2(-RandomPos.z*iRadius*aShadowMapPXWidth,aShadowMapPXWidth*iRadius)).yzwx;   

				xDDist = abs(iLeft.w-ShadowMapPX.x)/abs(iRight.w-ShadowMapPX.x);
				yDDist = abs(iTop.w-ShadowMapPX.x)/abs(iBottom.w-ShadowMapPX.x);
				
			} else break;
		}
		float iRadiusI = 1.0/iRadius;
		
		if(xDDist < 0.1 || xDDist > 10.0) discard;
		if(yDDist < 0.1 || yDDist > 10.0) discard;

		vec3 iLeftL = normalize(vec3(dot(iLeft.xyz, aPM1.xyz), dot(iLeft.xyz, aPM3.xyz), dot(iLeft.xyz, aPM2.xyz)));
		vec3 iTopL = normalize(vec3(dot(iTop.xyz, aPM1.xyz), dot(iTop.xyz, aPM3.xyz), dot(iTop.xyz, aPM2.xyz)));
		vec3 iRightL = normalize(vec3(dot(iRight.xyz, aPM1.xyz), dot(iRight.xyz, aPM3.xyz), dot(iRight.xyz, aPM2.xyz)));
		vec3 iBottomL = normalize(vec3(dot(iBottom.xyz, aPM1.xyz), dot(iBottom.xyz, aPM3.xyz), dot(iBottom.xyz, aPM2.xyz)));

		vec4 iCenterL = normalize(vec4(dot(ShadowMapPX.yzw, aPM1.xyz), dot(ShadowMapPX.yzw, aPM3.xyz), dot(ShadowMapPX.yzw, aPM2.xyz), 0.0));
		
		
//		float curv = (iCenterL.x-iLeftL.x)*saturate(iLeft.w*1000.0)*iRadiusI+(iCenterL.z-iTopL.z)*saturate(iTop.w*1000.0)*iRadiusI;
//		curv += (iRightL.x-iCenterL.x)*saturate(iRight.w*1000.0)*iRadiusI+(iBottomL.z-iCenterL.z)*saturate(iBottom.w*1000.0)*iRadiusI;
		
//		curv *= aShadowMapWidth*0.001;

		float curv = (iCenterL.x-iLeftL.x)*saturate(iLeft.w*1000.0)+(iCenterL.z-iTopL.z)*saturate(iTop.w*1000.0);
		curv += (iRightL.x-iCenterL.x)*saturate(iRight.w*1000.0)+(iBottomL.z-iCenterL.z)*saturate(iBottom.w*1000.0);

		float R2IE = saturate(SSSRadius);
		
		curv = asin(curv)/*0.3183*/;
		curv *= abs(curv)*mix(1.0, abs(curv), R2IE);
							
		curv *= aShadowMapWidth*0.012*iRadiusI;

		
		
		float cavity = saturate(curv*0.25);
		cavity = mix(cavity*1.5, cavity*8.0, R2IE);
							
		float bugle = saturate(-curv*0.25);
		bugle = mix(bugle*1.0, bugle*8.0, R2IE);
		
		NMDist *= saturate(ShadowMapPX.x*1000.0);
		resultPixel.xyz += vec3(cavity-bugle)*NMDist;
//		resultPixel.xyz += (ShadowMapPX.yzw*0.5+vec3(0.5))*NMDist;
		
		resultPixel.w += NMDist;

		
	} else{
		discard;
	}
    FragColor = resultPixel;

	return;

#endif
#ifdef LOCAL_CURVATURE_RGB
	inRay = false;
	if (abs(dPos - mPXDepht) < aBias*2.0) inRay = true;

	if (inRay) {
		NMDist *= saturate(ShadowMapPX.x*1000.0);
		vec3 CNLRadius = vec3(0.03, 0.21, 1.47); 
		for(int iCNL = 0; iCNL < 3; iCNL++){
			float iRadius = 1.0+CNLRadius[iCNL]*0.05*(RandomPos.w*RandomPos.w)*aShadowMapWidth;
			
			float iRadiusI = 1.0/iRadius;
			
			vec4 iLeft = texture(s_DepthMap,SMUV-vec2(aShadowMapPXWidth*iRadius,RandomPos.z*iRadius*aShadowMapPXWidth)).yzwx;   
			vec4 iTop = texture(s_DepthMap,SMUV-vec2(-RandomPos.z*iRadius*aShadowMapPXWidth,aShadowMapPXWidth*iRadius)).yzwx;   
			vec4 iRight = texture(s_DepthMap,SMUV+vec2(aShadowMapPXWidth*iRadius,RandomPos.z*iRadius*aShadowMapPXWidth)).yzwx;   
			vec4 iBottom  = texture(s_DepthMap,SMUV+vec2(-RandomPos.z*iRadius*aShadowMapPXWidth,aShadowMapPXWidth*iRadius)).yzwx;   

			if(iCNL == 1){
				float xDDist = abs(iLeft.w-ShadowMapPX.x)/abs(iRight.w-ShadowMapPX.x);
				if(xDDist < 0.1 || xDDist > 10.0) discard;
				float yDDist = abs(iTop.w-ShadowMapPX.x)/abs(iBottom.w-ShadowMapPX.x);
				if(yDDist < 0.1 || yDDist > 10.0) discard;
			}
			
			vec3 iLeftL = normalize(vec3(dot(iLeft.xyz, aPM1.xyz), dot(iLeft.xyz, aPM3.xyz), dot(iLeft.xyz, aPM2.xyz)));
			vec3 iTopL = normalize(vec3(dot(iTop.xyz, aPM1.xyz), dot(iTop.xyz, aPM3.xyz), dot(iTop.xyz, aPM2.xyz)));
			vec3 iRightL = normalize(vec3(dot(iRight.xyz, aPM1.xyz), dot(iRight.xyz, aPM3.xyz), dot(iRight.xyz, aPM2.xyz)));
			vec3 iBottomL = normalize(vec3(dot(iBottom.xyz, aPM1.xyz), dot(iBottom.xyz, aPM3.xyz), dot(iBottom.xyz, aPM2.xyz)));

			vec4 iCenterL = normalize(vec4(dot(ShadowMapPX.yzw, aPM1.xyz), dot(ShadowMapPX.yzw, aPM3.xyz), dot(ShadowMapPX.yzw, aPM2.xyz), 0.0));
			
			
			float curv = (iCenterL.x-iLeftL.x)*saturate(iLeft.w*1000.0)+(iCenterL.z-iTopL.z)*saturate(iTop.w*1000.0);
			curv += (iRightL.x-iCenterL.x)*saturate(iRight.w*1000.0)+(iBottomL.z-iCenterL.z)*saturate(iBottom.w*1000.0);

			float R2IE = saturate(CNLRadius[iCNL]);
			
			curv = asin(curv)/*0.3183*/;
			curv *= abs(curv)*mix(1.0, abs(curv), R2IE);
								
			curv *= aShadowMapWidth*0.012*iRadiusI;
			
			
			float cavity = saturate(curv*0.25);
			cavity = mix(cavity*1.5, cavity*8.0, R2IE);
								
			float bugle = saturate(-curv*0.25);
			bugle = mix(bugle*1.0, bugle*8.0, R2IE);
			
			resultPixel[iCNL] += (cavity-bugle)*NMDist;
			

		}
		resultPixel.w += NMDist;
	} else{
		discard;
	}
    FragColor = resultPixel;

	return;
#endif
#ifdef CURVATURE
	if (dPos > mPXDepht || dPos < 0.01) inRay = true;
	#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
		if (dPos2 > mPXDepht2 || dPos2 < 0.01) inRay = true;
	#endif

	if (inRay) resultPixel[iUVOverlap] += 1.5;

//	if (dPos > 0.01 && NMDistR > 0.0) rayValue = 0.1;//(thickness*NMDistR)*aColorE;

	
#endif

#ifdef SHADOWS_ONLY
	if (dPos > mPXDepht || dPos < 0.01) inRay = true;
	#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
		if (dPos2 > mPXDepht2 || dPos2 < 0.01) inRay = true;
	#endif
	if (!inRay) resultPixel.xyz += aColorE.zyx*NMDist;
#endif
#if defined(REFRACTION_SSS) || defined(SSS)
	float finRay = 0;
	
	float thickness = saturate(1.0-(mPXDepht-dPosR)/SSSRadius);
	
	vec2 TSMUV;
	float rpz = RandomPos.z;
	
	TSMUV.x = saturate(SMUV.x+sin(RandomPos.x*123.0)*RandomPos.y*SSScattering*SSSRadius*(1.1-thickness)*2.0);
	TSMUV.y = saturate(SMUV.y+cos(RandomPos.x*123.0)*RandomPos.y*SSScattering*SSSRadius*(1.1-thickness)*2.0);

#ifdef FAST	
	vec4 TShadowMapPX = texture(s_DepthMap,TSMUV)*255.0;   
	
    float Tr = TShadowMapPX.r;
    float Tg = TShadowMapPX.g;
    float Tb = TShadowMapPX.b;
	float TdPos = ((Tr+(Tg+Tb/255.0)/255.0)/255.0);
#else
	vec4 TShadowMapPX = texture(s_DepthMap,TSMUV);   
	float TdPos = TShadowMapPX.r;
#endif	
	float TthicknessPre = thickness;
	if(TdPos > 0.01 && TdPos < 0.99){
		finRay = SurfaceRoughness;
		TthicknessPre = saturate(1.0-(mPXDepht-TdPos)/SSSRadius);
	} 
	TSMUV.x = saturate(SMUV.x+sin(RandomPos.x*361.0)*rpz*SSScattering*SSSRadius*(1.1-TthicknessPre)*2.0);
	TSMUV.y = saturate(SMUV.y+cos(RandomPos.x*361.0)*rpz*SSScattering*SSSRadius*(1.1-TthicknessPre)*2.0);

#ifdef FAST
	TShadowMapPX = texture(s_DepthMap,TSMUV)*255.0;   
	
    Tr = TShadowMapPX.r;
    Tg = TShadowMapPX.g;
    Tb = TShadowMapPX.b;
	TdPos = ((Tr+(Tg+Tb/255.0)/255.0)/255.0);
#else
	TShadowMapPX = texture(s_DepthMap,TSMUV);   
	TdPos = TShadowMapPX.r;
	float Tthickness = TthicknessPre;
#endif	
	if(TdPos > 0.01 && TdPos < 0.99){
		finRay = SurfaceRoughness;
		Tthickness = saturate(1.0-(mPXDepht-TdPos)/SSSRadius);
	}
	Tthickness = pow(Tthickness,3.0);
	
	float colorTE = max(pow(1.0-Tthickness,FirstLayerWeight), (1.0-NMDistR)*saturate(1.0-FirstLayerWeight)*(1.0-Tthickness));
	vec4 aSSColorE = aColorE*(aSSSColorRE*(1.0-colorTE)+aSSSColorRE2*colorTE);
	
//	float refrVal =  Tthickness*pow(max(saturate(SurfaceRoughness/2.0+NMDist), NMDist),1.001-saturate(SurfaceRoughness*SSScattering))*aSSColorE*(1.5-SurfaceRoughness)*2.0f;
	vec4 refrVal =  aSSColorE*Tthickness*pow(NMDistR, 1.0-SurfaceRoughness*0.5)*(2.0-SurfaceRoughness)*0.5;
	if(dPos > 0.01 && dPos < 0.99) finRay += 1.0;
	if (Tthickness < 0.99) resultPixel.xyz += refrVal.xyz*saturate(finRay);
#endif
#ifdef THICKNESS
	float thickness = pow(saturate(1.0-(mPXDepht-dPos)/SSSRadius),2.0);

	float rayValue = 0;

	if (dPos > 0.01 && NMDistR > 0.0) rayValue = (thickness*NMDistR)*aColorE.x;

	resultPixel[iUVOverlap] += rayValue;


	
#endif
#ifdef SSS
	float thicknessR = pow(saturate(1.0-(mPXDepht-dPosR)/SSSRadius), 3.0f);
	float thicknessRO = pow(saturate(1.0-(mPXDepht-dPos)/SSSRadius), 3.0f);
	float colorTER = max(pow(max(min(1.0-max(thicknessR, thicknessRO), abs(RandomPos.z)), 1.0-pow(SurfaceRoughness,0.5)),FirstLayerWeight), (1.0-NMDist)*saturate(1.0-FirstLayerWeight));
	vec3 aSSColorER = aColorE.zyx*(aSSSColorRE.xyz*(1.0-colorTER)+(aSSSColorRE2.xyz*colorTER));
	inRay = false;
	if (dPos > 0.01 && NMDist >= 0.0) inRay = true;
	#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
		if (dPos2 > 0.01 && NMDist >= 0.0) inRay = true;
	#endif
	if (inRay) resultPixel.xyz += aSSColorER*thicknessR*pow(max(saturate(SurfaceRoughness/2.0+NMDist), NMDist), 1.001-saturate(SurfaceRoughness))*SurfaceRoughness;
#endif
#ifdef RAYS
	inRay = false;
	if (dPos > mPXDepht || dPos < 0.01) inRay = true;
	#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
		if (dPos2 > mPXDepht2 || dPos2 < 0.01) inRay = true;
	#endif
	if (inRay) resultPixel.xyz += aColorE.zyx*NMDist;
	

	
#endif
#ifdef AO
	inRay = false;
	if (dPos > mPXDepht || dPos < 0.01) inRay = true;
	#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
		if (dPos2 > mPXDepht2 || dPos2 < 0.01) inRay = true;
	#endif

	if (inRay) resultPixel.x += aColorE.x*NMDist;


	
#endif
#ifdef BAKE_SHADER

#ifdef SURF_MODE
	svAlbedo = pow(svAlbedo, vec4(2.2)).zyxw*2;
	vec4 iDiffuse = svAlbedo*(1.0-svMetal);
	vec4 iSpecularColor = svAlbedo*svMetal+vec4(1.0-svMetal)*0.1;
#else 
	vec4 iDiffuse = pow(texture(s_ColorMap,oTexCoord),vec4(2.2));   
	vec4 iSpecularColor = pow(texture(s_SpecularMap,oTexCoord),vec4(2.2));   	
#endif

	iGloss = pow(iGloss,0.75);
	float GlossFadeE = iGloss;//*iGloss;
	
	
	float opp = 0.85-GlossFadeE*0.85+(1.0-GlossFadeE*GlossFadeE)*0.15;
	float uu = atan(normal.z,normal.x)/6.2831853;
	float as = asin(normal.y);
	float vv = 0.5+as/3.1415926*(2048.0-pow(2.0,opp*7.0))/2048;	

	vec4 ReflectionColor = textureLod(Panorama, vec2(uu+PanoramaShift, vv), opp * 7.0);	
		ReflectionColor.xyz *= 5.0-ReflectionColor.w*4.0;//extra light range from the texture alpha channel
		ReflectionColor.xyz *= getmodf(ReflectionColor.xyz);
		ReflectionColor.xyz = pow(ReflectionColor.zyx,vec3(2.2))*Exposition*0.5;
		
	inRay = false;
	if (dPos > mPXDepht || dPos < 0.01) inRay = true;
	#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
		if (dPos2 > mPXDepht2 || dPos2 < 0.01) inRay = true;
	#endif
	float iGloss2 = pow(iGloss, 0.5);//pow(iGloss, 0.5);
	float iGlossTrail = iGloss2*iGloss2;//pow(iGloss, 0.5);
	float iSpecular = saturate(1.0-(distance(normalize(-normal.xyz), normalize(LightDirR.xyz))*iGloss2*16.0));
	float iGGXTrail = saturate(1.0-(distance(normalize(-normal.xyz), normalize(LightDirR.xyz))*iGlossTrail*16.0));
	iGGXTrail = iGGXTrail*iGGXTrail;
	
	if (inRay) resultPixel.xyz += min(vec3(6.0),vec3(NMDist)*(iDiffuse.xyz*aColorE.zyx+iSpecularColor.xyz*ReflectionColor.xyz));
#endif

#ifdef DIRAO
	inRay = false;
	if (dPos > mPXDepht || dPos < 0.001) inRay = true;
	#if !defined(SURF_MODE) && !defined(MICRO_VERTEX) && !defined(WORLD_NORMAL_MAP)
		if (dPos2 > mPXDepht2 || dPos2 < 0.001) inRay = true;
	#endif
	
	vec3 N2r = normalize(-aPM3.xyz);
	
	if (RayID < 1) resultPixel.xyz = normal.xyz;
		else if (inRay) resultPixel.xyz += pow(NMDist, 1.0/(SSSRadius*10.0))*N2r.xyz;
	
#endif // DIRAO
#ifdef NODE_CODE
	#line 1000
	ioTime = vec4Zero;                 
	ioMouse = vec4Zero;                
	ioFragCoord = vec4(LocalPos.xyz*NGScale, 0.0);
	ioUV = ioFragCoord;
	ioPosition = vec4(LocalPos.xyz, 0.0);
	ioGlobalPosition = vec4(WorldPos, 0.0);
	ioNormal = vec4(normal.xyz, 0.0);

	ioPM = svAlbedo*0.5;
	ioPQ1 = vec4Zero;
	ioPQ2 = vec4Zero;
	ioPQ3 = vec4Zero;
	ioPQ4 = vec4Zero;
	ioPN = vec4(0.5, 0.5, 0.5+iMetal*0.5, 0.5+iGloss*0.5);
	ioDisplacement = 0;

	ioLightDir = vec4(LightDir.xyz, 0.0);
	ioCameraPosition = vec4Zero;
	ioIteration = vec4One * RayID;
	
	ioCavity = iCavity;
	ioOcclusion = vec4(clamp(iEmissive*2.0 , 0, 1));
	
	NODE_CODE;

	UNPACK_PBM;

	ioPosition += ioNormal*ioDisplacement/NGScale;
	resultPixel.xyz += NODE_REQUEST;
	
#endif
	if(iUVOverlap == 0){
		resultPixel.w += 1.0;
	}

    FragColor = resultPixel;
}
