
// Vertex shader

in vec3 Pos;
in vec2 TexCoord;

out vec4 oPos;
out vec2 oTexCoord;

void main() {
	oTexCoord.x = TexCoord.x;
	oTexCoord.y = TexCoord.y;
	oPos.x = Pos.x;
	oPos.y = Pos.y;
	oPos.z = Pos.z;
	oPos.w = 1.0;

	gl_Position = oPos;
	
}


// Fragment shader

in vec4 oPos;
uniform vec3 ViewPos;
in vec2 oTexCoord;

out vec4 FragColor;
uniform sampler2D sSource;
uniform sampler2D sMipMin;
uniform sampler2D sMipMax;
uniform sampler2D sMipAvr;
uniform sampler2D sMipMin2;
uniform sampler2D sMipMax2;
uniform sampler2D sMipAvr2;

uniform float aSceneTime;

uniform float aBump;
uniform float aEven;
uniform float aHShift;
uniform float aSMod;
uniform float aLMod;
uniform float aBrightness;
uniform float aContrast;
uniform float aGamma;
uniform float aSizeX;
uniform float aSizeY;
uniform float aB;
uniform float acc;

vec3 HSVtoRGB (vec3 hsv){
	
	vec3 rgb;
	
	while(hsv.x<0)hsv.x+=360;
	while(hsv.x>=360)hsv.x-=360;
    int i;
    float f, p, q, t, hTemp;
    float h = hsv.x;
    float s = hsv.y;
    float v = hsv.z;
    float r, g, b;
    if (s == 0.0 || h == -1.0){ // s==0? Totally unsaturated = grey
        rgb.x = rgb.y = rgb.z = v;
    }
    hTemp = h / 60.0;
    i = int(floor(hTemp));                 // which sector
    f = hTemp - i;                      // how far through sector
    p = v * ( 1 - s );
    q = v * ( 1 - s * f );
    t = v * ( 1 - s * ( 1 - f ) );
    switch (i){
        case 0: r = v; g = t; b = p; break;
        case 1: r = q; g = v; b = p; break;
        case 2: r = p; g = v; b = t; break;
        case 3: r = p; g = q; b = v; break;
        case 4: r = t; g = p; b = v; break;
        case 5: r = v; g = p; b = q; break;
        default: r=0 ; g=0 ; b=0 ; break ; // Should never occur
    }
    rgb.x = b;
    rgb.y = g;
    rgb.z = r;
	return rgb;
}

vec3 RGBtoHSV (vec3 rgb){
	vec3 hsv;
    float r = rgb.z;
    float g = rgb.y;
    float b = rgb.x;
    float h, s, v;
    float mn = r, mx = r;
    int maxVal = 0;
    if (g > mx) { mx = g; maxVal = 1; }
    if (b > mx) { mx = b; maxVal = 2; }
    if (g < mn) mn = g;
    if (b < mn) mn = b;
    float  delta = mx - mn;
    v = mx;
    if (mx != 0)
        s = delta/mx;
    else{
        s = 0;
        h = 0;
		hsv.x = h;
		hsv.y = s;
		hsv.z = v;
		return hsv;
    }
    if (s == 0.0){
        h = 0; // Arbritrary
		hsv.x = h;
		hsv.y = s;
		hsv.z = v;
		return hsv;
    }else{
        switch (maxVal){
            case 0: h = 0 + ( g - b ) / delta; break;     // yel  < h < mag
            case 1: h = 2 + ( b - r ) / delta; break;     // cyan < h < yel
            case 2: h = 4 + ( r - g ) / delta; break;     // mag  < h < cyan
            default: h = 0 ; break ; // Should never occur
        }
    }
    h *= 60;
    if (h < 0) h += 360;
    hsv.x = h;
    hsv.y = s;
    hsv.z = v;
	return hsv;
}



void main() {
	float PXSizeX = 1.0/aSizeX;
	float PXSizeY = 1.0/aSizeY;

#ifdef MIP_MIN

	vec4 SrcColor = vec4(1.0, 1.0, 1.0, 1.0);

	for(float ix = -1.0; ix < 1.1; ix += 1.0){
		for(float iy = -1.0; iy < 1.1; iy += 1.0){
			SrcColor = min(SrcColor, texture(sSource, vec2(oTexCoord.x+PXSizeX*ix, 1.0-oTexCoord.y+PXSizeY*iy)));	
		}
	}
	SrcColor.w = 1.0;
	
	FragColor = SrcColor;
#endif
#ifdef MIP_MAX

	vec4 SrcColor = vec4(0.0, 0.0, 0.0, 0.0);

	for(float ix = -1.0; ix < 1.1; ix += 1.0){
		for(float iy = -1.0; iy < 1.1; iy += 1.0){
			SrcColor = max(SrcColor, texture(sSource, vec2(oTexCoord.x+PXSizeX*ix, 1.0-oTexCoord.y+PXSizeY*iy)));	
		}
	}
	SrcColor.w = 1.0;
	FragColor = SrcColor;

#endif
#ifdef MIP_AVR

	vec4 SrcColor = vec4(0.0, 0.0, 0.0, 0.0);

	for(float ix = -1.0; ix < 1.1; ix += 1.0){
		for(float iy = -1.0; iy < 1.1; iy += 1.0){
			SrcColor += texture(sSource, vec2(oTexCoord.x+PXSizeX*ix, 1.0-oTexCoord.y+PXSizeY*iy));	
		}
	}
	SrcColor /= 9.0;
	SrcColor.w = 1.0;
	FragColor = SrcColor;

#endif
#ifdef EFFECT
	vec4 SrcColor = texture(sSource, vec2(oTexCoord.x, 1.0-oTexCoord.y));	

#ifdef USE_EVEN	

	vec4 iMipMin = texture(sMipMin, vec2(oTexCoord.x, 1.0-oTexCoord.y));	
	vec4 iMipMax = texture(sMipMax, vec2(oTexCoord.x, 1.0-oTexCoord.y));	
	vec4 iMipAvr = texture(sMipAvr, vec2(oTexCoord.x, 1.0-oTexCoord.y));	
	
	float BumpIdx = 1.0-fract(6.0 - aBump * 5.0);
	float EvenIdx = 1.0-fract(6.0 - aEven * 6.0);	

	iMipMin = mix(iMipMin, texture(sMipMin2, vec2(oTexCoord.x, 1.0-oTexCoord.y)),BumpIdx);	
	iMipMax = mix(iMipMax, texture(sMipMax2, vec2(oTexCoord.x, 1.0-oTexCoord.y)),BumpIdx);	
	iMipAvr = mix(iMipAvr, texture(sMipAvr2, vec2(oTexCoord.x, 1.0-oTexCoord.y)),EvenIdx);	
	

	
	vec3 iEven = mix(SrcColor.xyz, (SrcColor.xyz - iMipAvr.xyz)+0.5, saturate(aEven*6.0));
	
	SrcColor.xyz = mix(iEven, (SrcColor.xyz - iMipMin.xyz)/mix(vec3(1.0,1.0,1.0), max(iMipMax.xyz-iMipMin.xyz,0.075),saturate(vec3(aEven,aEven,aEven))), saturate(aBump*6.0));
#endif

#ifdef USE_BC	
	SrcColor.xyz = (SrcColor.xyz-vec3(0.5, 0.5, 0.5)+vec3(aBrightness, aBrightness, aBrightness))*acc+vec3(0.5, 0.5, 0.5);
#endif
#ifdef USE_G	
	SrcColor.xyz = pow(SrcColor.xyz, vec3(aGamma, aGamma, aGamma));
#endif

#ifdef USE_HSV
//		if(HSV){
			vec3 hsv = RGBtoHSV(saturate(SrcColor.xyz)*255.0);
			hsv.x+=aHShift;
			while(hsv.x>360)hsv.x-=360;
			while(hsv.x<0)hsv.x+=360;
			hsv.y*=aSMod;
			if(hsv.y>1)hsv.y=1;
			hsv.z*=aLMod;
			if(hsv.z>255)hsv.z=255;
			SrcColor.xyz = HSVtoRGB(hsv)/255.0;
	//	}
#endif
#ifdef NODE_CODE
	ioCameraPosition = vec4(ViewPos, 0.0);
	float uMod = abs(sin(oTexCoord.y*3.14159));
	ioRayDir = -normalize(vec4(cos((oTexCoord.x+0.48)*6.28319)*uMod,/*oTexCoord.y*2.0-1.0*/1.0-(cos(oTexCoord.y*3.14159)*0.5+1.0)/*asin(1.0-oTexCoord.y*2.0)*0.318310*/, sin((oTexCoord.x+0.48)*6.28319)*uMod, 0.0));

	////////////////////////////////////////////////
	ioResolution = vec4(4096.0, 2048.0, 0.0, 0.0);           // viewport resolution (in pixels)
	ioTime = vec4(aSceneTime);                 // shader playback time (in seconds)
	ioTimeDelta = 0.033*vec4One;            // render time (in seconds)
	ioFrame = vec4Zero;                // shader playback frame
	ioMouse = vec4Zero;                // mouse pixel coords. xy: current (if MLB down), zw: click
//	ioDate;                 // (year, month, day, time in seconds)
	ioFragCoord = oTexCoord.xyxy;
	ioPosition = oTexCoord.xyxy;
	ioNormal = vec4(0.0, 1.0, 0.0, 0.0);

	ioAlbedoColor = vec4(SrcColor.xyz, 1.0);
	ioReflectionColor = vec4Zero;
	ioGloss = vec4Zero;
	ioEmissive = vec4Zero;
	ioOpacity = vec4One;
	ioDisplacement = vec4Zero;

	NODE_CODE;


//	Normal.xyz = -ioNormal.xyz;

//	tSpecular = ioAlbedoColor.xyz*saturate(ioMetal.xyz);
	SrcColor = ioAlbedoColor;
//	ioReflectionColor *= vec4One-saturate(ioMetal);
//	tColor = ioAlbedoColor.xyz;
//	tSpecular += ioReflectionColor.xyz;
//	Gloss = ioGloss.w;
//	Emiss = ioEmissive.xyz;
//	sfColor.w = ioOpacity.w;
#endif
	
	
	FragColor = SrcColor;
#endif
}


