// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_ViewerPos;

in vec3 Pos;
in vec4 Color;

out vec4 v_Color;

void main() {
	vec3 D=normalize(g_ViewerPos-Pos);	
	vec4 P = vec4(Pos+D*0.01, 1.0);
	gl_Position = P * g_WorldViewProjectionMatrix;
	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;

out vec4 FragColor;
void main() {
	FragColor = v_Color;
}