// Vertex shader

uniform mat4 g_ScreenMatrixInverse;

in vec3 Pos;
in vec2 TexCoord;

out vec2 v_TexCoord;

void main() {
	gl_Position = vec4(Pos, 1.0) * g_ScreenMatrixInverse;
	v_TexCoord = TexCoord;
}

// Fragment shader

in vec2 v_TexCoord;

uniform sampler2D s_Src;
uniform vec3 c_Gamma;
uniform float aces;

out vec4 FragColor;

const mat3 ACESInputMat = mat3(
	0.59719, 0.35458, 0.04823,
	0.07600, 0.90834, 0.01566,
	0.02840, 0.13383, 0.83777
);

// ODT_SAT => XYZ => D60_2_D65 => sRGB
const mat3 ACESOutputMat = mat3(
	 1.60475, -0.53108, -0.07367,
	-0.10208,  1.10813, -0.00605,
	-0.00327, -0.07276,  1.07602
);

vec3 RRTAndODTFit(vec3 v)
{
    vec3 a = v * (v + 0.0245786f) - 0.000090537f;
    vec3 b = v * (0.983729f * v + 0.4329510f) + 0.238081f;
    return a / b;
}

vec3 ACESFitted(vec3 color)
{
    color *= ACESInputMat;

    // Apply RRT and ODT
    color = RRTAndODTFit(color);

    color *= ACESOutputMat;

    // Clamp to [0, 1]
    color = saturate(color);

    return color;
}
// Narkowicz 2015, "ACES Filmic Tone Mapping Curve"
vec3 acesFilm(vec3 x) {
  const float a = 2.51;
  const float b = 0.03;
  const float c = 2.43;
  const float d = 0.59;
  const float e = 0.14;
  return clamp((x * (a * x + b)) / (x * (c * x + d) + e), 0.0, 1.0);
}
void main() {
	vec4 c = texture(s_Src, v_TexCoord);
	c.rgb = pow(c.rgb, vec3(1.0) / c_Gamma);
	FragColor = c;
}