
import coat
from cTemplates.Structs import *

NoCache = True
Surface = True


def SetType(noCache, surface):
   global NoCache
   global Surface
   NoCache = noCache
   Surface = surface
     
@d_rmb_menu
def VoxTreeRmb():
   global NoCache
   global Surface
   NoCache = not coat.menu_property("RMBObjectInCache")
   Surface = coat.menu_property("RMBObjectIsSurface")

   coat.menu_item("$AutoPick")
   coat.menu_item("EditProcedural")
   coat.menu_item("ChooseRefColor")

@d_submenu("Settings", VoxTreeRmb)
def Settings():
   coat.menu_item("ShowDensityNearVolumes")
   coat.menu_item("ShowPolycountNearVolumes")

S_tree = MenuSection(VoxTreeRmb)

@d_submenu("LiveBooleans", S_tree)
def LiveBooleans():
       coat.menu_item("BooleanRules")
       coat.menu_item("CollapseBoolTree")
       coat.menu_item("CloneCollapsedBTree")
       coat.menu_item("LiveSubtraction")
       coat.menu_item("LiveIntersection")
       coat.menu_item("LiveUnion")
       coat.menu_item("NormalSculptLayer")
 
@d_menu_section(VoxTreeRmb)
def S_Show():
   coat.menu_item("ShowAll")
   coat.menu_item("ShowSubtree")
@d_menu_section(VoxTreeRmb)
def S_Voxtree():
   coat.menu_item("DelVoxTree")
   coat.menu_item("AddVoxTree")
   coat.menu_item("RenameVoxTree")
@d_menu_section(VoxTreeRmb)
def S_Dencity():
   coat.menu_item("IncDencity2X")
   coat.menu_item("DecDencity2X")
   if(NoCache):
       coat.menu_item("ToGlobalSpace")
       coat.menu_item("ToUniformSpace")
       coat.menu_item("Resample")
       coat.menu_item("AxialSymmetry")
       coat.menu_separator()
       coat.menu_item("ExtrudeVO")
       if(Surface):
           coat.menu_item("CreateSurfaceShell")
           coat.menu_item("CloseSurfaceHoles")
           coat.menu_item("Decompose")
     
       else:
           MakeHull()
         
           coat.menu_item("CloseHoles")
           coat.menu_item("CloseInnerTunnels")
     
@d_submenu("MakeHull")
def MakeHull():        
                    coat.menu_item("MakeVoxHull")
                    coat.menu_item("MakeSurfHull")
 
@d_menu_section(VoxTreeRmb)
def S_Vox():
   coat.menu_item("SaveVox3B")
   coat.menu_item("SaveVoxSubtree3B")
   coat.menu_item("MergeVox3B")
   coat.menu_insert_extensions("Voxels")
   coat.menu_item("EditShaderSettings")
   if coat.menu_property("ObjectHasNodes"):
       coat.menu_item("BakeNodesToGeometry")
 
   if NoCache:
       if coat.menu_submenu("rmbImport"):
           coat.menu_item("MergeCloud")
           coat.menu_item("MergeObject")
           coat.menu_exit()
     
 
@d_submenu("Export", S_tree)
def Export():
       coat.menu_item("ExportScene")
       coat.menu_item("ExportSelObject")
       coat.menu_item("ExportPatternForMerge")
       coat.menu_item("ExportCurveProfile")
       if coat.ue5_support():
           coat.menu_separator()
           coat.menu_item("DecimateAutoMapExport")
     
S_Autopo = MenuSection(VoxTreeRmb)

@d_submenu("AUTOPO", S_Autopo)
def AUTOPO():
       coat.menu_item("Quadrangulate")
       coat.menu_item("QuadrangulateAndMergePtex")
       coat.menu_item("QuadrangulateAndMerge")
       coat.menu_item("QuadrangulateAndMergeDP")
       coat.menu_separator()
       coat.menu_item("OldStyleQuads")
       coat.menu_separator()
       coat.menu_item("CustomRetopers")
 
       if coat.RoomExists("Retopo"):
            coat.menu_item("DecimateToRetopo")
            coat.menu_item("DecimateAllToRetopo")

@d_menu_section(VoxTreeRmb)
def S_transform():
   coat.menu_item("TransformVoxTree")
   coat.menu_item("PutOnGround")
   coat.menu_item("LayOnGround")

@d_submenu("Clone", VoxTreeRmb)
def Clone():
       coat.menu_item("CloneInstance")
       coat.menu_item("InstanceToParentInstances")
       coat.menu_item("CloneVoxTree")
       coat.menu_item("CloneInstanceSymm")
       coat.menu_item("CloneSymm")
       coat.menu_item("CloneDegrade")
       coat.menu_item("CloneSpace")
 
@d_submenu("Flip", VoxTreeRmb)
def Flip():
       global Surface
       coat.menu_item("VoxFlipX")
       coat.menu_item("VoxFlipY")
       coat.menu_item("VoxFlipZ")
       if Surface:
           coat.menu_item("FlipNormals")
     
 
@d_menu_section(VoxTreeRmb)
def S_BakeColorsFromAllVolumes():
   coat.menu_item("BakeColorsFromAllVolumes")
@d_menu_section(VoxTreeRmb)
def S_SoftBooleansForVolumes():
   coat.menu_item("SoftBooleansForVolumes")

@d_submenu("MergeMove", VoxTreeRmb)
def MergeMove():
       if(Surface):
           coat.menu_item("PlainMergeVisible")
           coat.menu_item("PlainMergeSubtree")
           coat.menu_item("PlainMergeSelected")
           coat.menu_item("PlainMergeTo")
           coat.menu_item("PlainMoveTo")
           coat.menu_separator()
     
       coat.menu_item("MergeVisible")
       coat.menu_item("MergeSubtree")
       coat.menu_item("MergeSelected")
       coat.menu_item("MergeTo")
       coat.menu_item("MoveTo")
 
@d_menu_section(VoxTreeRmb)
def S_ops():
   coat.menu_item("CopySubtractFrom")
   coat.menu_item("SubtractFrom")
   coat.menu_item("IntersectWith")
   coat.menu_item("RemoveIntersectionWith")
   coat.menu_item("SplitWith")
   coat.menu_item("ChangeParent")
   coat.menu_item("IntersectionCurveWith")

